/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.metadata.provider;

import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.DateTimeValue;
import com.cognos.xqe.metadata.ICatalog;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.IMeasure;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.IModelDataSource;
import com.cognos.xqe.metadata.INamespace;
import com.cognos.xqe.metadata.IVariable;
import com.cognos.xqe.metadata.MetadataType;
import com.cognos.xqe.metadata.provider.Dimension;
import com.cognos.xqe.metadata.provider.Metadata;
import com.cognos.xqe.util.UniqueNameGenerator;
import com.cognos.xqe.util.bean.BeanPropertySupport;
import com.cognos.xqe.util.xml.XMLWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class Cube
extends Metadata
implements ICube {
    private static final BeanPropertySupport BEAN_PROPERTY_SUPPORT = new BeanPropertySupport(Cube.class);
    static final long serialVersionUID = 7647274105530911872L;
    protected IModelDataSource datasource = null;
    protected INamespace namespace = null;
    protected List<IDimension> dimensions = new ArrayList<IDimension>();
    protected Map<String, IDimension> dimensionsLookup = new HashMap<String, IDimension>();
    protected DateTimeValue updatedDate = null;
    protected DateTimeValue createdDate = null;
    protected DateTimeValue schemaUpdatedDate;
    protected String schemaName;
    protected ICatalog catalog;
    protected String catalogName;
    protected IMeasure defaultMeasure;
    protected ICube.CubeSuppressionTypeEnum suppressionType = ICube.CubeSuppressionTypeEnum.NULL;
    private Lock dimensionsReadLock;
    private Lock dimensionsWriteLock;

    @Override
    public DateTimeValue getCreatedDate() {
        return this.createdDate;
    }

    public void setCreatedDate(DateTimeValue createdDateParam) {
        this.createdDate = createdDateParam;
    }

    @Override
    public INamespace getNamespace() {
        return this.namespace;
    }

    public void setNamespace(INamespace aNamespace) {
        this.namespace = aNamespace;
    }

    @Override
    public DateTimeValue getUpdatedDate() {
        return this.updatedDate;
    }

    public void setUpdatedDate(DateTimeValue lastUpdatedDateParam) {
        this.updatedDate = lastUpdatedDateParam;
    }

    public Cube(String objectName) {
        super(objectName);
        this.updatedDate = DataValueFactory.createTimestampValue();
        this.createdDate = DataValueFactory.createTimestampValue();
        this.schemaUpdatedDate = DataValueFactory.createTimestampValue();
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock(true);
        this.dimensionsReadLock = lock.readLock();
        this.dimensionsWriteLock = lock.writeLock();
    }

    public Cube(String theCatalogName, String objectName) {
        super(objectName);
        this.updatedDate = DataValueFactory.createTimestampValue();
        this.createdDate = DataValueFactory.createTimestampValue();
        this.schemaUpdatedDate = DataValueFactory.createTimestampValue();
        this.catalogName = theCatalogName;
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock(true);
        this.dimensionsReadLock = lock.readLock();
        this.dimensionsWriteLock = lock.writeLock();
    }

    public Cube() {
        this.updatedDate = DataValueFactory.createTimestampValue();
        this.createdDate = DataValueFactory.createTimestampValue();
        this.schemaUpdatedDate = DataValueFactory.createTimestampValue();
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock(true);
        this.dimensionsReadLock = lock.readLock();
        this.dimensionsWriteLock = lock.writeLock();
    }

    @Override
    public IModelDataSource getModelDataSource() {
        return this.datasource;
    }

    @Override
    public List<IDimension> getDimensions() {
        this.initialiseChildren();
        this.dimensionsReadLock.lock();
        try {
            ArrayList<IDimension> arrayList = new ArrayList<IDimension>(this.dimensions);
            return arrayList;
        }
        finally {
            this.dimensionsReadLock.unlock();
        }
    }

    public void setDataSource(IModelDataSource dataSource) {
        this.datasource = dataSource;
    }

    @Override
    public int getDimensionCount() {
        return this.dimensions.size();
    }

    @Override
    public IDimension getDimension(String name) {
        if (name == null || name.length() == 0) {
            return null;
        }
        this.initialiseChildren();
        this.dimensionsReadLock.lock();
        try {
            IDimension iDimension = this.dimensionsLookup.get(name);
            return iDimension;
        }
        finally {
            this.dimensionsReadLock.unlock();
        }
    }

    @Override
    public IHierarchy getHierarchy(String name) {
        return null;
    }

    @Override
    public IHierarchy getMeasuresHierarchy() {
        IDimension dimension;
        int i;
        List<IDimension> cubeDimensions = this.getDimensions();
        for (i = 0; i < cubeDimensions.size(); ++i) {
            dimension = (Dimension)cubeDimensions.get(i);
            if (!((Metadata)((Object)dimension)).isInitialised() || !((Dimension)dimension).isMeasuresDimension()) continue;
            return ((Dimension)dimension).getDefaultHierarchy();
        }
        for (i = 0; i < cubeDimensions.size(); ++i) {
            dimension = cubeDimensions.get(i);
            if (!dimension.isMeasuresDimension()) continue;
            return dimension.getDefaultHierarchy();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDimension(IDimension dim) {
        IDimension iDimension = dim;
        synchronized (iDimension) {
            this.dimensionsWriteLock.lock();
            try {
                this.dimensions.add(dim);
                if (dim instanceof Dimension) {
                    ((Dimension)dim).setCube(this);
                }
                this.dimensionsLookup.put(dim.getUniqueName(), dim);
            }
            finally {
                this.dimensionsWriteLock.unlock();
            }
        }
    }

    @Override
    public int getDimensionIndex(IDimension d) {
        List<IDimension> dims = this.getDimensions();
        return dims.indexOf(d);
    }

    @Override
    public IDimension getDimension(int index) {
        if (index < 0 || index >= this.getDimensionCount()) {
            return null;
        }
        this.initialiseChildren();
        this.dimensionsReadLock.lock();
        try {
            IDimension iDimension = this.dimensions.get(index);
            return iDimension;
        }
        finally {
            this.dimensionsReadLock.unlock();
        }
    }

    @Override
    public boolean getPropagateNulls() {
        return false;
    }

    @Override
    public ICatalog getCatalog() {
        return this.catalog;
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    public void setCatalog(ICatalog theCatalog) {
        this.catalog = theCatalog;
    }

    @Override
    public DateTimeValue getSchemaUpdatedDate() {
        return this.schemaUpdatedDate;
    }

    public void setSchemaUpdatedDate(DateTimeValue theSchemaUpdatedDate) {
        this.schemaUpdatedDate = theSchemaUpdatedDate;
    }

    @Override
    public IMeasure getDefaultMeasure() {
        if (null == this.defaultMeasure) {
            IHierarchy measuresHierarchy = this.getMeasuresHierarchy();
            if (null == measuresHierarchy) {
                return null;
            }
            IMember mem = this.getMeasuresHierarchy().getDefaultMember();
            if (null != mem && mem.isMeasure()) {
                this.defaultMeasure = (IMeasure)mem;
            }
        }
        return this.defaultMeasure;
    }

    public void setDefaultMeasure(IMeasure theDefaultMeasure) {
        this.defaultMeasure = theDefaultMeasure;
    }

    @Override
    public ICube.CubeSuppressionTypeEnum getSuppressionType() {
        return this.suppressionType;
    }

    public void setSuppressionType(ICube.CubeSuppressionTypeEnum theSuppressionType) {
        this.suppressionType = theSuppressionType;
    }

    @Override
    public String getV5UniqueName() {
        if (this.v5UniqueName == null) {
            this.v5UniqueName = UniqueNameGenerator.createV5UniqueName(this);
        }
        return this.v5UniqueName;
    }

    @Override
    public final MetadataType getObjectType() {
        return MetadataType.CUBE;
    }

    @Override
    public BeanPropertySupport getBeanPropertySupport() {
        return BEAN_PROPERTY_SUPPORT;
    }

    @Override
    public List<IVariable> getVariables() {
        return null;
    }

    @Override
    public void toXML(XMLWriter xmlWriter) {
        xmlWriter.beginElement("Cube", -1);
        xmlWriter.attribute("name", this.getName());
        xmlWriter.beginElement("CubeName", -1);
        xmlWriter.data(this.getName());
        xmlWriter.endElement();
        int dimSize = this.getDimensionCount();
        for (int i = 0; i < dimSize; ++i) {
            IDimension dim = this.getDimension(i);
            if (!(dim instanceof Dimension)) continue;
            ((Dimension)dim).toXML(xmlWriter);
        }
        xmlWriter.endElement();
    }

    @Override
    public IDimension getMeasureDimension() {
        List<IDimension> dimension = this.getDimensions();
        if (dimension == null) {
            return null;
        }
        int dimCnt = dimension.size();
        for (int i = 0; i < dimCnt; ++i) {
            IDimension dim = dimension.get(i);
            if (!dim.isMeasuresDimension()) continue;
            return dim;
        }
        return null;
    }

    @Override
    public IDimension queryDimension(String dimensionUName) {
        return null;
    }

    @Override
    public boolean hasSAPReplacementVariable() {
        return false;
    }

    @Override
    public boolean isReplacementVariableUsed(IDimension dimension) {
        return false;
    }

    @Override
    public ICube.CubeTypeEnum getType() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getCubeCurrentPeriod() {
        return null;
    }
}

