/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.metadata.provider;

import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.types.MemberType;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.StringValue;
import com.cognos.xqe.data.values.TextValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.data.values.ValueMethodNotImplementedException;
import com.cognos.xqe.data.values.ValueSizeInfo;
import com.cognos.xqe.data.values.VarcharValue;
import com.cognos.xqe.metadata.AggregateTypeEnum;
import com.cognos.xqe.metadata.IAggregateRule;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.IProperty;
import com.cognos.xqe.metadata.MemberTypeEnum;
import com.cognos.xqe.metadata.MetadataType;
import com.cognos.xqe.metadata.RollupTypeEnum;
import com.cognos.xqe.metadata.provider.Dimension;
import com.cognos.xqe.metadata.provider.Folder;
import com.cognos.xqe.metadata.provider.Hierarchy;
import com.cognos.xqe.metadata.provider.Level;
import com.cognos.xqe.metadata.provider.Metadata;
import com.cognos.xqe.util.UniqueNameGenerator;
import com.cognos.xqe.util.bean.BeanClassIntrospection;
import com.cognos.xqe.util.bean.BeanPropertySupport;
import com.cognos.xqe.util.xml.XMLWriter;
import com.ibm.icu.text.Collator;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

@BeanClassIntrospection(enabled=false)
public class Member
extends Metadata
implements IMember {
    private static final BeanPropertySupport BEAN_PROPERTY_SUPPORT = new BeanPropertySupport(Member.class);
    private static final String UNAME_STR = "UName";
    private static final String DYN_PROP_STR = "DynamicProperty";
    static final long serialVersionUID = 7647274105530911872L;
    protected Member parent = null;
    protected String parentUniqueName = null;
    protected ILevel level = null;
    protected int parentLevelNumber = -1;
    protected List<IMember> children = new ArrayList<IMember>();
    protected int numberOfParents = 0;
    protected int childrenCardinality = 0;
    protected MemberTypeEnum type = MemberTypeEnum.UNKNOWN;
    protected RollupTypeEnum rollupType = RollupTypeEnum.ROLLUP;
    protected boolean suppressed = false;
    protected Value businessKey = null;
    protected Lock childrenReadLock;
    protected Lock childrenWriteLock;

    public Member(String objectName) {
        super(objectName);
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock(true);
        this.childrenReadLock = lock.readLock();
        this.childrenWriteLock = lock.writeLock();
    }

    public Member() {
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock(true);
        this.childrenReadLock = lock.readLock();
        this.childrenWriteLock = lock.writeLock();
    }

    @Override
    public boolean isNull() {
        return false;
    }

    @Override
    public void setNull() throws ValueMethodNotImplementedException {
        throw new ValueMethodNotImplementedException(this.getClass().getName() + ".setNull()");
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public Object hashKey(Collator collator) {
        VarcharValue key = DataValueFactory.createVarcharValue(collator);
        key.set(this.getUniqueName());
        return key;
    }

    @Override
    public boolean equals(Object other) {
        if (null == other) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (other instanceof TextValue) {
            TextValue otherTextValue = (TextValue)other;
            String tmp = this.getCaption();
            if (null == tmp) {
                return otherTextValue.isNull();
            }
            return tmp == otherTextValue.getString() || tmp.equals(otherTextValue.getString());
        }
        return super.equals(other);
    }

    @Override
    public int compareTo(Object other) {
        if (null == other) {
            return -1;
        }
        if (this == other) {
            return 0;
        }
        if (other instanceof TextValue) {
            TextValue otherTextValue = (TextValue)other;
            String tmp = this.getCaption();
            if (null == tmp) {
                if (otherTextValue.isNull()) {
                    return 0;
                }
                return -1;
            }
            if (tmp.equals(otherTextValue.getString())) {
                return 0;
            }
            return otherTextValue.compareTo(tmp) * -1;
        }
        return super.compareTo(other);
    }

    @Override
    public boolean isCalculatedMember() {
        return this.type != MemberTypeEnum.REGULAR && this.type != MemberTypeEnum.UNKNOWN;
    }

    @Override
    public boolean isExtendedCalculatedMember() {
        return false;
    }

    @Override
    public boolean isExtendedCalculatedMemberTypeChildRef() {
        return false;
    }

    @Override
    public boolean isExtendedCalculatedMemberWithFormula() {
        return false;
    }

    @Override
    public boolean isProviderDefaultMember() {
        return false;
    }

    @Override
    public IMember getDataMember() {
        return this;
    }

    @Override
    public List<IMember> getChildren() {
        return new ArrayList<IMember>(this.children);
    }

    @Override
    public IMember getParent() {
        return this.parent;
    }

    protected void setParent(Member member) {
        this.parent = member;
    }

    @Override
    public String getParentUniqueName() {
        this.initialiseProperties();
        return this.parentUniqueName;
    }

    @Override
    public MetadataType getObjectType() {
        return MetadataType.MEMBER;
    }

    @Override
    public synchronized ILevel getLevel() {
        if (this.level == null) {
            Metadata obj = (Metadata)this.getConnection().getParentObject(this);
            while (obj instanceof Folder) {
                obj = (Metadata)this.getConnection().getParentObject(obj);
            }
            if (obj instanceof Level) {
                this.level = (Level)obj;
            } else if (obj instanceof Dimension) {
                Dimension dim = (Dimension)obj;
                IHierarchy hier = dim.getDefaultHierarchy();
                this.level = hier.getLevel(0);
            } else if (obj instanceof IMember) {
                int levelCount = 0;
                while (obj != null && !(obj instanceof Dimension)) {
                    ++levelCount;
                    obj = (Metadata)this.getConnection().getParentObject(obj);
                }
                Dimension dim = (Dimension)obj;
                Hierarchy hier = (Hierarchy)dim.getDefaultHierarchy();
                this.level = hier.getLevel(levelCount);
            }
        }
        return this.level;
    }

    @Override
    public int getParentLevelNumber() {
        this.initialiseProperties();
        return this.parentLevelNumber;
    }

    public void setParentLevelNumber(int theParentLevelNumber) {
        this.parentLevelNumber = theParentLevelNumber;
    }

    public synchronized void setLevel(ILevel refLevel) {
        this.level = refLevel;
    }

    public void addChild(Member member) {
        this.childrenWriteLock.lock();
        try {
            this.children.add(member);
        }
        finally {
            this.childrenWriteLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IMember> getChildren(int startIndex, int count) {
        this.childrenReadLock.lock();
        try {
            List<IMember> list = this.children.subList(startIndex, startIndex + count);
            return list;
        }
        finally {
            this.childrenReadLock.unlock();
        }
    }

    @Override
    public int getChildrenCardinality() {
        this.initialiseProperties();
        return this.childrenCardinality;
    }

    public void setChildrenCardinality(int theChildrenCardinality) {
        this.childrenCardinality = theChildrenCardinality;
    }

    @Override
    public boolean isMeasure() {
        IDimension dimension = this.getDimension();
        if (dimension != null) {
            return this.getDimension().isMeasuresDimension();
        }
        return false;
    }

    @Override
    public IDataType getDataType() {
        return MemberType.MEMBERTYPE;
    }

    @Override
    public Object copy() {
        return this;
    }

    @Override
    public boolean isContextMember() {
        return false;
    }

    @Override
    public int getChildIndex(IMember child) {
        return -1;
    }

    @Override
    public IMember[] getChildMembers() {
        List<IMember> childList = this.getChildren();
        IMember[] members = new IMember[childList.size()];
        childList.toArray(members);
        return members;
    }

    @Override
    public IMember getChildMember(String memberName) {
        return null;
    }

    @Override
    public IHierarchy getHierarchy() {
        if (this.getLevel() != null) {
            return this.getLevel().getHierarchy();
        }
        return null;
    }

    @Override
    public IDimension getDimension() {
        IHierarchy hierarchy = this.getHierarchy();
        if (hierarchy != null) {
            return hierarchy.getDimension();
        }
        return null;
    }

    @Override
    public IMember[] getSiblings(boolean includeSelf) {
        return null;
    }

    @Override
    public void toXML(XMLWriter xmlWriter) {
        xmlWriter.beginElement("Member", -1);
        xmlWriter.attribute("Hierarchy", this.level.getHierarchy().getUniqueName());
        xmlWriter.beginElement(UNAME_STR, -1);
        xmlWriter.data(this.getUniqueName());
        xmlWriter.endElement();
        xmlWriter.beginElement("Caption", -1);
        xmlWriter.data(this.getCaption());
        xmlWriter.endElement();
        xmlWriter.beginElement("LName", -1);
        xmlWriter.data(this.level.getUniqueName());
        xmlWriter.endElement();
        xmlWriter.beginElement("LNum", -1);
        xmlWriter.data(String.valueOf(this.level.getIndex()));
        xmlWriter.endElement();
        if (this.getParentUniqueName() != null && !this.getParentUniqueName().isEmpty()) {
            xmlWriter.beginElement("PUN", -1);
            xmlWriter.data(this.getParentUniqueName());
            xmlWriter.endElement();
        }
        if (this.level != null && this.hasDynamicProperties()) {
            for (String propKey : this.getDynamicProperties().keySet()) {
                IProperty prop;
                Object propValue = this.getProperty(propKey);
                if (propValue == null) continue;
                int lastPos = propKey.lastIndexOf(".[");
                String propName = propKey;
                if (lastPos > 0) {
                    propName = propKey.substring(lastPos + 2, propKey.length() - 1);
                }
                if (null != (prop = this.level.getMemberProperty(propName))) {
                    if (!prop.isCustomProperty()) continue;
                    xmlWriter.beginElement(DYN_PROP_STR, -1);
                    xmlWriter.attribute("name", prop.getName());
                    xmlWriter.data(propValue.toString());
                    xmlWriter.endElement();
                    continue;
                }
                xmlWriter.beginElement(DYN_PROP_STR, -1);
                xmlWriter.attribute(UNAME_STR, propKey);
                xmlWriter.data(propValue.toString());
                xmlWriter.endElement();
            }
        }
        xmlWriter.endElement();
    }

    @Override
    public AggregateTypeEnum getRegularAggregate() {
        throw new UnsupportedOperationException();
    }

    @Override
    public AggregateTypeEnum getSemiAggregate() {
        throw new UnsupportedOperationException();
    }

    @Override
    public IAggregateRule[] getAggregateRules() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object getBusinessKey() {
        this.initialiseProperties();
        return (String)this.getProperty("MEMBER_KEY");
    }

    @Override
    public Value getBusinessKeyValue() {
        this.initialiseProperties();
        return this.businessKey;
    }

    @Override
    public Value getCaptionValue() {
        StringValue v = DataValueFactory.createStringValue();
        ((Value)v).set(this.getCaption());
        return v;
    }

    @Override
    public int sizeOf() {
        return ValueSizeInfo.getSizeOf(ValueSizeInfo.ValueEntry.DEFAULT);
    }

    @Override
    public String toString() {
        return this.getCaption();
    }

    @Override
    public int getNumberOfParents() {
        this.initialiseProperties();
        return this.numberOfParents;
    }

    public void setNumberOfParents(int theNumberOfParents) {
        this.numberOfParents = theNumberOfParents;
    }

    @Override
    public MemberTypeEnum getType() {
        this.initialiseProperties();
        return this.type;
    }

    public void setType(MemberTypeEnum theType) {
        this.type = theType;
    }

    @Override
    public RollupTypeEnum getRollupType() {
        this.initialiseProperties();
        return this.rollupType;
    }

    public void setRollupType(RollupTypeEnum rollupTypeEnum) {
        this.rollupType = rollupTypeEnum;
    }

    @Override
    public boolean isSuppressed() {
        this.initialiseProperties();
        return this.suppressed;
    }

    public void setSuppressed(boolean theIsSuppressed) {
        this.suppressed = theIsSuppressed;
    }

    public void setParentUniqueName(String theParentUniqueName) {
        this.parentUniqueName = theParentUniqueName;
    }

    @Override
    public BeanPropertySupport getBeanPropertySupport() {
        return BEAN_PROPERTY_SUPPORT;
    }

    @Override
    public String getV5UniqueName() {
        if (this.v5UniqueName == null) {
            this.v5UniqueName = UniqueNameGenerator.createMemberV5UniqueName(this.level, this.getUniqueName());
        }
        return this.v5UniqueName;
    }

    public void setBusinessKey(Value theBusinessKey) {
        this.businessKey = theBusinessKey;
    }

    public boolean isContextValue() {
        return false;
    }

    @Override
    protected void copyFrom(Metadata from) {
        Member fromMember = (Member)from;
        super.copyFrom(from);
        this.businessKey = fromMember.businessKey;
        this.children = fromMember.children;
        this.level = fromMember.level;
        this.numberOfParents = fromMember.numberOfParents;
        this.parent = fromMember.parent;
        this.parentLevelNumber = fromMember.parentLevelNumber;
        this.parentUniqueName = fromMember.parentUniqueName;
        this.rollupType = fromMember.rollupType;
        this.suppressed = fromMember.suppressed;
        this.type = fromMember.type;
    }

    @Override
    public void release() {
    }

    @Override
    public boolean isRelational() {
        return false;
    }

    @Override
    public boolean isDataBaseCalculation() {
        return false;
    }

    @Override
    public String getV5MUN() {
        return null;
    }
}

