/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.metadata.provider.nativeodp;

import com.cognos.xqe.data.providers.olap.MetadataRestriction;
import com.cognos.xqe.data.providers.olap.RestrictionType;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.metadata.ICatalog;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.MetadataType;
import com.cognos.xqe.metadata.provider.nativeodp.NativeCube;
import com.cognos.xqe.metadata.provider.nativeodp.NativeMetadata;
import com.cognos.xqe.metadata.provider.nativeodp.NativeMetadataConnection;
import com.cognos.xqe.metadata.provider.nativeodp.NativeNamespace;
import com.cognos.xqe.metadata.record.CatalogRecord;
import com.cognos.xqe.metadata.record.CubeRecord;
import com.cognos.xqe.metadata.record.MetadataRecord;
import com.cognos.xqe.util.CollectionCast;
import com.cognos.xqe.util.bean.BeanClassIntrospection;
import com.cognos.xqe.util.bean.BeanMethodIntrospection;
import com.cognos.xqe.util.bean.BeanPropertySupport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

@BeanClassIntrospection(enabled=false)
public class NativeCatalog
extends NativeMetadata
implements ICatalog {
    private static final BeanPropertySupport BEAN_PROPERTY_SUPPORT = new BeanPropertySupport(NativeCatalog.class);
    private final NativeNamespace rootNamespace;
    private final CatalogRecord record;
    private volatile List<NativeCube> cubes = null;
    private final Object cubesInitLock = new Object();
    private AtomicBoolean areAllCubesLoaded = new AtomicBoolean(false);

    NativeCatalog(NativeMetadataConnection theMDConnection, CatalogRecord theRecord, NativeNamespace theRootNamespace) {
        super(theMDConnection);
        this.record = theRecord;
        this.rootNamespace = theRootNamespace;
    }

    @Override
    protected MetadataRecord getRecord() {
        return this.record;
    }

    @Override
    public BeanPropertySupport getBeanPropertySupport() {
        return BEAN_PROPERTY_SUPPORT;
    }

    @Override
    public ICube[] getCubes() {
        this.initializeCubes(null);
        return this.cubes.toArray(new ICube[0]);
    }

    @Override
    public ICube getCube(String cubeName) {
        NativeCube result = this.getNativeConnection().getCachedCube(this.getName(), cubeName);
        if (null != result) {
            return result;
        }
        this.initializeCubes(cubeName);
        return this.getNativeConnection().getCachedCube(this.getName(), cubeName);
    }

    @Override
    @BeanMethodIntrospection(enabled=true)
    public IDataType getDataType() {
        return DataTypeFactory.getStringType();
    }

    @Override
    @BeanMethodIntrospection(enabled=true)
    public MetadataType getObjectType() {
        return MetadataType.CATALOG;
    }

    @Override
    public IMetadata getParentObject() {
        return this.rootNamespace;
    }

    @Override
    public boolean hasChildMetadataObjects() {
        this.initializeCubes(null);
        return this.cubes.size() > 0;
    }

    @Override
    public List<IMetadata> getChildMetadataObjects() {
        this.initializeCubes(null);
        List<NativeCube> result = Collections.unmodifiableList(this.cubes);
        return CollectionCast.upcast(result, IMetadata.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeCubes(String cubeName) {
        if (this.areAllCubesLoaded.compareAndSet(false, true)) {
            Object object = this.cubesInitLock;
            synchronized (object) {
                if (cubeName == null || this.cubes == null) {
                    this.cubes = new LinkedList<NativeCube>();
                }
                NativeMetadataConnection connection = this.getNativeConnection();
                ArrayList<NativeCube> theList = new ArrayList<NativeCube>();
                MetadataRestriction restrictions = new MetadataRestriction();
                if (cubeName != null) {
                    restrictions.add(RestrictionType.CUBE, cubeName);
                }
                restrictions.add(RestrictionType.CATALOG, this.getName());
                List<CubeRecord> cubeRecords = this.getMetadataProvider().getCubes(restrictions);
                for (CubeRecord cubeRecord : cubeRecords) {
                    NativeCube theCube = new NativeCube(connection, cubeRecord, this);
                    theList.add(theCube);
                    connection.putCachedCube(theCube);
                }
                this.cubes.addAll(theList);
            }
        }
    }
}

