/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.metadata.record;

import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.metadata.MetadataKey;
import com.cognos.xqe.metadata.record.ExternalizeUtil;
import com.cognos.xqe.metadata.record.MetadataRecord;
import com.cognos.xqe.metadata.record.RecordType;
import com.cognos.xqe.util.xml.serializer.XMLElement;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

@XMLElement
public class MacroRecord
extends MetadataRecord {
    @XMLElement
    private String catalogName = "";
    @XMLElement
    private String schemaName = "";
    @XMLElement
    private String cubeName = "";
    @XMLElement
    private IDataType dataType = DataTypeFactory.getStringType();
    @XMLElement
    private String expression = null;

    @Override
    public RecordType getRecordType() {
        return RecordType.MACRO;
    }

    @Override
    public MetadataKey uniqueKey() {
        if (null == this.cachedUniqueKey) {
            Object[] components = new Object[]{this.getRecordType(), this.getCatalogName(), this.getSchemaName(), this.getCubeName(), this.getUniqueName()};
            this.cachedUniqueKey = new MetadataKey(components);
        }
        return this.cachedUniqueKey;
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getCubeName() {
        return this.cubeName;
    }

    public IDataType getDataType() {
        return this.dataType;
    }

    public String getExpression() {
        return this.expression;
    }

    public void setCatalogName(String theCatalogName) {
        MacroRecord.assertNotNull(theCatalogName);
        this.catalogName = MacroRecord.internalizeString(theCatalogName);
    }

    public void setSchemaName(String theSchemaName) {
        MacroRecord.assertNotNull(theSchemaName);
        this.schemaName = MacroRecord.internalizeString(theSchemaName);
    }

    public void setCubeName(String theCubeName) {
        MacroRecord.assertNotNull(theCubeName);
        this.cubeName = MacroRecord.internalizeString(theCubeName);
    }

    public void setDataType(IDataType theDataType) {
        MacroRecord.assertNotNull(theDataType);
        this.dataType = theDataType;
    }

    public void setExpression(String theExpression) {
        this.expression = theExpression;
    }

    @Override
    public void externalize(DataOutput output) throws IOException {
        super.externalize(output);
        ExternalizeUtil.externalizeString(output, this.getCatalogName());
        ExternalizeUtil.externalizeString(output, this.getSchemaName());
        ExternalizeUtil.externalizeString(output, this.getCubeName());
        ExternalizeUtil.externalizeDataType(output, this.getDataType());
        ExternalizeUtil.externalizeString(output, this.getExpression());
    }

    @Override
    public void deexternalize(DataInput input) throws IOException {
        super.deexternalize(input);
        this.setCatalogName(ExternalizeUtil.deexternalizeString(input));
        this.setSchemaName(ExternalizeUtil.deexternalizeString(input));
        this.setCubeName(ExternalizeUtil.deexternalizeString(input));
        this.setDataType(ExternalizeUtil.deexternalizeDataType(input));
        this.setExpression(ExternalizeUtil.deexternalizeString(input));
    }

    public void copyTo(MacroRecord theCopy) {
        super.copyTo(theCopy);
        theCopy.setCatalogName(this.getCatalogName());
        theCopy.setSchemaName(this.getSchemaName());
        theCopy.setCubeName(this.getCubeName());
        theCopy.setDataType(this.getDataType());
        theCopy.setExpression(this.getExpression());
    }

    @Override
    public Object copy() {
        MacroRecord clonedRecord = new MacroRecord();
        this.copyTo(clonedRecord);
        return clonedRecord;
    }
}

