/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.metadata.record;

import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.metadata.AggregateRule;
import com.cognos.xqe.metadata.AggregateTypeEnum;
import com.cognos.xqe.metadata.IAggregateRule;
import com.cognos.xqe.metadata.MetadataKey;
import com.cognos.xqe.metadata.record.ExternalizeUtil;
import com.cognos.xqe.metadata.record.MetadataRecord;
import com.cognos.xqe.metadata.record.RecordType;
import com.cognos.xqe.util.xml.serializer.XMLElement;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;

@XMLElement
public class MeasureRecord
extends MetadataRecord {
    private static final String DISPLAY_PATH = "Display_Path";
    private static final String TIMESTATE_AGGREGATOR_DIMENSION = "Timestate_Aggregator_Dimension";
    public static final String UNITS_CURRENCY = "Currency";
    private static final String MEASURE_FOLDER = "Measure_Folder";
    private static final String IS_HIDDEN = "Is_Hidden";
    @XMLElement
    private String catalogName = "";
    @XMLElement
    private String schemaName = "";
    @XMLElement
    private String cubeName = "";
    @XMLElement
    private String dimensionUniqueName = null;
    @XMLElement
    private String hierarchyUniqueName = null;
    @XMLElement
    private String levelUniqueName = null;
    @XMLElement
    private IDataType dataType = DataTypeFactory.getDoubleType();
    @XMLElement
    private String units = null;
    @XMLElement(callMethod="name")
    private AggregateTypeEnum regularAggregate = AggregateTypeEnum.UNKNOWN;
    @XMLElement(callMethod="name")
    private AggregateTypeEnum semiAggregate = AggregateTypeEnum.UNKNOWN;
    @XMLElement
    private IAggregateRule[] aggregateRules = null;

    @Override
    public RecordType getRecordType() {
        return RecordType.MEASURE;
    }

    @Override
    public MetadataKey uniqueKey() {
        if (null == this.cachedUniqueKey) {
            Object[] components = new Object[]{this.getRecordType(), this.getCatalogName(), this.getSchemaName(), this.getCubeName(), this.getUniqueName()};
            this.cachedUniqueKey = new MetadataKey(components);
        }
        return this.cachedUniqueKey;
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getCubeName() {
        return this.cubeName;
    }

    public String getDimensionUniqueName() {
        return this.dimensionUniqueName;
    }

    public String getHierarchyUniqueName() {
        return this.hierarchyUniqueName;
    }

    public String getLevelUniqueName() {
        return this.levelUniqueName;
    }

    public IDataType getDataType() {
        return this.dataType;
    }

    public String getUnits() {
        return this.units;
    }

    public AggregateTypeEnum getRegularAggregate() {
        return this.regularAggregate;
    }

    public AggregateTypeEnum getSemiAggregate() {
        return this.semiAggregate;
    }

    public IAggregateRule[] getAggregateRules() {
        return this.aggregateRules;
    }

    public void setCatalogName(String theCatalogName) {
        MeasureRecord.assertNotNull(theCatalogName);
        this.catalogName = MeasureRecord.internalizeString(theCatalogName);
    }

    public void setSchemaName(String theSchemaName) {
        MeasureRecord.assertNotNull(theSchemaName);
        this.schemaName = MeasureRecord.internalizeString(theSchemaName);
    }

    public void setCubeName(String theCubeName) {
        MeasureRecord.assertNotNull(theCubeName);
        this.cubeName = MeasureRecord.internalizeString(theCubeName);
    }

    public void setDimensionUniqueName(String theDimensionUniqueName) {
        this.dimensionUniqueName = MeasureRecord.internalizeString(theDimensionUniqueName);
    }

    public void setHierarchyUniqueName(String theHierarchyUniqueName) {
        this.hierarchyUniqueName = MeasureRecord.internalizeString(theHierarchyUniqueName);
    }

    public void setLevelUniqueName(String theLevelUniqueName) {
        this.levelUniqueName = MeasureRecord.internalizeString(theLevelUniqueName);
    }

    public void setDataType(IDataType theDataType) {
        MeasureRecord.assertNotNull(theDataType);
        this.dataType = theDataType;
    }

    public void setUnits(String theUnits) {
        this.units = MeasureRecord.internalizeString(theUnits);
    }

    public void setRegularAggregate(AggregateTypeEnum theRegularAggregate) {
        this.regularAggregate = theRegularAggregate;
    }

    public void setSemiAggregate(AggregateTypeEnum theSemiAggregate) {
        this.semiAggregate = theSemiAggregate;
    }

    public void setAggregateRules(IAggregateRule[] aggregationRules) {
        this.aggregateRules = aggregationRules;
    }

    public void setDisplayPath(String theDisplayPath) {
        this.setDynamicFieldAsString(DISPLAY_PATH, theDisplayPath);
    }

    public String getDisplayPath() {
        return this.getDynamicFieldAsString(DISPLAY_PATH);
    }

    public void setTimestateAggregatorDimension(String dun) {
        this.setDynamicFieldAsString(TIMESTATE_AGGREGATOR_DIMENSION, dun);
    }

    public String getTimestateAggregatorDimension() {
        return this.getDynamicFieldAsString(TIMESTATE_AGGREGATOR_DIMENSION);
    }

    public Boolean getMeasureFolder() {
        Boolean measureFolder = this.getDynamicFieldAsBoolean(MEASURE_FOLDER);
        if (null != measureFolder) {
            return measureFolder;
        }
        return false;
    }

    public void setMeasureFolder(Boolean measureFolder) {
        this.setDynamicFieldAsBoolean(MEASURE_FOLDER, measureFolder);
    }

    @Override
    public void externalize(DataOutput output) throws IOException {
        super.externalize(output);
        ExternalizeUtil.externalizeString(output, this.getCatalogName());
        ExternalizeUtil.externalizeString(output, this.getSchemaName());
        ExternalizeUtil.externalizeString(output, this.getCubeName());
        ExternalizeUtil.externalizeString(output, this.getDimensionUniqueName());
        ExternalizeUtil.externalizeString(output, this.getHierarchyUniqueName());
        ExternalizeUtil.externalizeString(output, this.getLevelUniqueName());
        ExternalizeUtil.externalizeDataType(output, this.getDataType());
        ExternalizeUtil.externalizeString(output, this.getUnits());
        output.writeInt(this.getRegularAggregate().ordinal());
        output.writeInt(this.getSemiAggregate().ordinal());
    }

    @Override
    public void deexternalize(DataInput input) throws IOException {
        super.deexternalize(input);
        this.setCatalogName(ExternalizeUtil.deexternalizeString(input));
        this.setSchemaName(ExternalizeUtil.deexternalizeString(input));
        this.setCubeName(ExternalizeUtil.deexternalizeString(input));
        this.setDimensionUniqueName(ExternalizeUtil.deexternalizeString(input));
        this.setHierarchyUniqueName(ExternalizeUtil.deexternalizeString(input));
        this.setLevelUniqueName(ExternalizeUtil.deexternalizeString(input));
        this.setDataType(ExternalizeUtil.deexternalizeDataType(input));
        this.setUnits(ExternalizeUtil.deexternalizeString(input));
        this.setRegularAggregate(AggregateTypeEnum.valueOf(input.readInt()));
        this.setSemiAggregate(AggregateTypeEnum.valueOf(input.readInt()));
        this.setAggregateRules(null);
    }

    public boolean isHidden() {
        Boolean hidden = this.getDynamicFieldAsBoolean(IS_HIDDEN);
        if (null != hidden) {
            return hidden;
        }
        return false;
    }

    public void setHidden(Boolean theIsHidden) {
        this.setDynamicFieldAsBoolean(IS_HIDDEN, theIsHidden);
    }

    public void copyTo(MeasureRecord theCopy) {
        super.copyTo(theCopy);
        theCopy.setCatalogName(this.getCatalogName());
        theCopy.setSchemaName(this.getSchemaName());
        theCopy.setCubeName(this.getCubeName());
        theCopy.setDimensionUniqueName(this.getDimensionUniqueName());
        theCopy.setHierarchyUniqueName(this.getHierarchyUniqueName());
        theCopy.setLevelUniqueName(this.getLevelUniqueName());
        theCopy.setDataType(this.getDataType());
        theCopy.setUnits(this.getUnits());
        theCopy.setRegularAggregate(this.getRegularAggregate());
        theCopy.setSemiAggregate(this.getSemiAggregate());
        theCopy.setAggregateRules(this.getAggregateRules());
    }

    @Override
    public Object copy() {
        MeasureRecord clonedRecord = new MeasureRecord();
        this.copyTo(clonedRecord);
        return clonedRecord;
    }

    public static void externalizeAggregateRules(DataOutput output, IAggregateRule[] aggregationRules) throws IOException {
        if (null == aggregationRules) {
            output.writeInt(-1);
        } else {
            output.writeInt(aggregationRules.length);
            for (IAggregateRule rule : aggregationRules) {
                output.writeInt(rule.getAggregate().ordinal());
                ExternalizeUtil.externalizeString(output, rule.getDimensionRef());
            }
        }
    }

    public static IAggregateRule[] deexternalizeAggregateRules(DataInput input) throws IOException {
        int numRules = input.readInt();
        if (numRules < 0) {
            return null;
        }
        ArrayList<AggregateRule> aggregationRules = new ArrayList<AggregateRule>(numRules);
        for (int i = 0; i < numRules; ++i) {
            AggregateTypeEnum aggrType = AggregateTypeEnum.valueOf(input.readInt());
            String dimRef = ExternalizeUtil.deexternalizeString(input);
            AggregateRule rule = new AggregateRule(aggrType, dimRef);
            aggregationRules.add(rule);
        }
        return aggregationRules.toArray(new IAggregateRule[aggregationRules.size()]);
    }
}

