/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.metadata.record;

import com.cognos.xqe.metadata.MemberTypeEnum;
import com.cognos.xqe.metadata.MetadataKey;
import com.cognos.xqe.metadata.RollupTypeEnum;
import com.cognos.xqe.metadata.record.ExternalizeUtil;
import com.cognos.xqe.metadata.record.MetadataRecord;
import com.cognos.xqe.metadata.record.RecordType;
import com.cognos.xqe.util.xml.serializer.XMLElement;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

@XMLElement
public class MemberRecord
extends MetadataRecord {
    @XMLElement
    private String catalogName = "";
    @XMLElement
    private String schemaName = "";
    @XMLElement
    private String cubeName = "";
    @XMLElement
    private String dimensionUniqueName = "";
    @XMLElement
    private String hierarchyUniqueName = "";
    @XMLElement
    private String levelUniqueName = "";
    @XMLElement
    private String dataMemberUniqueName = null;
    @XMLElement
    private int levelNumber = -1;
    @XMLElement(callMethod="name")
    private MemberTypeEnum type = MemberTypeEnum.REGULAR;
    @XMLElement(callMethod="name")
    private RollupTypeEnum rollupType = RollupTypeEnum.ROLLUP;
    @XMLElement
    private int childCardinality = 0;
    @XMLElement
    private int parentCount = 0;
    @XMLElement
    private int parentLevelNumber = -1;
    @XMLElement
    private String parentUniqueName = null;
    private int memberOrdinal = 0;

    @Override
    public RecordType getRecordType() {
        return RecordType.MEMBER;
    }

    @Override
    public MetadataKey uniqueKey() {
        if (null == this.cachedUniqueKey) {
            Object[] components = new Object[]{this.getRecordType(), this.getCatalogName(), this.getSchemaName(), this.getCubeName(), this.getUniqueName()};
            this.cachedUniqueKey = new MetadataKey(components);
        }
        return this.cachedUniqueKey;
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getCubeName() {
        return this.cubeName;
    }

    public String getDimensionUniqueName() {
        return this.dimensionUniqueName;
    }

    public String getHierarchyUniqueName() {
        return this.hierarchyUniqueName;
    }

    public String getLevelUniqueName() {
        return this.levelUniqueName;
    }

    public String getDataMemberUniqueName() {
        return this.dataMemberUniqueName;
    }

    public int getLevelNumber() {
        return this.levelNumber;
    }

    public MemberTypeEnum getType() {
        return this.type;
    }

    public RollupTypeEnum getRollupType() {
        return this.rollupType;
    }

    public int getChildCardinality() {
        return this.childCardinality;
    }

    public int getMemberOrdinal() {
        return this.memberOrdinal;
    }

    public int getParentCount() {
        return this.parentCount;
    }

    public int getParentLevelNumber() {
        return this.parentLevelNumber;
    }

    public String getParentUniqueName() {
        return this.parentUniqueName;
    }

    public void setCatalogName(String theCatalogName) {
        MemberRecord.assertNotNull(theCatalogName);
        this.catalogName = MemberRecord.internalizeString(theCatalogName);
    }

    public void setSchemaName(String theSchemaName) {
        MemberRecord.assertNotNull(theSchemaName);
        this.schemaName = MemberRecord.internalizeString(theSchemaName);
    }

    public void setInternalizedSchemaName(String theSchemaName) {
        this.schemaName = theSchemaName;
    }

    public void setCubeName(String theCubeName) {
        MemberRecord.assertNotNull(theCubeName);
        this.cubeName = MemberRecord.internalizeString(theCubeName);
    }

    public void setInternalizedCubeName(String theCubeName) {
        this.cubeName = theCubeName;
    }

    public void setDimensionUniqueName(String theDimensionUniqueName) {
        MemberRecord.assertNotNull(theDimensionUniqueName);
        this.dimensionUniqueName = MemberRecord.internalizeString(theDimensionUniqueName);
    }

    public void setInternalizedDimensionUniqueName(String theDimensionUniqueName) {
        this.dimensionUniqueName = theDimensionUniqueName;
    }

    public void setHierarchyUniqueName(String theHierarchyUniqueName) {
        MemberRecord.assertNotNull(theHierarchyUniqueName);
        this.hierarchyUniqueName = MemberRecord.internalizeString(theHierarchyUniqueName);
    }

    public void setInternalizedHierarchyUniqueName(String theHierarchyUniqueName) {
        this.hierarchyUniqueName = theHierarchyUniqueName;
    }

    public void setLevelUniqueName(String theLevelUniqueName) {
        MemberRecord.assertNotNull(theLevelUniqueName);
        this.levelUniqueName = MemberRecord.internalizeString(theLevelUniqueName);
    }

    public void setInternalizedLevelUniqueName(String theLevelUniqueName) {
        this.levelUniqueName = theLevelUniqueName;
    }

    public void setDataMemberUniqueName(String theDataMemberUniqueName) {
        this.dataMemberUniqueName = MemberRecord.internalizeString(theDataMemberUniqueName);
    }

    public void setInternalizedDataMemberUniqueName(String theDataMemberUniqueName) {
        this.dataMemberUniqueName = theDataMemberUniqueName;
    }

    public void setLevelNumber(int theLevelNumber) {
        this.levelNumber = theLevelNumber;
    }

    public void setType(MemberTypeEnum memberTypeEnum) {
        this.type = memberTypeEnum;
    }

    public void setRollupType(RollupTypeEnum rollupTypeEnum) {
        this.rollupType = rollupTypeEnum;
    }

    public void setChildCardinality(int theChildCardinality) {
        this.childCardinality = theChildCardinality;
    }

    public void setMemberOrdinal(int memberOrd) {
        this.memberOrdinal = memberOrd;
    }

    public void setParentCount(int theParentCount) {
        this.parentCount = theParentCount;
    }

    public void setParentLevelNumber(int theParentLevelNumber) {
        this.parentLevelNumber = theParentLevelNumber;
    }

    public void setParentUniqueName(String theParentUniqueName) {
        this.parentUniqueName = MemberRecord.internalizeString(theParentUniqueName);
    }

    public void setInternalizedParentUniqueName(String theParentUniqueName) {
        this.parentUniqueName = theParentUniqueName;
    }

    @Override
    public void externalize(DataOutput output) throws IOException {
        super.externalize(output);
        ExternalizeUtil.externalizeString(output, this.getCatalogName());
        ExternalizeUtil.externalizeString(output, this.getSchemaName());
        ExternalizeUtil.externalizeString(output, this.getCubeName());
        ExternalizeUtil.externalizeString(output, this.getDimensionUniqueName());
        ExternalizeUtil.externalizeString(output, this.getHierarchyUniqueName());
        ExternalizeUtil.externalizeString(output, this.getLevelUniqueName());
        ExternalizeUtil.externalizeString(output, this.getDataMemberUniqueName());
        output.writeInt(this.getLevelNumber());
        ExternalizeUtil.externalizeString(output, this.getType().name());
        ExternalizeUtil.externalizeString(output, this.getRollupType().name());
        output.writeInt(this.getChildCardinality());
        output.writeInt(this.getParentCount());
        output.writeInt(this.getParentLevelNumber());
        ExternalizeUtil.externalizeString(output, this.getParentUniqueName());
    }

    @Override
    public void deexternalize(DataInput input) throws IOException {
        super.deexternalize(input);
        this.setCatalogName(ExternalizeUtil.deexternalizeString(input));
        this.setSchemaName(ExternalizeUtil.deexternalizeString(input));
        this.setCubeName(ExternalizeUtil.deexternalizeString(input));
        this.setDimensionUniqueName(ExternalizeUtil.deexternalizeString(input));
        this.setHierarchyUniqueName(ExternalizeUtil.deexternalizeString(input));
        this.setLevelUniqueName(ExternalizeUtil.deexternalizeString(input));
        this.setDataMemberUniqueName(ExternalizeUtil.deexternalizeString(input));
        this.setLevelNumber(input.readInt());
        String typeName = ExternalizeUtil.deexternalizeString(input);
        MemberTypeEnum memberTypeEnum = MemberTypeEnum.valueOf(typeName);
        this.setType(memberTypeEnum);
        String rollupTypeName = ExternalizeUtil.deexternalizeString(input);
        RollupTypeEnum rollupTypeEnum = RollupTypeEnum.valueOf(rollupTypeName);
        this.setRollupType(rollupTypeEnum);
        this.setChildCardinality(input.readInt());
        this.setParentCount(input.readInt());
        this.setParentLevelNumber(input.readInt());
        this.setParentUniqueName(ExternalizeUtil.deexternalizeString(input));
    }

    public void copyTo(MemberRecord theCopy) {
        super.copyTo(theCopy);
        theCopy.setCatalogName(this.getCatalogName());
        theCopy.setSchemaName(this.getSchemaName());
        theCopy.setCubeName(this.getCubeName());
        theCopy.setDimensionUniqueName(this.getDimensionUniqueName());
        theCopy.setHierarchyUniqueName(this.getHierarchyUniqueName());
        theCopy.setLevelUniqueName(this.getLevelUniqueName());
        theCopy.setDataMemberUniqueName(this.getDataMemberUniqueName());
        theCopy.setLevelNumber(this.getLevelNumber());
        theCopy.setType(this.getType());
        theCopy.setRollupType(this.getRollupType());
        theCopy.setChildCardinality(this.getChildCardinality());
        theCopy.setParentCount(this.getParentCount());
        theCopy.setParentLevelNumber(this.getParentLevelNumber());
        theCopy.setParentUniqueName(this.getParentUniqueName());
        theCopy.setMemberOrdinal(this.getMemberOrdinal());
    }

    @Override
    public Object copy() {
        MemberRecord clonedRecord = new MemberRecord();
        this.copyTo(clonedRecord);
        return clonedRecord;
    }
}

