/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.metadata.record;

import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.data.values.ValueConversionException;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.MetadataKey;
import com.cognos.xqe.metadata.PPDSCodeTypeEnum;
import com.cognos.xqe.metadata.record.BooleanField;
import com.cognos.xqe.metadata.record.ByteField;
import com.cognos.xqe.metadata.record.DoubleField;
import com.cognos.xqe.metadata.record.DynamicFieldBase;
import com.cognos.xqe.metadata.record.ExternalizeUtil;
import com.cognos.xqe.metadata.record.FloatField;
import com.cognos.xqe.metadata.record.IDynamicField;
import com.cognos.xqe.metadata.record.IExternalizable;
import com.cognos.xqe.metadata.record.IntegerField;
import com.cognos.xqe.metadata.record.LongField;
import com.cognos.xqe.metadata.record.NullField;
import com.cognos.xqe.metadata.record.RecordType;
import com.cognos.xqe.metadata.record.ShortField;
import com.cognos.xqe.metadata.record.StringField;
import com.cognos.xqe.metadata.record.ValueField;
import com.cognos.xqe.query.engine.IExecutionEnvironment;
import com.cognos.xqe.query.engine.MultiRequestReference;
import com.cognos.xqe.util.ILocalizedString;
import com.cognos.xqe.util.LocalizedString;
import com.cognos.xqe.util.MapCast;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import com.cognos.xqe.util.xml.XMLWriter;
import com.cognos.xqe.util.xml.serializer.XMLElement;
import com.cognos.xqe.util.xml.serializer.XMLElementCollection;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.commons.collections.map.ReferenceMap;
import org.apache.commons.lang.builder.ToStringBuilder;

public abstract class MetadataRecord
implements IExternalizable,
Cloneable,
Comparable<Object> {
    protected static final String EMPTY_STRING = "";
    protected static final int DYNAMIC_FIELD_INITIAL_CAPACITY = 5;
    private static final MultiRequestReference<Map<String, String>> STRING_POOL_REF = new MultiRequestReference();
    @XMLElement
    private String name = "";
    @XMLElement
    private String uniqueName = "";
    @XMLElement
    private String uniqueId = "";
    @XMLElement
    private LocalizedString caption = new LocalizedString("");
    @XMLElement
    private String description = null;
    protected int rank = -1;
    @XMLElementCollection(itemName="field")
    private List<IDynamicField> dynamicFields = null;
    protected MetadataKey cachedUniqueKey = null;

    public abstract RecordType getRecordType();

    public abstract MetadataKey uniqueKey();

    public String getName() {
        return this.name;
    }

    public String getUniqueName() {
        return this.uniqueName;
    }

    public String getUniqueId() {
        return this.uniqueId;
    }

    public LocalizedString getCaption() {
        return this.caption;
    }

    public String getDescription() {
        return this.description;
    }

    public final int getRank() {
        return this.rank;
    }

    public final String[] getDynamicFieldNames() {
        if (null == this.dynamicFields) {
            return new String[0];
        }
        String[] fieldNames = new String[this.dynamicFields.size()];
        int i = 0;
        for (IDynamicField field : this.dynamicFields) {
            fieldNames[i++] = field.getName();
        }
        return fieldNames;
    }

    public final Object getDynamicField(String fieldName) {
        if (null == this.dynamicFields) {
            return null;
        }
        IDynamicField field = this.findDynamicField(fieldName);
        if (null == field) {
            return null;
        }
        return field.objectValue();
    }

    public final Boolean getDynamicFieldAsBoolean(String fieldName) {
        if (null == this.dynamicFields) {
            return null;
        }
        IDynamicField field = this.findDynamicField(fieldName);
        if (null == field) {
            return null;
        }
        return field.booleanValue();
    }

    public final Byte getDynamicFieldAsByte(String fieldName) {
        if (null == this.dynamicFields) {
            return null;
        }
        IDynamicField field = this.findDynamicField(fieldName);
        if (null == field) {
            return null;
        }
        return field.byteValue();
    }

    public final Short getDynamicFieldAsShort(String fieldName) {
        if (null == this.dynamicFields) {
            return null;
        }
        IDynamicField field = this.findDynamicField(fieldName);
        if (null == field) {
            return null;
        }
        return field.shortValue();
    }

    public final Integer getDynamicFieldAsInteger(String fieldName) {
        if (null == this.dynamicFields) {
            return null;
        }
        IDynamicField field = this.findDynamicField(fieldName);
        if (null == field) {
            return null;
        }
        return field.intValue();
    }

    public final Long getDynamicFieldAsLong(String fieldName) {
        if (null == this.dynamicFields) {
            return null;
        }
        IDynamicField field = this.findDynamicField(fieldName);
        if (null == field) {
            return null;
        }
        return field.longValue();
    }

    public final Float getDynamicFieldAsFloat(String fieldName) {
        if (null == this.dynamicFields) {
            return null;
        }
        IDynamicField field = this.findDynamicField(fieldName);
        if (null == field) {
            return null;
        }
        return Float.valueOf(field.floatValue());
    }

    public final Double getDynamicFieldAsDouble(String fieldName) {
        if (null == this.dynamicFields) {
            return null;
        }
        IDynamicField field = this.findDynamicField(fieldName);
        if (null == field) {
            return null;
        }
        return field.doubleValue();
    }

    public final String getDynamicFieldAsString(String fieldName) {
        if (null == this.dynamicFields) {
            return null;
        }
        IDynamicField field = this.findDynamicField(fieldName);
        if (null == field) {
            return null;
        }
        return field.stringValue();
    }

    public final Value getDynamicFieldAsValue(String fieldName) {
        if (null == this.dynamicFields) {
            return null;
        }
        IDynamicField field = this.findDynamicField(fieldName);
        if (null == field) {
            return null;
        }
        return field.value();
    }

    public final Value getDynamicFieldAsValue(String fieldName, IDataType expectedType) throws ValueConversionException {
        if (null == this.dynamicFields) {
            return null;
        }
        IDynamicField field = this.findDynamicField(fieldName);
        if (null == field) {
            return null;
        }
        Value theValue = field.value();
        MetadataRecord.assertValueDataType(theValue, expectedType);
        return theValue;
    }

    public final boolean isDynamicFieldNull(String fieldName) {
        if (null == this.dynamicFields) {
            return false;
        }
        IDynamicField field = this.findDynamicField(fieldName);
        if (null == field) {
            return false;
        }
        return field.isNull();
    }

    public void setName(String theName) {
        MetadataRecord.assertNotNull(theName);
        this.name = MetadataRecord.internalizeString(theName);
    }

    public void setInternalizedName(String theName) {
        MetadataRecord.assertNotNull(theName);
        this.name = theName;
    }

    public void setUniqueName(String theUniqueName) {
        MetadataRecord.assertNotNull(theUniqueName);
        this.uniqueName = MetadataRecord.internalizeString(theUniqueName);
    }

    public void setInternalizedUniqueName(String theUniqueName) {
        MetadataRecord.assertNotNull(theUniqueName);
        this.uniqueName = theUniqueName;
    }

    public void setUniqueId(String theUniqueId) {
        MetadataRecord.assertNotNull(theUniqueId);
        this.uniqueId = theUniqueId;
    }

    public void setUniqueId(RecordType type, String uName) {
        MetadataRecord.assertNotNull(uName);
        this.setUniqueId(PPDSCodeTypeEnum.getPPDSCodePrefixFromType(type) + uName);
    }

    public void setCaption(String theCaption) {
        MetadataRecord.assertNotNull(theCaption);
        this.caption = new LocalizedString(theCaption);
    }

    public void setCaption(ILocalizedString theCaption) {
        MetadataRecord.assertNotNull(theCaption);
        this.caption = new LocalizedString(theCaption);
    }

    public void setDescription(String theDescription) {
        this.description = theDescription;
    }

    public void setRank(int theRank) {
        this.rank = theRank;
    }

    public final void setDynamicField(String fieldName, Object value) {
        if (null == value) {
            this.setDynamicFieldAsNull(fieldName);
            return;
        }
        Class<?> valueClazz = value.getClass();
        if (valueClazz.equals(Boolean.class)) {
            this.setDynamicFieldAsBoolean(fieldName, (Boolean)value);
        } else if (valueClazz.equals(Byte.class)) {
            this.setDynamicFieldAsByte(fieldName, (Byte)value);
        } else if (valueClazz.equals(Double.class)) {
            this.setDynamicFieldAsDouble(fieldName, (Double)value);
        } else if (valueClazz.equals(Float.class)) {
            this.setDynamicFieldAsFloat(fieldName, (Float)value);
        } else if (valueClazz.equals(Integer.class)) {
            this.setDynamicFieldAsInteger(fieldName, (Integer)value);
        } else if (valueClazz.equals(Long.class)) {
            this.setDynamicFieldAsLong(fieldName, (Long)value);
        } else if (valueClazz.equals(String.class)) {
            this.setDynamicFieldAsString(fieldName, (String)value);
        } else if (value instanceof Value) {
            this.setDynamicFieldAsValue(fieldName, (Value)value);
        } else {
            throw new IllegalArgumentException("Unsupported data type");
        }
    }

    public final void setDynamicFieldAsBoolean(String fieldName, Boolean value) {
        if (null == value) {
            this.setDynamicFieldAsNull(fieldName);
            return;
        }
        IDynamicField field = this.findDynamicField(fieldName);
        if (null == field) {
            field = new BooleanField(fieldName, value);
            this.addDynamicField(field);
        } else if (field.getTypeCode() != 0) {
            field = new BooleanField(fieldName, value);
            this.replaceDynamicField(field);
        } else {
            field.setBooleanValue(value);
        }
    }

    public final void setDynamicFieldAsByte(String fieldName, Byte value) {
        if (null == value) {
            this.setDynamicFieldAsNull(fieldName);
            return;
        }
        IDynamicField field = this.findDynamicField(fieldName);
        if (null == field) {
            field = new ByteField(fieldName, value);
            this.addDynamicField(field);
        } else if (field.getTypeCode() != 1) {
            field = new ByteField(fieldName, value);
            this.replaceDynamicField(field);
        } else {
            field.setByteValue(value);
        }
    }

    public final void setDynamicFieldAsShort(String fieldName, Short value) {
        if (null == value) {
            this.setDynamicFieldAsNull(fieldName);
            return;
        }
        IDynamicField field = this.findDynamicField(fieldName);
        if (null == field) {
            field = new ShortField(fieldName, value);
            this.addDynamicField(field);
        } else if (field.getTypeCode() != 2) {
            field = new ShortField(fieldName, value);
            this.replaceDynamicField(field);
        } else {
            field.setShortValue(value);
        }
    }

    public final void setDynamicFieldAsInteger(String fieldName, Integer value) {
        if (null == value) {
            this.setDynamicFieldAsNull(fieldName);
            return;
        }
        IDynamicField field = this.findDynamicField(fieldName);
        if (null == field) {
            field = new IntegerField(fieldName, value);
            this.addDynamicField(field);
        } else if (field.getTypeCode() != 3) {
            field = new IntegerField(fieldName, value);
            this.replaceDynamicField(field);
        } else {
            field.setIntValue(value);
        }
    }

    public final void setDynamicFieldAsLong(String fieldName, Long value) {
        if (null == value) {
            this.setDynamicFieldAsNull(fieldName);
            return;
        }
        IDynamicField field = this.findDynamicField(fieldName);
        if (null == field) {
            field = new LongField(fieldName, value);
            this.addDynamicField(field);
        } else if (field.getTypeCode() != 4) {
            field = new LongField(fieldName, value);
            this.replaceDynamicField(field);
        } else {
            field.setLongValue(value);
        }
    }

    public final void setDynamicFieldAsFloat(String fieldName, Float value) {
        if (null == value) {
            this.setDynamicFieldAsNull(fieldName);
            return;
        }
        IDynamicField field = this.findDynamicField(fieldName);
        if (null == field) {
            field = new FloatField(fieldName, value.floatValue());
            this.addDynamicField(field);
        } else if (field.getTypeCode() != 5) {
            field = new FloatField(fieldName, value.floatValue());
            this.replaceDynamicField(field);
        } else {
            field.setFloatValue(value.floatValue());
        }
    }

    public final void setDynamicFieldAsDouble(String fieldName, Double value) {
        if (null == value) {
            this.setDynamicFieldAsNull(fieldName);
            return;
        }
        IDynamicField field = this.findDynamicField(fieldName);
        if (null == field) {
            field = new DoubleField(fieldName, value);
            this.addDynamicField(field);
        } else if (field.getTypeCode() != 6) {
            field = new DoubleField(fieldName, value);
            this.replaceDynamicField(field);
        } else {
            field.setDoubleValue(value);
        }
    }

    public final void setDynamicFieldAsString(String fieldName, String value) {
        if (null == value) {
            this.setDynamicFieldAsNull(fieldName);
            return;
        }
        IDynamicField field = this.findDynamicField(fieldName);
        if (null == field) {
            field = new StringField(fieldName, value);
            this.addDynamicField(field);
        } else if (field.getTypeCode() != 7) {
            field = new StringField(fieldName, value);
            this.replaceDynamicField(field);
        } else {
            field.setStringValue(value);
        }
    }

    public final void setDynamicFieldAsValue(String fieldName, Value value) {
        if (null == value) {
            this.setDynamicFieldAsNull(fieldName);
            return;
        }
        IDynamicField field = this.findDynamicField(fieldName);
        if (null == field) {
            field = new ValueField(fieldName, value);
            this.addDynamicField(field);
        } else if (field.getTypeCode() != 8) {
            field = new ValueField(fieldName, value);
            this.replaceDynamicField(field);
        } else {
            field.setValue(value);
        }
    }

    public final void setDynamicFieldAsNull(String fieldName) {
        IDynamicField field = this.findDynamicField(fieldName);
        if (null == field) {
            field = new NullField(fieldName);
            this.addDynamicField(field);
        } else if (!field.isNull()) {
            field = new NullField(fieldName);
            this.replaceDynamicField(field);
        }
    }

    public final List<IDynamicField> getDynamicFields() {
        List<IDynamicField> theDynamicsFields = this.dynamicFields;
        theDynamicsFields = null == theDynamicsFields ? Collections.emptyList() : Collections.unmodifiableList(theDynamicsFields);
        return theDynamicsFields;
    }

    public final ListIterator<IDynamicField> getDynamicFieldIterator() {
        List<IDynamicField> theDynamicsFields = this.dynamicFields;
        theDynamicsFields = null == theDynamicsFields ? Collections.emptyList() : Collections.unmodifiableList(theDynamicsFields);
        return theDynamicsFields.listIterator();
    }

    private ListIterator<IDynamicField> getMutableDynamicFieldIterator() {
        List<IDynamicField> theDynamicsFields = this.dynamicFields;
        if (null == theDynamicsFields) {
            theDynamicsFields = Collections.emptyList();
        }
        return theDynamicsFields.listIterator();
    }

    @Override
    public void externalize(DataOutput output) throws IOException {
        ExternalizeUtil.externalizeString(output, this.getName());
        ExternalizeUtil.externalizeString(output, this.getUniqueName());
        ExternalizeUtil.externalizeString(output, this.getUniqueId());
        ExternalizeUtil.externalizeLocalizedString(output, this.getCaption());
        ExternalizeUtil.externalizeString(output, this.getDescription());
        ExternalizeUtil.externalizeDynamicFields(output, this.dynamicFields);
        output.writeInt(this.getRank());
    }

    @Override
    public void deexternalize(DataInput input) throws IOException {
        this.setName(ExternalizeUtil.deexternalizeString(input));
        this.setUniqueName(ExternalizeUtil.deexternalizeString(input));
        this.setUniqueId(ExternalizeUtil.deexternalizeString(input));
        this.setCaption(ExternalizeUtil.deexternalizeLocalizedString(input));
        this.setDescription(ExternalizeUtil.deexternalizeString(input));
        this.dynamicFields = ExternalizeUtil.deexternalizeDynamicFields(input);
        this.setRank(input.readInt());
    }

    public final boolean equals(Object other) {
        MetadataKey otherKey;
        if (null == other) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (!(other instanceof MetadataRecord)) {
            return false;
        }
        MetadataRecord otherRec = (MetadataRecord)other;
        MetadataKey thisKey = this.uniqueKey();
        if (thisKey == (otherKey = otherRec.uniqueKey())) {
            return true;
        }
        return thisKey.equals(otherKey);
    }

    public final int hashCode() {
        return this.uniqueKey().hashCode();
    }

    @Override
    public final int compareTo(Object other) {
        if (null == other) {
            return -1;
        }
        if (this == other) {
            return 0;
        }
        if (!(other instanceof MetadataRecord)) {
            return -1;
        }
        MetadataRecord otherRec = (MetadataRecord)other;
        MetadataKey thisKey = this.uniqueKey();
        MetadataKey otherKey = otherRec.uniqueKey();
        return thisKey.compareTo(otherKey);
    }

    public void copyTo(MetadataRecord theCopy) {
        LocalizedString localizedStr = this.getCaption();
        if (localizedStr != null) {
            theCopy.setCaption(localizedStr);
        }
        theCopy.setDescription(this.getDescription());
        theCopy.setName(this.getName());
        theCopy.setUniqueId(this.getUniqueId());
        theCopy.setUniqueName(this.getUniqueName());
        theCopy.clearDynamicFields();
        ListIterator<IDynamicField> fieldIter = this.getDynamicFieldIterator();
        while (fieldIter.hasNext()) {
            DynamicFieldBase field = (DynamicFieldBase)fieldIter.next();
            try {
                theCopy.addDynamicField((IDynamicField)field.copy());
            }
            catch (CloneNotSupportedException e) {
                throw new XQERuntimeException(e);
            }
        }
        theCopy.setRank(this.getRank());
    }

    public Object copy() {
        throw new XQERuntimeException(XQEMessageKeys.GEN_MethodNotImplemented_INTERNAL, "Object MetadataRecord#clone()");
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public void toXML(XMLWriter xmlWriter) {
    }

    private void initializeDynamicFields() {
        if (null == this.dynamicFields) {
            this.dynamicFields = new ArrayList<IDynamicField>();
        }
    }

    private IDynamicField findDynamicField(String fieldName) {
        if (null == this.dynamicFields) {
            return null;
        }
        ListIterator<IDynamicField> fieldIter = this.getDynamicFieldIterator();
        while (fieldIter.hasNext()) {
            IDynamicField field = (IDynamicField)fieldIter.next();
            if (field.getName() != fieldName && !field.getName().equals(fieldName)) continue;
            return field;
        }
        return null;
    }

    public void addDynamicField(IDynamicField field) {
        this.initializeDynamicFields();
        this.dynamicFields.add(field);
    }

    private void replaceDynamicField(IDynamicField replacementField) {
        if (null == this.dynamicFields) {
            return;
        }
        ListIterator<IDynamicField> fieldIter = this.getMutableDynamicFieldIterator();
        while (fieldIter.hasNext()) {
            IDynamicField fieldToReplace = fieldIter.next();
            if (fieldToReplace.getName() != replacementField.getName() && !fieldToReplace.getName().equals(replacementField.getName())) continue;
            fieldIter.set(replacementField);
            break;
        }
    }

    public void clearDynamicField(String fieldName) {
        if (null == this.dynamicFields) {
            return;
        }
        ListIterator<IDynamicField> fieldIter = this.getMutableDynamicFieldIterator();
        while (fieldIter.hasNext()) {
            IDynamicField field = fieldIter.next();
            if (field.getName() != fieldName && !field.getName().equals(fieldName)) continue;
            fieldIter.remove();
            break;
        }
    }

    private void clearDynamicFields() {
        if (null == this.dynamicFields) {
            return;
        }
        this.dynamicFields.clear();
    }

    public static String internalizeString(String theString) {
        return MetadataRecord.internalizeString(theString, ExecutionEnvironmentContext.getExecutionEnvironment());
    }

    public static String internalizeString(String theString, IExecutionEnvironment execEnv) {
        Map<String, String> stringPool = STRING_POOL_REF.get(execEnv);
        if (null == stringPool) {
            stringPool = MapCast.uncheckedCast(new ReferenceMap(1, 1));
            STRING_POOL_REF.set(stringPool);
        }
        if (null == theString) {
            return null;
        }
        String interned = stringPool.get(theString);
        if (null == interned) {
            stringPool.put(theString, theString);
            return theString;
        }
        return interned;
    }

    protected static void assertNotNull(Object value) throws ValueConversionException {
        if (null == value) {
            throw new ValueConversionException(XQEMessageKeys.DAT_NullValueNotAllowed);
        }
    }

    protected static void assertValueDataType(Value theValue, IDataType expectedType) throws ValueConversionException {
        IDataType theValueType = theValue.getDataType();
        if (!theValueType.equals(expectedType)) {
            throw new ValueConversionException(XQEMessageKeys.DAT_GeneralConversionError, theValueType.toString(), theValue.toString(), expectedType.toString());
        }
    }
}

