/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.metadata.record;

import com.cognos.xqe.metadata.MetadataKey;
import com.cognos.xqe.metadata.record.ExternalizeUtil;
import com.cognos.xqe.metadata.record.MetadataRecord;
import com.cognos.xqe.metadata.record.RecordType;
import com.cognos.xqe.util.ILocalizedString;
import com.cognos.xqe.util.LocalizedString;
import com.cognos.xqe.util.xml.serializer.XMLElement;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

@XMLElement
public class NamedSetRecord
extends MetadataRecord {
    private static final String DISPLAY_PATH = "Display_Path";
    @XMLElement
    private String catalogName = "";
    @XMLElement
    private String schemaName = "";
    @XMLElement
    private String cubeName = "";
    @XMLElement
    private String expression = "";
    @XMLElement
    private ILocalizedString displayPath = new LocalizedString("");

    @Override
    public RecordType getRecordType() {
        return RecordType.NAMEDSET;
    }

    @Override
    public MetadataKey uniqueKey() {
        if (null == this.cachedUniqueKey) {
            Object[] components = new Object[]{this.getRecordType(), this.getCatalogName(), this.getSchemaName(), this.getCubeName(), this.getUniqueName()};
            this.cachedUniqueKey = new MetadataKey(components);
        }
        return this.cachedUniqueKey;
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getCubeName() {
        return this.cubeName;
    }

    public String getExpression() {
        return this.expression;
    }

    public void setCatalogName(String theCatalogName) {
        NamedSetRecord.assertNotNull(theCatalogName);
        this.catalogName = NamedSetRecord.internalizeString(theCatalogName);
    }

    public void setSchemaName(String theSchemaName) {
        NamedSetRecord.assertNotNull(theSchemaName);
        this.schemaName = NamedSetRecord.internalizeString(theSchemaName);
    }

    public void setCubeName(String theCubeName) {
        NamedSetRecord.assertNotNull(theCubeName);
        this.cubeName = NamedSetRecord.internalizeString(theCubeName);
    }

    public void setExpression(String theExpression) {
        this.expression = theExpression;
    }

    public String getDisplayPath() {
        return this.getDynamicFieldAsString(DISPLAY_PATH);
    }

    public void setDisplayPath(String dispPath) {
        this.setDynamicFieldAsString(DISPLAY_PATH, dispPath);
    }

    public ILocalizedString getLocalizedDisplayPath() {
        return this.displayPath;
    }

    public void setLocalizedDisplayPath(ILocalizedString dispPath) {
        this.displayPath = dispPath;
    }

    @Override
    public void externalize(DataOutput output) throws IOException {
        super.externalize(output);
        ExternalizeUtil.externalizeString(output, this.getCatalogName());
        ExternalizeUtil.externalizeString(output, this.getSchemaName());
        ExternalizeUtil.externalizeString(output, this.getCubeName());
        ExternalizeUtil.externalizeString(output, this.getExpression());
    }

    @Override
    public void deexternalize(DataInput input) throws IOException {
        super.deexternalize(input);
        this.setCatalogName(ExternalizeUtil.deexternalizeString(input));
        this.setSchemaName(ExternalizeUtil.deexternalizeString(input));
        this.setCubeName(ExternalizeUtil.deexternalizeString(input));
        this.setExpression(ExternalizeUtil.deexternalizeString(input));
    }

    public void copyTo(NamedSetRecord theCopy) {
        super.copyTo(theCopy);
        theCopy.setCatalogName(this.getCatalogName());
        theCopy.setSchemaName(this.getSchemaName());
        theCopy.setCubeName(this.getCubeName());
        theCopy.setExpression(this.getExpression());
    }

    @Override
    public Object copy() {
        NamedSetRecord clonedRecord = new NamedSetRecord();
        this.copyTo(clonedRecord);
        return clonedRecord;
    }
}

