/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.metadata.record;

import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.metadata.MetadataKey;
import com.cognos.xqe.metadata.RoleTypeEnum;
import com.cognos.xqe.metadata.record.ExternalizeUtil;
import com.cognos.xqe.metadata.record.MetadataRecord;
import com.cognos.xqe.metadata.record.RecordType;
import com.cognos.xqe.util.xml.serializer.XMLElement;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

@XMLElement
public class PropertyRecord
extends MetadataRecord {
    public static final String XQE_CUSTOM_PROPERTY_NAME = "XQE_CUSTOM_PROPERTY_NAME";
    @XMLElement
    private String catalogName = "";
    @XMLElement
    private String schemaName = "";
    @XMLElement
    private String cubeName = "";
    @XMLElement
    private String dimensionUniqueName = "";
    @XMLElement
    private String hierarchyUniqueName = "";
    @XMLElement
    private String levelUniqueName = null;
    @XMLElement
    private IDataType dataType = DataTypeFactory.getStringType();
    @XMLElement(callMethod="name")
    private RoleTypeEnum roleType = RoleTypeEnum.MEMBER_CUSTOM_PROPERTY;

    @Override
    public RecordType getRecordType() {
        return RecordType.PROPERTY;
    }

    @Override
    public MetadataKey uniqueKey() {
        if (null == this.cachedUniqueKey) {
            Object[] components = new Object[]{this.getRecordType(), this.getCatalogName(), this.getSchemaName(), this.getCubeName(), this.getUniqueName()};
            this.cachedUniqueKey = new MetadataKey(components);
        }
        return this.cachedUniqueKey;
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getCubeName() {
        return this.cubeName;
    }

    public String getDimensionUniqueName() {
        return this.dimensionUniqueName;
    }

    public String getHierarchyUniqueName() {
        return this.hierarchyUniqueName;
    }

    public String getLevelUniqueName() {
        return this.levelUniqueName;
    }

    public IDataType getDataType() {
        return this.dataType;
    }

    public RoleTypeEnum getRoleType() {
        return this.roleType;
    }

    public void setCatalogName(String theCatalogName) {
        PropertyRecord.assertNotNull(theCatalogName);
        this.catalogName = PropertyRecord.internalizeString(theCatalogName);
    }

    public void setSchemaName(String theSchemaName) {
        PropertyRecord.assertNotNull(theSchemaName);
        this.schemaName = PropertyRecord.internalizeString(theSchemaName);
    }

    public void setCubeName(String theCubeName) {
        PropertyRecord.assertNotNull(theCubeName);
        this.cubeName = PropertyRecord.internalizeString(theCubeName);
    }

    public void setDimensionUniqueName(String theDimensionUniqueName) {
        PropertyRecord.assertNotNull(theDimensionUniqueName);
        this.dimensionUniqueName = PropertyRecord.internalizeString(theDimensionUniqueName);
    }

    public void setHierarchyUniqueName(String theHierarchyUniqueName) {
        PropertyRecord.assertNotNull(theHierarchyUniqueName);
        this.hierarchyUniqueName = PropertyRecord.internalizeString(theHierarchyUniqueName);
    }

    public void setLevelUniqueName(String theLevelUniqueName) {
        this.levelUniqueName = PropertyRecord.internalizeString(theLevelUniqueName);
    }

    public void setDataType(IDataType theDataType) {
        PropertyRecord.assertNotNull(theDataType);
        this.dataType = theDataType;
    }

    public void setRoleType(RoleTypeEnum theRoleType) {
        PropertyRecord.assertNotNull((Object)theRoleType);
        this.roleType = theRoleType;
    }

    @Override
    public void externalize(DataOutput output) throws IOException {
        super.externalize(output);
        ExternalizeUtil.externalizeString(output, this.getCatalogName());
        ExternalizeUtil.externalizeString(output, this.getSchemaName());
        ExternalizeUtil.externalizeString(output, this.getCubeName());
        ExternalizeUtil.externalizeString(output, this.getDimensionUniqueName());
        ExternalizeUtil.externalizeString(output, this.getHierarchyUniqueName());
        ExternalizeUtil.externalizeString(output, this.getLevelUniqueName());
        ExternalizeUtil.externalizeDataType(output, this.getDataType());
        output.writeInt(this.getRoleType().ordinal());
    }

    @Override
    public void deexternalize(DataInput input) throws IOException {
        super.deexternalize(input);
        this.setCatalogName(ExternalizeUtil.deexternalizeString(input));
        this.setSchemaName(ExternalizeUtil.deexternalizeString(input));
        this.setCubeName(ExternalizeUtil.deexternalizeString(input));
        this.setDimensionUniqueName(ExternalizeUtil.deexternalizeString(input));
        this.setHierarchyUniqueName(ExternalizeUtil.deexternalizeString(input));
        this.setLevelUniqueName(ExternalizeUtil.deexternalizeString(input));
        this.setDataType(ExternalizeUtil.deexternalizeDataType(input));
        this.setRoleType(RoleTypeEnum.valueOf(input.readInt()));
    }

    public void copyTo(PropertyRecord theCopy) {
        super.copyTo(theCopy);
        theCopy.setCatalogName(this.getCatalogName());
        theCopy.setSchemaName(this.getSchemaName());
        theCopy.setCubeName(this.getCubeName());
        theCopy.setDimensionUniqueName(this.getDimensionUniqueName());
        theCopy.setHierarchyUniqueName(this.getHierarchyUniqueName());
        theCopy.setLevelUniqueName(this.getLevelUniqueName());
        theCopy.setDataType(this.getDataType());
        theCopy.setRoleType(this.getRoleType());
    }

    @Override
    public Object copy() {
        PropertyRecord clonedRecord = new PropertyRecord();
        this.copyTo(clonedRecord);
        return clonedRecord;
    }
}

