/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.metadata.wrapper;

import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.DimensionTypeEnum;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.provider.Hierarchy;
import com.cognos.xqe.metadata.wrapper.AbstractDimensionWrapper;
import com.cognos.xqe.metadata.wrapper.CubeWrapper;
import com.cognos.xqe.metadata.wrapper.HierarchyWrapper;
import com.cognos.xqe.util.UniqueNameGenerator;

public class DimensionWrapper
extends AbstractDimensionWrapper {
    public DimensionWrapper(CubeWrapper cCube, IDimension dim) {
        super(cCube, dim);
    }

    @Override
    public CubeWrapper getCube() {
        return (CubeWrapper)super.getCube();
    }

    @Override
    public IHierarchy getDefaultHierarchy() {
        if (this.defaultHierarchy == null) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_InternalException);
        }
        return this.defaultHierarchy;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    protected synchronized void initialiseChildren() {
        if (this.initialisedChildren) {
            return;
        }
        this.initialisedChildren = true;
        this.initialised = this.initialisedProperties && this.initialisedChildren;
        boolean mustCreateFirstHierarchy = true;
        IHierarchy wrappedDefHierarchy = this.wrappedDimension.getDefaultHierarchy();
        if (wrappedDefHierarchy != null) {
            this.defaultHierarchy = this.getCube().createHierarchy(this, wrappedDefHierarchy);
            mustCreateFirstHierarchy = false;
        } else if (this.wrappedDimension.getHierarchies().size() <= 0) {
            super.createDefaultHierarchy(this.wrappedDimension.getName());
        }
        for (IHierarchy hierarchy : this.wrappedDimension.getHierarchies()) {
            HierarchyWrapper hierarchyWrapper = null;
            if (mustCreateFirstHierarchy) {
                hierarchyWrapper = this.getCube().createHierarchy(this, hierarchy);
                mustCreateFirstHierarchy = false;
            } else {
                boolean isCreated;
                boolean bl = isCreated = this.getCube().getWrapper(hierarchy) != null;
                if (!isCreated) {
                    hierarchyWrapper = (HierarchyWrapper)this.getCube().createMonoDimension(this, hierarchy).getHierarchy(0);
                }
            }
            if (this.defaultHierarchy != null) continue;
            this.defaultHierarchy = hierarchyWrapper;
        }
    }

    @Override
    protected synchronized void initialiseProperties() {
        if (this.initialisedProperties) {
            return;
        }
        this.setConnection(this.wrappedDimension.getConnection());
        this.dataType = this.wrappedDimension.getDataType();
        this.caption = this.wrappedDimension.getCaption();
        this.description = this.wrappedDimension.getDescription();
        this.membersRollup = this.wrappedDimension.getMembersRollup();
        this.dimensionType = this.wrappedDimension.isTimeDimension() ? DimensionTypeEnum.TIME : (this.wrappedDimension.isMeasuresDimension() ? DimensionTypeEnum.MEASURE : DimensionTypeEnum.REGULAR);
        this.v5UniqueName = this.wrappedDimension.getV5UniqueName();
        this.uniqueName = UniqueNameGenerator.createUniqueName(this.getName());
        this.initialisedProperties = true;
        this.orderOfMagnitude = this.wrappedDimension.getOrderOfMagnitude();
    }

    @Override
    public String toString() {
        return this.getUniqueName();
    }

    @Override
    public Hierarchy addHierarchy(String name) {
        IHierarchy hierarchy = this.wrappedDimension.getHierarchy(name);
        HierarchyWrapper hierWrapper = this.getCube().createHierarchy(this, hierarchy);
        this.getCube().createMonoDimension(this, hierarchy);
        return hierWrapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IHierarchy getHierarchy(String name) {
        if (name == null || name.length() == 0) {
            return null;
        }
        if (!this.isInitialised()) {
            this.getHierarchiesReadLock().lock();
            try {
                for (IHierarchy aHierarchy : this.hierarchies) {
                    if (!name.equals(aHierarchy.getUniqueName())) continue;
                    IHierarchy iHierarchy = aHierarchy;
                    return iHierarchy;
                }
            }
            finally {
                this.getHierarchiesReadLock().unlock();
            }
        }
        return super.getHierarchy(name);
    }

    @Override
    public boolean isDirectWrapping(String uniqueName) {
        return this.wrappedDimension.getID().equals(uniqueName);
    }
}

