/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.metadata.wrapper;

import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IFolder;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IProperty;
import com.cognos.xqe.metadata.IQueryItem;
import com.cognos.xqe.metadata.ISortItem;
import com.cognos.xqe.metadata.MetadataType;
import com.cognos.xqe.metadata.MetadataUtil;
import com.cognos.xqe.metadata.provider.Level;
import com.cognos.xqe.metadata.provider.MetadataConnection;
import com.cognos.xqe.metadata.provider.QueryItem;
import com.cognos.xqe.metadata.wrapper.CubeWrapper;
import com.cognos.xqe.metadata.wrapper.QueryItemOfLevelWrapper;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRLevel;
import com.cognos.xqe.util.UniqueNameGenerator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;

public class LevelWrapper
extends Level {
    private ILevel level;
    private String businessKeyModelExpression = null;
    private String applyTo;

    public LevelWrapper(IHierarchy hier, ILevel lev) {
        this.hierarchy = hier;
        this.level = lev;
        this.initialiseProperties();
    }

    @Override
    public void populateChildren() {
        if (this.initialisedChildren) {
            return;
        }
        if (this.childMetadataObjects == null) {
            this.childMetadataObjects = new ArrayList();
        }
        this.recursivePopulateChildren(this.level);
        this.initialisedChildren = true;
    }

    private void recursivePopulateChildren(IMetadata metadata) {
        for (IMetadata childObj : metadata.getChildMetadataObjects()) {
            QueryItemOfLevelWrapper wrappedfChild = null;
            if (childObj.getObjectType() == MetadataType.QUERY_ITEM) {
                CubeWrapper cube = (CubeWrapper)this.getHierarchy().getDimension().getCube();
                wrappedfChild = cube.createQueryItemOfLevel(this, (IQueryItem)childObj);
                continue;
            }
            if (childObj.getObjectType() == MetadataType.FOLDER) {
                this.recursivePopulateChildren(childObj);
                continue;
            }
            this.childMetadataObjects.add(wrappedfChild);
        }
    }

    @Override
    protected synchronized void initialiseProperties() {
        if (this.initialisedProperties) {
            return;
        }
        this.setConnection(this.level.getConnection());
        this.dataType = this.level.getDataType();
        this.caption = this.level.getCaption();
        this.description = this.level.getDescription();
        this.isUnique = this.level.isUnique();
        this.autoGenerated = this.level.isAutoGenerated();
        this.v5UniqueName = this.level.getV5UniqueName();
        this.autoGenerated = this.level.isAutoGenerated();
        this.initialised = true;
        this.orderOfMagnitude = this.level.getOrderOfMagnitude();
        String levelName = this.level.getName();
        IMember defaultMember = this.level.getHierarchy().getDefaultMember();
        if (defaultMember != null) {
            String defaultMemberName = defaultMember.getName();
            if (levelName.equals(defaultMemberName)) {
                StringBuilder sb = new StringBuilder(this.getHierarchy().getName());
                sb.append("_");
                sb.append(levelName);
                this.name = sb.toString();
            } else {
                this.name = this.level.getName();
            }
        } else {
            this.name = this.level.getName();
        }
        this.uniqueName = UniqueNameGenerator.appendUniqueName(this.getHierarchy().getUniqueName(), this.name);
        this.members = this.level.getMembers();
        this.initialisedProperties = true;
    }

    @Override
    public String toString() {
        return this.getUniqueName();
    }

    @Override
    public Object getProperty(String propertyName) {
        if (propertyName.compareTo("expression") == 0) {
            return null;
        }
        return this.level.getProperty(propertyName);
    }

    @Override
    public List<IProperty> getMemberProperties() {
        if (this.memberProperties.size() == 0) {
            this.populateChildren();
            ArrayList<IProperty> propertyList = new ArrayList<IProperty>();
            for (IMetadata item : this.childMetadataObjects) {
                if (!(item instanceof IProperty)) continue;
                propertyList.add((IProperty)item);
            }
            this.memberProperties = Collections.unmodifiableList(propertyList);
        }
        if (this.hasDynamicProperty()) {
            ArrayList<IProperty> rt = new ArrayList<IProperty>();
            rt.addAll(this.memberProperties);
            Collection dynamic = this.dynamicProperties.values();
            for (Object o : dynamic) {
                rt.add((IProperty)o);
            }
            return rt;
        }
        return this.memberProperties;
    }

    public boolean hasDynamicProperty() {
        return this.dynamicProperties != null && !this.dynamicProperties.isEmpty();
    }

    @Override
    public ISortItem[] getSortItems() {
        return this.level.getSortItems();
    }

    public IQueryItem getQueryItemWithRole(String role, boolean returnFirstIfNull) {
        return this.getQueryItemWithRole(this.level, role, returnFirstIfNull);
    }

    private IQueryItem getQueryItemWithRole(IMetadata metadata, String role, boolean returnFirstIfNull) {
        IQueryItem result = null;
        List<IMetadata> items = metadata.getChildMetadataObjects();
        IQueryItem firstQI = null;
        if (items.size() <= 0) {
            return null;
        }
        Iterator<IMetadata> it = items.iterator();
        while (result == null && it.hasNext()) {
            IQueryItem folderRes;
            IMetadata item = it.next();
            if (item instanceof IQueryItem) {
                IProperty qItem;
                List<String> roles;
                if (firstQI == null) {
                    firstQI = (IQueryItem)item;
                }
                if (!(item instanceof IProperty) || (roles = (qItem = (IProperty)item).getRoles()) == null || !roles.contains(role)) continue;
                result = (IQueryItem)item;
                continue;
            }
            if (!(item instanceof IFolder) || (folderRes = this.getQueryItemWithRole(item, role, false)) == null) continue;
            result = folderRes;
        }
        if (returnFirstIfNull && result == null) {
            result = firstQI;
        }
        return result;
    }

    public String getQueryItemExpressionForKey() {
        IQueryItem key;
        if (this.businessKeyModelExpression != null) {
            return this.businessKeyModelExpression;
        }
        String expr = (String)this.level.getProperty("expression");
        if (expr == null && (expr = (key = this.getBusinessKeyQueryItem()).getExpression()) == null) {
            expr = (String)key.getProperty("ID");
        }
        this.businessKeyModelExpression = MetadataUtil.extractExpressionFromModelString(expr);
        return this.businessKeyModelExpression;
    }

    public String getQueryItemExpressionForCaption() {
        String expr = (String)this.level.getProperty("expression");
        if (expr == null) {
            IQueryItem caption = this.getMemberCaptionQueryItem();
            if (caption == null) {
                caption = this.getBusinessKeyQueryItem();
            }
            if ((expr = caption.getExpression()) == null) {
                expr = (String)caption.getProperty("ID");
            }
        }
        return MetadataUtil.extractExpressionFromModelString(expr);
    }

    public IQueryItem getBusinessKeyQueryItem() {
        return this.getQueryItemWithRole(this.level, DMRLevel.BUSINESS_KEY, true);
    }

    public IQueryItem getMemberCaptionQueryItem() {
        return this.getQueryItemWithRole(this.level, DMRLevel.MEMBER_CAPTION, false);
    }

    @Override
    public boolean isDMR() {
        return true;
    }

    public String getV5Name() {
        return this.level.getName();
    }

    public ILevel getWrappedLevel() {
        return this.level;
    }

    public IProperty wrapToDynamicProperty(ILevel alevel, int rowsetId) {
        if (this.dynamicProperties == null) {
            this.dynamicProperties = new TreeMap();
        }
        DynamicPropertyWrapper rt = new DynamicPropertyWrapper();
        String atSign = "@";
        String name = alevel.getDimension().getName() + atSign + alevel.getName() + atSign + rowsetId;
        rt.setName(name);
        rt.wrapLevel = alevel;
        this.dynamicProperties.put(rt.getName(), rt);
        return rt;
    }

    public ILevel getSecondaryLevelByDynamicPropertyName(String name) {
        Object obj = this.dynamicProperties.get(name);
        if (obj == null || !(obj instanceof DynamicPropertyWrapper)) {
            return null;
        }
        return ((DynamicPropertyWrapper)obj).getWrappedLevel();
    }

    public String getApplyTo() {
        return this.applyTo;
    }

    public void setApplyTo(String s) {
        this.applyTo = s;
    }

    public class DynamicPropertyWrapper
    extends QueryItem
    implements IProperty {
        private ILevel wrapLevel;

        public ILevel getWrappedLevel() {
            return this.wrapLevel;
        }

        @Override
        public IHierarchy getHierarchy() {
            return LevelWrapper.this.getHierarchy();
        }

        @Override
        public IDimension getDimension() {
            return LevelWrapper.this.getDimension();
        }

        @Override
        public ILevel getLevel() {
            return LevelWrapper.this;
        }

        @Override
        public boolean isProperty() {
            return true;
        }

        @Override
        public String getDatatypeName() {
            return "nVarChar";
        }

        @Override
        public MetadataConnection getConnection() {
            return LevelWrapper.this.getConnection();
        }

        @Override
        public String getUniqueName() {
            return UniqueNameGenerator.appendUniqueName(LevelWrapper.this.getUniqueName(), this.name);
        }

        @Override
        public List<String> getRoles() {
            return null;
        }

        @Override
        public boolean isCustomProperty() {
            return false;
        }
    }
}

