/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.metadata.wrapper;

import com.cognos.xqe.metadata.AggregateTypeEnum;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IQueryItem;
import com.cognos.xqe.metadata.IScopeRelationship;
import com.cognos.xqe.metadata.MemberTypeEnum;
import com.cognos.xqe.metadata.provider.Measure;
import com.cognos.xqe.metadata.wrapper.CubeWrapper;
import com.cognos.xqe.metadata.wrapper.QueryItemWrapper;
import com.cognos.xqe.metadata.wrapper.ScopeRelationshipOfQueryItem;
import com.cognos.xqe.util.UniqueNameGenerator;
import java.util.ArrayList;
import java.util.List;

public class QueryItemOfQuerySubjectToMeasureWrapper
extends Measure
implements QueryItemWrapper {
    private IQueryItem queryItem;
    private List<IScopeRelationship> scopeRelationships;

    public QueryItemOfQuerySubjectToMeasureWrapper(IQueryItem qi) {
        this.queryItem = qi;
        this.initialiseProperties();
    }

    @Override
    protected synchronized void initialiseProperties() {
        if (this.initialisedProperties) {
            return;
        }
        this.setConnection(this.queryItem.getConnection());
        this.name = this.queryItem.getUniqueName();
        if (this.name == null) {
            this.name = this.queryItem.getName();
        }
        this.uniqueName = UniqueNameGenerator.createUniqueName(new String[]{"Measures", "Measures", this.name});
        this.v5UniqueName = this.queryItem.getV5UniqueName();
        this.setCaption(this.queryItem.getCaption());
        this.setDescription(this.queryItem.getDescription());
        this.setDataType(this.queryItem.getDataType());
        this.setPrecision(this.queryItem.getDatatypePrecision());
        this.setScale(this.queryItem.getDatatypeScale());
        this.setRegularAggregate(AggregateTypeEnum.valueOfModelString(this.queryItem.getRegularAggregate()));
        this.setType(MemberTypeEnum.REGULAR);
        this.setUniqueID(this.queryItem.toString());
        this.initialisedProperties = true;
    }

    @Override
    public String toString() {
        return this.getUniqueName();
    }

    @Override
    public Object getProperty(String propertyName) {
        if (propertyName.compareTo("expression") == 0) {
            return this.queryItem.getProperty("ID");
        }
        return this.queryItem.getProperty(propertyName);
    }

    @Override
    public boolean isRelational() {
        return true;
    }

    @Override
    public IScopeRelationship getScopeRelationship(IMetadata metadata) {
        this.initializeScopeRelationship();
        for (IScopeRelationship scopeRel : this.scopeRelationships) {
            IDimension dim = scopeRel.getNonMeasureDimension();
            if (dim != metadata) continue;
            return scopeRel;
        }
        ScopeRelationshipOfQueryItem scopeRel = new ScopeRelationshipOfQueryItem((CubeWrapper)this.getDimension().getCube(), (IDimension)metadata);
        this.scopeRelationships.add(scopeRel);
        return scopeRel;
    }

    private synchronized void initializeScopeRelationship() {
        if (this.scopeRelationships == null) {
            this.scopeRelationships = new ArrayList<IScopeRelationship>();
            for (IScopeRelationship sRel : this.getConnection().getScopeRelationships(this.getDimension().getID())) {
                this.scopeRelationships.add(sRel);
            }
        }
    }

    @Override
    public IQueryItem getQueryItem() {
        return this.queryItem;
    }
}

