/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.metadata.wrapper;

import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IShortcut;
import com.cognos.xqe.metadata.MetadataType;
import com.cognos.xqe.metadata.MetadataUtil;
import com.cognos.xqe.metadata.provider.Metadata;
import com.cognos.xqe.metadata.wrapper.CubeWrapper;

public class ShortcutWrapper
extends Metadata
implements IShortcut {
    private IShortcut shortcut;
    private CubeWrapper cubeWrapper;
    private IMetadata target;

    public ShortcutWrapper(IShortcut sc, CubeWrapper cube) {
        this.shortcut = sc;
        this.cubeWrapper = cube;
        this.initialiseProperties();
    }

    @Override
    protected synchronized void initialiseProperties() {
        if (this.initialisedProperties) {
            return;
        }
        this.setConnection(this.shortcut.getConnection());
        this.dataType = this.shortcut.getDataType();
        this.caption = this.shortcut.getCaption();
        this.description = this.shortcut.getDescription();
        this.v5UniqueName = this.shortcut.getV5UniqueName();
        this.name = this.shortcut.getName();
        this.uniqueName = this.shortcut.getUniqueName();
        this.uniqueID = this.shortcut.getUniqueID();
        this.initialised = true;
    }

    @Override
    public IMetadata getTarget() {
        if (this.target != null) {
            return this.target;
        }
        IMetadata t = this.shortcut.getTarget();
        this.target = this.cubeWrapper.getWrapper(t);
        return this.target;
    }

    @Override
    public String getTreatAs() {
        return this.shortcut.getTreatAs();
    }

    @Override
    public void setTarget(IMetadata targetObj) {
        IMetadata t;
        this.target = t = this.cubeWrapper.getWrapper(targetObj);
    }

    @Override
    public MetadataType getObjectType() {
        return this.shortcut.getObjectType();
    }

    @Override
    public boolean isShorcutTreatedAsAlias(boolean explicitShortcutProcessing) {
        if (explicitShortcutProcessing) {
            return "alias".equals(this.getTreatAs());
        }
        return MetadataUtil.shortcutTreatedAsAlias(this);
    }

    @Override
    public IMetadata getTargetWithShortcut() {
        return null;
    }

    @Override
    public boolean getUseInJoinPath() {
        return false;
    }
}

