/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.metadata.wrapper.tabstreamwrapper;

import com.cognos.xqe.ast.IXQENodeFactory;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.query.V5Source;
import com.cognos.xqe.ast.v5.result.V5QueryResultDefinition;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IModelDataSource;
import com.cognos.xqe.metadata.wrapper.CubeWrapper;
import com.cognos.xqe.metadata.wrapper.tabstreamwrapper.AbstractProcessor;
import com.cognos.xqe.metadata.wrapper.tabstreamwrapper.DummyRelationalDataSource;
import com.cognos.xqe.metadata.wrapper.tabstreamwrapper.ScalarFunctionProcessor;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import java.util.List;

public class TabStreamWrapper {
    public static final String NEED_TABSTREAM = "needTabularStream";
    protected CubeWrapper mCubeWrapper = null;
    protected AbstractProcessor mProcessor = null;

    protected TabStreamWrapper(CubeWrapper cubeWrapper) {
        this.mCubeWrapper = cubeWrapper;
    }

    public static boolean needTabStream(V5QueryResultDefinition v5QRD, V5Query v5Query) {
        if (v5QRD.isList()) {
            return false;
        }
        if (!v5Query.isTabular() && !v5Query.isRelStyle()) {
            return false;
        }
        V5Source src = v5Query.getV5Source();
        return src != null;
    }

    public static void updateV5DataItemsToWrapperLevels(PlanningEnvironment environment, IXQENodeFactory nodeFactory, V5QuerySet v5QuerySet, V5QueryResultDefinition v5QRD, V5Query v5Query, CubeWrapper theCubeWrapper, List<IModelDataSource> datasources) {
        TabStreamWrapper tabStream = new TabStreamWrapper(theCubeWrapper);
        theCubeWrapper.setTabStreamWrapper(tabStream);
        if (v5Query.isTabular() || v5Query.isRelStyle()) {
            v5Query.throwInternalError("xtab on relational style query should be handled by single query approach.");
        } else {
            V5Source source = v5Query.getV5Source();
            if (source.getNumberChildren() == 0) {
                tabStream.mProcessor = new ScalarFunctionProcessor(tabStream);
            }
        }
        tabStream.mProcessor.process(environment, nodeFactory, v5QuerySet, v5QRD, v5Query);
        boolean bRelDataSourceSet = false;
        for (IModelDataSource ds : datasources) {
            if (!ds.isRelational()) continue;
            theCubeWrapper.setDataSource(ds);
            bRelDataSourceSet = true;
            break;
        }
        if (!bRelDataSourceSet) {
            IModelDataSource iModelDataSource = datasources.get(0);
            DummyRelationalDataSource dummyDataSource = new DummyRelationalDataSource(theCubeWrapper.getName(), iModelDataSource.getCMDataSourceName());
            theCubeWrapper.setDataSource(dummyDataSource);
        }
    }

    public V5QuerySet createV5QuerySet(PlanningEnvironment planningEnv, List<IMetadata> projectedColumns, String queryName, boolean isV5QueryToLoadmembers) {
        return this.mProcessor.createV5QuerySet(planningEnv, projectedColumns, queryName, isV5QueryToLoadmembers);
    }
}

