/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.metadata.wrapper.tabstreamwrapper;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IProperty;
import com.cognos.xqe.metadata.provider.Dimension;
import com.cognos.xqe.metadata.provider.Hierarchy;
import com.cognos.xqe.metadata.provider.Level;
import com.cognos.xqe.metadata.provider.MetadataConnection;
import com.cognos.xqe.util.UniqueNameGenerator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class V5DataItemToLevelWrapper
extends Level {
    public static final String RET_RAW = "ReturnRaw";
    protected String mNativeV5Name = null;
    protected String mNativeHUN = null;
    protected String mNativeDUN = null;
    private IXQEQueryNode binaryExpression = null;

    public V5DataItemToLevelWrapper(Dimension levelDim, MetadataConnection connection, String levelName, String levelCaption, IDataType dataType, String expr) {
        this.initialiseProperties(levelDim, connection, levelName, levelCaption, dataType, expr);
        this.setInitialised();
    }

    protected synchronized void initialiseProperties(Dimension levelDim, MetadataConnection connection, String levelName, String levelCaption, IDataType dataType, String expr) {
        if (this.initialisedProperties) {
            return;
        }
        this.setConnection(connection);
        this.setName(levelName);
        Hierarchy levelHier = (Hierarchy)levelDim.getDefaultHierarchy();
        String theUniqueName = UniqueNameGenerator.createUniqueName(levelDim.getName(), levelHier.getName(), levelName);
        this.setUniqueName(theUniqueName);
        this.setV5UniqueName(theUniqueName);
        this.setProperty("externalName", this.getName());
        this.setCaption(levelCaption);
        this.setDescription(levelCaption);
        this.setDataType(dataType);
        this.setProperty("expression", expr);
        this.initialisedProperties = true;
    }

    public boolean isShell() {
        return true;
    }

    @Override
    public String toString() {
        return this.getUniqueName();
    }

    public boolean isV5QueryConditionRequireQuote() {
        return false;
    }

    @Override
    public List<IProperty> getMemberProperties() {
        if (this.memberProperties.isEmpty() && this.childMetadataObjects != null) {
            this.populateChildren();
            ArrayList<IProperty> propertyList = new ArrayList<IProperty>();
            for (IMetadata item : this.childMetadataObjects) {
                if (!(item instanceof IProperty)) continue;
                propertyList.add((IProperty)item);
            }
            this.memberProperties = Collections.unmodifiableList(propertyList);
        }
        return this.memberProperties;
    }

    public int getNumberOfExistingMemberProperties() {
        int n = 0;
        if (this.childMetadataObjects != null) {
            this.populateChildren();
            for (IMetadata item : this.childMetadataObjects) {
                if (!(item instanceof IProperty)) continue;
                ++n;
            }
        }
        return n;
    }

    public String getNativeV5Name() {
        return this.mNativeV5Name;
    }

    public String getNativeHUN() {
        return this.mNativeHUN;
    }

    public String getNativeDUN() {
        return this.mNativeDUN;
    }

    public IXQEQueryNode getBinaryExpression() {
        return this.binaryExpression;
    }

    public void setBinaryExpression(IXQEQueryNode binary) {
        this.binaryExpression = binary;
    }

    public IDataType getNativeDataType() {
        return this.dataType;
    }
}

