/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.metadata.wrapper.tabstreamwrapper;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.metadata.AggregateTypeEnum;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IScopeRelationship;
import com.cognos.xqe.metadata.MemberTypeEnum;
import com.cognos.xqe.metadata.MetadataType;
import com.cognos.xqe.metadata.provider.Dimension;
import com.cognos.xqe.metadata.provider.Hierarchy;
import com.cognos.xqe.metadata.provider.Measure;
import com.cognos.xqe.metadata.provider.MetadataConnection;
import com.cognos.xqe.metadata.wrapper.tabstreamwrapper.AbstractProcessor;
import com.cognos.xqe.metadata.wrapper.tabstreamwrapper.ScopeRelationshipOfV5DataItem;
import com.cognos.xqe.util.UniqueNameGenerator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class V5DataItemToMeasureWrapper
extends Measure {
    public static final String EXTERNALROLLUP_SCOPES = "externalRollUpScopes";
    protected AbstractProcessor mTabStreamWrapper;
    protected HashMap<IMetadata, IScopeRelationship> mScopeRelationships = new HashMap();
    protected String mNativeLUN = null;
    protected String mNativeDUN = null;
    protected String mNativeHUN = null;
    protected String mNativeMUN = null;
    protected String mNativePUN = null;
    private IXQEQueryNode binaryExpression = null;
    private String v5AggregateAttribute = null;

    public V5DataItemToMeasureWrapper(AbstractProcessor tabStream, Dimension measuresDim, MetadataConnection connection, String measureName, String measureCaption, IDataType dataType, String aggr) {
        this.initialiseProperties(tabStream, measuresDim, connection, measureName, measureCaption, dataType, aggr);
    }

    protected synchronized void initialiseProperties(AbstractProcessor tabStream, Dimension measuresDim, MetadataConnection connection, String measureName, String measureCaption, IDataType dataType, String aggr) {
        if (this.initialisedProperties) {
            return;
        }
        this.mTabStreamWrapper = tabStream;
        this.setConnection(connection);
        this.setName(measureName);
        Hierarchy measuresHier = (Hierarchy)measuresDim.getDefaultHierarchy();
        String theUniqueName = UniqueNameGenerator.createUniqueName(measuresDim.getName(), measuresHier.getName(), measureName);
        this.setUniqueName(theUniqueName);
        this.setV5UniqueName(theUniqueName);
        this.setCaption(measureCaption);
        this.setDescription(measureCaption);
        this.setDataType(dataType);
        this.setRegularAggregate(AggregateTypeEnum.valueOfV5String(aggr));
        this.setType(MemberTypeEnum.REGULAR);
        this.setUniqueID(this.getName());
        this.initialisedProperties = true;
    }

    @Override
    public String toString() {
        return this.getUniqueName();
    }

    @Override
    public boolean isRelational() {
        return true;
    }

    @Override
    public IScopeRelationship getScopeRelationship(IMetadata otherMetadata) {
        if (this.mScopeRelationships.containsKey(otherMetadata)) {
            return this.mScopeRelationships.get(otherMetadata);
        }
        if (otherMetadata.getObjectType() != MetadataType.DIMENSION) {
            return null;
        }
        IDimension dimension = (IDimension)otherMetadata;
        ILevel lowestLevel = null;
        if (this.mTabStreamWrapper != null) {
            lowestLevel = this.mTabStreamWrapper.getWrapperLevel(dimension);
            if (lowestLevel == null) {
                return null;
            }
        } else {
            IHierarchy hierarchy = dimension.getDefaultHierarchy();
            List<ILevel> levels = hierarchy.getLevels();
            if (levels.isEmpty()) {
                return null;
            }
            lowestLevel = levels.get(levels.size() - 1);
        }
        ScopeRelationshipOfV5DataItem scopeRel = new ScopeRelationshipOfV5DataItem(dimension, this, lowestLevel);
        this.mScopeRelationships.put(dimension, scopeRel);
        return scopeRel;
    }

    public String getNativeLUN() {
        return this.mNativeLUN;
    }

    public String getNativeDUN() {
        return this.mNativeDUN;
    }

    public String getNativeHUN() {
        return this.mNativeHUN;
    }

    public String getNativeMUN() {
        return this.mNativeMUN;
    }

    public String getNativePUN() {
        return this.mNativePUN;
    }

    public void setColumnPosition(String expr) {
        this.setProperty("expression", expr);
    }

    public boolean containsScope(ArrayList<ILevel> scope) {
        HashMap map = (HashMap)this.getProperty(EXTERNALROLLUP_SCOPES);
        if (map == null) {
            return false;
        }
        return map.containsKey(scope);
    }

    public void addScope(ArrayList<ILevel> scope, String colPos) {
        HashMap<ArrayList<ILevel>, String> map = (HashMap<ArrayList<ILevel>, String>)this.getProperty(EXTERNALROLLUP_SCOPES);
        if (map == null) {
            map = new HashMap<ArrayList<ILevel>, String>();
            this.setProperty(EXTERNALROLLUP_SCOPES, map);
        }
        map.put(scope, colPos);
    }

    public IXQEQueryNode getBinaryExpression() {
        return this.binaryExpression;
    }

    public void setBinaryExpression(IXQEQueryNode binary) {
        this.binaryExpression = binary;
    }

    public String getV5AggregateAttribute() {
        return this.v5AggregateAttribute;
    }

    public void setV5AggregateAttribute(String aggregate) {
        this.v5AggregateAttribute = aggregate;
    }
}

