/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.metrics;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metrics.MetricsManager;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.util.Timer;
import java.util.TimerTask;

public class MemoryMetricsUpdater {
    public static final String XQE_CURRENT_HEAP_SIZE = "CurrentHeapSize";
    public static final String XQE_COMMITED_HEAP_SIZE = "CommittedHeapSize";
    public static final String XQE_COMMITED_HEAP_SIZE_HIGH_WATERMARK = "CommittedHeapSizeHighWatermark";
    public static final String XQE_CURRENT_HEAP_SIZE_HIGH_WATERMARK = "CurrentHeapSizeHighWatermark";
    public static final String XQE_REQUESTED_INITIAL_HEAP_SIZE = "RequestedInitialHeapSize";
    public static final String XQE_REQUESTED_MAXIMUM_HEAP_SIZE = "RequestedMaximumHeapSize";
    private static final int DEFAULT_UPDATE_TIME = 30000;
    private int memoryMetricsUpdateTime = 30000;
    private static final long DELAY = 0L;
    private Timer threadMemoryMetricsTimer = null;
    private TimerTask memoryMetricsUpdateTask = null;
    private final MemoryMXBean mxBean = ManagementFactory.getMemoryMXBean();
    private MemoryUsage memoryUsage = null;

    public MemoryMetricsUpdater() {
        this.threadMemoryMetricsTimer = new Timer("MemoryMetricsUpdater-Timer", true);
        this.setMemoryMetricsUpdateTime();
    }

    public void initializeMemoryMetrics() {
        this.memoryUsage = this.mxBean.getHeapMemoryUsage();
        long commited = this.memoryUsage.getCommitted();
        long used = this.memoryUsage.getUsed();
        MetricsManager.createMetric(XQE_CURRENT_HEAP_SIZE, used);
        MetricsManager.createMetric(XQE_COMMITED_HEAP_SIZE, commited);
        MetricsManager.createMetric(XQE_COMMITED_HEAP_SIZE_HIGH_WATERMARK, commited);
        MetricsManager.createMetric(XQE_CURRENT_HEAP_SIZE_HIGH_WATERMARK, used);
        MetricsManager.createMetric(XQE_REQUESTED_INITIAL_HEAP_SIZE, this.memoryUsage.getInit());
        MetricsManager.createMetric(XQE_REQUESTED_MAXIMUM_HEAP_SIZE, this.memoryUsage.getMax());
    }

    public void updateMemoryMetrics() {
        this.memoryUsage = this.mxBean.getHeapMemoryUsage();
        long committedHeapSize = this.memoryUsage.getCommitted();
        long currentHeapSize = this.memoryUsage.getUsed();
        MetricsManager.setMetricValue(XQE_COMMITED_HEAP_SIZE, committedHeapSize);
        MetricsManager.setMetricValue(XQE_CURRENT_HEAP_SIZE, currentHeapSize);
        if (committedHeapSize > MetricsManager.getCounterLongValue(XQE_COMMITED_HEAP_SIZE_HIGH_WATERMARK)) {
            MetricsManager.setMetricValue(XQE_COMMITED_HEAP_SIZE_HIGH_WATERMARK, committedHeapSize);
        }
        if (currentHeapSize > MetricsManager.getCounterLongValue(XQE_CURRENT_HEAP_SIZE_HIGH_WATERMARK)) {
            MetricsManager.setMetricValue(XQE_CURRENT_HEAP_SIZE_HIGH_WATERMARK, currentHeapSize);
        }
    }

    private void setMemoryMetricsUpdateTime() {
        XQEConfiguration configuration = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        try {
            if (configuration != null) {
                this.memoryMetricsUpdateTime = configuration.getIntegerProperty("general.updateTime[@metrics]", 30000);
            }
        }
        catch (Throwable ex) {
            throw new XQERuntimeException(XQEMessageKeys.INI_ErrorDuringInitialization, ex, "memoryMetricsUpdateTime");
        }
    }

    public void startMemoryMetricsUpdateTask() {
        this.initializeMemoryMetrics();
        this.memoryMetricsUpdateTask = new TimerTask(){

            @Override
            public void run() {
                MemoryMetricsUpdater.this.updateMemoryMetrics();
            }
        };
        this.threadMemoryMetricsTimer.scheduleAtFixedRate(this.memoryMetricsUpdateTask, 0L, (long)this.memoryMetricsUpdateTime);
    }

    public void stopMemoryMetricsUpdateTask() {
        this.memoryMetricsUpdateTask.cancel();
    }

    public int getMemoryMetricsUpdateTime() {
        return this.memoryMetricsUpdateTime;
    }

    public MemoryUsage getMemoryUsage() {
        return this.memoryUsage;
    }
}

