/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.pool.connection;

import com.cognos.xqe.pool.connection.IConnectionParameter;
import com.cognos.xqe.security.IEncryptedObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang.builder.HashCodeBuilder;

public final class ConnectionParameters
implements Iterable<IConnectionParameter<?>> {
    private final ConcurrentMap<String, IConnectionParameter<?>> parameterMap;
    private final ConcurrentLinkedQueue<IConnectionParameter<?>> matchableParameters;
    private final AtomicInteger cachedHashCode = new AtomicInteger(Integer.MIN_VALUE);

    public ConnectionParameters() {
        this.parameterMap = new ConcurrentHashMap();
        this.matchableParameters = new ConcurrentLinkedQueue();
    }

    public int size() {
        return this.parameterMap.size();
    }

    public boolean contains(IConnectionParameter<?> parameter) {
        IConnectionParameter p = (IConnectionParameter)this.parameterMap.get(parameter.getClass().getName());
        if (null == p) {
            return false;
        }
        return p.matches(parameter);
    }

    public boolean contains(Class<? extends IConnectionParameter<?>> parameterType) {
        return this.parameterMap.containsKey(parameterType.getName());
    }

    public IConnectionParameter<?> put(IConnectionParameter<?> parameter) {
        Class<?> parameterType = parameter.getClass();
        IConnectionParameter<?> previous = this.parameterMap.put(parameterType.getName(), parameter);
        if (previous != null && previous.isMatchable()) {
            this.matchableParameters.remove(previous);
        }
        if (parameter.isMatchable()) {
            this.matchableParameters.add(parameter);
        }
        this.cachedHashCode.set(Integer.MIN_VALUE);
        return previous;
    }

    public <T extends IConnectionParameter<?>> T get(Class<T> parameterType) {
        IConnectionParameter parameter = (IConnectionParameter)this.parameterMap.get(parameterType.getName());
        return (T)parameter;
    }

    public IConnectionParameter<?> remove(Class<? extends IConnectionParameter<?>> parameterType) {
        IConnectionParameter param = (IConnectionParameter)this.parameterMap.remove(parameterType.getName());
        this.matchableParameters.remove(param);
        this.cachedHashCode.set(Integer.MIN_VALUE);
        return param;
    }

    public void clear() {
        this.parameterMap.clear();
        this.matchableParameters.clear();
        this.cachedHashCode.set(Integer.MIN_VALUE);
    }

    @Override
    public Iterator<IConnectionParameter<?>> iterator() {
        return this.parameterMap.values().iterator();
    }

    public Object valueOf(Class<? extends IConnectionParameter<?>> parameterType) {
        IConnectionParameter p = (IConnectionParameter)this.parameterMap.get(parameterType.getName());
        if (null == p) {
            return null;
        }
        if (p.value() instanceof IEncryptedObject) {
            return ((IEncryptedObject)p.value()).decrypt();
        }
        return p.value();
    }

    public <T> T valueOf(Class<? extends IConnectionParameter<?>> parameterType, Class<T> returnType) {
        Object value = this.valueOf(parameterType);
        return (T)value;
    }

    public boolean booleanValueOf(Class<? extends IConnectionParameter<?>> parameterType, boolean defaultValue) {
        IConnectionParameter p = (IConnectionParameter)this.parameterMap.get(parameterType.getName());
        if (null == p) {
            return defaultValue;
        }
        Object value = p.value();
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        throw new ClassCastException();
    }

    public int intValueOf(Class<? extends IConnectionParameter<?>> parameterType, int defaultValue) {
        IConnectionParameter p = (IConnectionParameter)this.parameterMap.get(parameterType.getName());
        if (null == p) {
            return defaultValue;
        }
        Object value = p.value();
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        throw new ClassCastException();
    }

    public long longValueOf(Class<? extends IConnectionParameter<?>> parameterType, long defaultValue) {
        IConnectionParameter p = (IConnectionParameter)this.parameterMap.get(parameterType.getName());
        if (null == p) {
            return defaultValue;
        }
        Object value = p.value();
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        throw new ClassCastException();
    }

    public double doubleValueOf(Class<? extends IConnectionParameter<?>> parameterType, double defaultValue) {
        IConnectionParameter p = (IConnectionParameter)this.parameterMap.get(parameterType.getName());
        if (null == p) {
            return defaultValue;
        }
        Object value = p.value();
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        throw new ClassCastException();
    }

    public boolean matches(ConnectionParameters other) {
        if (this == other) {
            return true;
        }
        if (this.matchableParameters.size() != other.matchableParameters.size()) {
            return false;
        }
        for (IConnectionParameter<?> param : this.matchableParameters) {
            if (!param.isMatchable() || other.matchableParameters.contains(param)) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ConnectionParameters)) {
            return false;
        }
        ConnectionParameters otherParams = (ConnectionParameters)other;
        return this.matches(otherParams);
    }

    public int hashCode() {
        int hashCode;
        block2: {
            int prevHashCode;
            hashCode = this.cachedHashCode.get();
            if (Integer.MIN_VALUE != hashCode) break block2;
            do {
                prevHashCode = this.cachedHashCode.get();
                HashCodeBuilder hcb = new HashCodeBuilder();
                for (IConnectionParameter<?> param : this) {
                    if (!param.isMatchable()) continue;
                    hcb.append(param);
                }
                hashCode = hcb.toHashCode();
                if (Integer.MIN_VALUE != hashCode) continue;
                hashCode = 0;
            } while (!this.cachedHashCode.compareAndSet(prevHashCode, hashCode));
        }
        return hashCode;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        boolean first = true;
        ArrayList<String> sortedParamValues = new ArrayList<String>();
        for (IConnectionParameter<?> iConnectionParameter : this) {
            if (!iConnectionParameter.isLoggable()) continue;
            sortedParamValues.add(iConnectionParameter.toString());
        }
        Collections.sort(sortedParamValues);
        buffer.append('{');
        for (String string : sortedParamValues) {
            if (first) {
                first = false;
            } else {
                buffer.append(", ");
            }
            buffer.append(string.toString());
        }
        buffer.append('}');
        return buffer.toString();
    }

    public ConnectionParameters duplicate() {
        ConnectionParameters copy = new ConnectionParameters();
        for (IConnectionParameter<?> param : this) {
            copy.put(param);
        }
        return copy;
    }
}

