/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.pool.connection;

import com.cognos.xqe.pool.connection.IExpirationPolicy;
import com.cognos.xqe.pool.connection.IPooledConnection;

public class DefaultExpirationPolicy
implements IExpirationPolicy {
    private final long mLifetimeExpirationThreshold;
    private final long mIdleExpirationThreshold;

    public DefaultExpirationPolicy(long lifetimeExpirationThreshold, long idleExpirationThreshold) {
        this.mLifetimeExpirationThreshold = lifetimeExpirationThreshold;
        this.mIdleExpirationThreshold = idleExpirationThreshold;
    }

    @Override
    public IExpirationPolicy.ExpirationResponse canExpire(IPooledConnection pooledConnection) {
        long timeMillis = System.currentTimeMillis();
        if (this.mLifetimeExpirationThreshold > 0L && pooledConnection.aliveSince(timeMillis - this.mLifetimeExpirationThreshold)) {
            return IExpirationPolicy.ExpirationResponse.RELEASE_IMMEDIATELY;
        }
        if (this.mIdleExpirationThreshold > 0L && pooledConnection.idleSince(timeMillis - this.mIdleExpirationThreshold)) {
            return IExpirationPolicy.ExpirationResponse.RELEASE_IF_IDLE;
        }
        return IExpirationPolicy.ExpirationResponse.DO_NOTHING;
    }
}

