/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.pool.connection.impl;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.data.providers.relational.jdbc.JDBCConnection;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.pool.connection.ConnectionParameters;
import com.cognos.xqe.pool.connection.IConnectionFactory;
import com.cognos.xqe.pool.connection.IConnectionSelector;
import com.cognos.xqe.pool.connection.IInstrumentedPooledConnection;
import com.cognos.xqe.pool.connection.IPooledConnection;
import com.cognos.xqe.pool.connection.impl.SelectorContext;
import com.cognos.xqe.pool.connection.poolfactory.IProviderConnectionPool;
import com.cognos.xqe.query.engine.QueryEngine;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.util.ISizable;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;

class PoolRecord
implements IPooledConnection {
    private static final long DEFAULT_LOCK_PERIOD = 2000L;
    private static final XQELogger TRACE_LOGGER = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "CacheManager", LogLevel.INFO);
    private final IProviderConnectionPool mProviderConnectionPool;
    private final Object mConnection;
    private final IConnectionFactory mConnectionFactory;
    private final AtomicInteger mCurrentUseCount;
    private volatile boolean mReusable;
    private final AtomicBoolean mReleased;
    private final long mCreationTimeMillis;
    private volatile long mLastReturnedTimeMillis;
    private final ReentrantLock mLock;

    PoolRecord(IProviderConnectionPool providerConnectionPool, Object connection, IConnectionFactory connectionFactory) {
        this.mProviderConnectionPool = providerConnectionPool;
        this.mConnection = connection;
        this.mConnectionFactory = connectionFactory;
        this.mCurrentUseCount = new AtomicInteger(1);
        this.mReusable = true;
        this.mReleased = new AtomicBoolean(false);
        this.mLastReturnedTimeMillis = this.mCreationTimeMillis = System.currentTimeMillis();
        this.mLock = new ReentrantLock();
    }

    @Override
    public Object getConnection() {
        return this.mConnection;
    }

    @Override
    public int getCurrentUseCount() {
        return this.mCurrentUseCount.get();
    }

    @Override
    public void returnConnection() {
        this.mProviderConnectionPool.returnConnection(this);
    }

    @Override
    public void setNotReusable() {
        this.mReusable = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    IConnectionSelector.ReturnCode selectConnection(IConnectionSelector connectionSelector, ConnectionParameters connectionParameters, SelectorContext context, Queue<PoolRecord> skipList, int maxUseCount) {
        boolean blocking;
        long lastClearCacheTime;
        if (!this.mReusable) return IConnectionSelector.ReturnCode.NOT_MATCH;
        if (this.getConnection() instanceof JDBCConnection && (lastClearCacheTime = QueryEngine.getInstance().getLastClearCacheTime()) != 0L && this.getCreationTime() <= lastClearCacheTime) {
            this.setNotReusable();
            JDBCConnection jdbcConnection = (JDBCConnection)this.getConnection();
            StringBuilder sb = new StringBuilder("Set connection ");
            sb.append(jdbcConnection.toString());
            sb.append(" of data source ");
            sb.append(jdbcConnection.getDataSource().getName());
            sb.append(" as not reusable because its associated result set cache is out of date");
            TRACE_LOGGER.log(LogLevel.INFO, sb.toString());
            return IConnectionSelector.ReturnCode.NOT_MATCH;
        }
        int oldCount = this.mCurrentUseCount.get();
        int newCount = oldCount + 1;
        if (oldCount >= maxUseCount) return IConnectionSelector.ReturnCode.NOT_MATCH;
        boolean bl = blocking = skipList == null;
        if (this.doLock(blocking)) {
            IConnectionSelector.ReturnCode rc;
            try {
                rc = connectionSelector.selectConnection(connectionParameters, context, this);
            }
            finally {
                this.unlock();
            }
            if (rc != IConnectionSelector.ReturnCode.MATCH) return rc;
            if (this.mCurrentUseCount.compareAndSet(oldCount, newCount)) {
                return IConnectionSelector.ReturnCode.MATCH;
            }
            if (blocking) return IConnectionSelector.ReturnCode.NOT_MATCH;
            skipList.add(this);
            return IConnectionSelector.ReturnCode.NOT_MATCH;
        }
        if (blocking) return IConnectionSelector.ReturnCode.NOT_MATCH;
        skipList.add(this);
        return IConnectionSelector.ReturnCode.NOT_MATCH;
    }

    int deselectConnection() {
        int count = this.mCurrentUseCount.decrementAndGet();
        if (count < 0) {
            this.setNotReusable();
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "mCurrentUseCount (" + this.mCurrentUseCount + ")<= 0");
        }
        this.mLastReturnedTimeMillis = System.currentTimeMillis();
        return count;
    }

    @Override
    public boolean idleSince(long timeMillis) {
        return this.isIdle() && this.mLastReturnedTimeMillis < timeMillis;
    }

    @Override
    public boolean aliveSince(long timeMillis) {
        return this.mCreationTimeMillis < timeMillis;
    }

    public long getCreationTime() {
        return this.mCreationTimeMillis;
    }

    boolean isIdle() {
        return this.mCurrentUseCount.get() <= 0;
    }

    IConnectionFactory getConnectionFactory() {
        return this.mConnectionFactory;
    }

    @Override
    public long getLastReturnedTimeMillis() {
        return this.mLastReturnedTimeMillis;
    }

    boolean isReusable() {
        return this.mReusable;
    }

    boolean releaseIfIdle(boolean blocking) {
        boolean safeToRelease = false;
        if (this.doLock(blocking)) {
            try {
                if (this.isIdle()) {
                    this.setNotReusable();
                    safeToRelease = true;
                }
            }
            finally {
                this.unlock();
            }
        }
        if (safeToRelease && this.mReleased.compareAndSet(false, true)) {
            this.mConnectionFactory.destroyConnection(this);
            return true;
        }
        return false;
    }

    private boolean doLock(boolean blocking) {
        if (blocking) {
            try {
                return this.mLock.tryLock(2000L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                return false;
            }
        }
        return this.mLock.tryLock();
    }

    private void unlock() {
        this.mLock.unlock();
    }

    public long getSize() {
        if (this.mConnection instanceof ISizable) {
            return ((ISizable)this.mConnection).getSize();
        }
        return 0L;
    }

    public Set<Object> getCachingStatistics() {
        Set<Object> result = null;
        if (this.mConnection instanceof IInstrumentedPooledConnection) {
            IInstrumentedPooledConnection instrumentedPooledConnection = (IInstrumentedPooledConnection)this.mConnection;
            result = instrumentedPooledConnection.getCachingStatistics();
        }
        return result;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("{");
        buffer.append("use #: ");
        buffer.append(this.mCurrentUseCount.get());
        buffer.append(", mReusable: ");
        buffer.append(this.mReusable);
        buffer.append(", isIdle: ");
        buffer.append(this.isIdle());
        buffer.append(", last returned: ");
        buffer.append(this.mLastReturnedTimeMillis);
        buffer.append(": ");
        buffer.append(this.mConnection.toString());
        buffer.append("}");
        return buffer.toString();
    }
}

