/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.pool.connection.impl;

import com.cognos.xqe.data.providers.connection.parameters.ForceConnectionCreationParameter;
import com.cognos.xqe.pool.connection.ConnectionParameters;
import com.cognos.xqe.pool.connection.IConnectionFactory;
import com.cognos.xqe.pool.connection.IConnectionSelector;
import com.cognos.xqe.pool.connection.IExpirationPolicy;
import com.cognos.xqe.pool.connection.IPooledConnection;
import com.cognos.xqe.pool.connection.impl.PoolRecord;
import com.cognos.xqe.pool.connection.impl.PoolRecordList;
import com.cognos.xqe.pool.connection.poolfactory.IProviderConnectionPool;
import com.cognos.xqe.zipi.ZipiBridge;
import com.ibm.cognos.pogo.zipi.ZipiTimer;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;

public class ProviderConnectionPool
implements IProviderConnectionPool {
    public static final int MAX_NUMBER_OF_CONCURRENT_CONNECTION_USERS = 1;
    protected final PoolRecordList mPoolRecordList;

    public ProviderConnectionPool() {
        this(1);
    }

    public ProviderConnectionPool(int connectionMaxConcurrentReuse) {
        this.mPoolRecordList = connectionMaxConcurrentReuse > 0 ? new PoolRecordList(connectionMaxConcurrentReuse) : new PoolRecordList(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IPooledConnection borrowConnection(ConnectionParameters connectionParameters, IConnectionSelector connectionSelector, IConnectionFactory connectionFactory) {
        PoolRecord pooledConnection = null;
        if (!connectionParameters.contains(ForceConnectionCreationParameter.class)) {
            PoolRecord idlePoolRecord = this.mPoolRecordList.selectPoolRecord(connectionParameters, connectionSelector);
            if (null != idlePoolRecord) {
                pooledConnection = idlePoolRecord;
            } else {
                this.prepareForConnectionCreation();
            }
        }
        if (null == pooledConnection) {
            ZipiTimer zipiTimer = ZipiBridge.startTimer("DQCreateDatabaseConnection");
            try {
                Object connection = connectionFactory.createConnection(connectionParameters);
                pooledConnection = this.addCreatedConnection(connection, connectionFactory);
            }
            finally {
                if (zipiTimer != null) {
                    zipiTimer.stop();
                }
            }
        }
        return pooledConnection;
    }

    protected void prepareForConnectionCreation() {
    }

    protected PoolRecord addCreatedConnection(Object connection, IConnectionFactory connectionFactory) {
        PoolRecord poolRecord = new PoolRecord(this, connection, connectionFactory);
        this.mPoolRecordList.addCreatedPoolRecord(poolRecord);
        return poolRecord;
    }

    @Override
    public void returnConnection(IPooledConnection pooledConnection) {
        ((PoolRecord)pooledConnection).deselectConnection();
    }

    @Override
    public IConnectionSelector.ReturnCode selectConnection(IPooledConnection pooledConnection, IConnectionSelector connectionSelector, ConnectionParameters connectionParameters, int maxUseCount) {
        return ((PoolRecord)pooledConnection).selectConnection(connectionSelector, connectionParameters, null, null, maxUseCount);
    }

    @Override
    public int deselectConnection(IPooledConnection pooledConnection) {
        return ((PoolRecord)pooledConnection).deselectConnection();
    }

    @Override
    public void release() {
        this.mPoolRecordList.release();
    }

    @Override
    public int getNumberOfBorrowedConnections() {
        return this.mPoolRecordList.getBorrowedPoolRecords().size();
    }

    @Override
    public int getNumberOfIdleConnections() {
        return this.mPoolRecordList.getIdlePoolRecords().size();
    }

    @Override
    public Map<IPooledConnection, Set<Object>> getCachingStatistics() {
        HashMap<PoolRecord, Set<Object>> result = null;
        for (PoolRecord poolRecord : this.mPoolRecordList.getBorrowedPoolRecords()) {
            Set<Object> individualResult = poolRecord.getCachingStatistics();
            if (null == individualResult) continue;
            if (null == result) {
                result = new HashMap<PoolRecord, Set<Object>>();
            }
            result.put(poolRecord, individualResult);
        }
        return result;
    }

    @Override
    public void returnAllBorrowedConnections() {
        Queue<PoolRecord> borrowedSet = this.mPoolRecordList.getBorrowedPoolRecords();
        if (!borrowedSet.isEmpty()) {
            for (PoolRecord r : borrowedSet) {
                r.returnConnection();
            }
        }
    }

    @Override
    public void closeAllIdleConnections() {
        this.mPoolRecordList.tryReleasingExpiredAndInvalidatedPoolRecords(new IExpirationPolicy(){

            @Override
            public IExpirationPolicy.ExpirationResponse canExpire(IPooledConnection pooledConnection) {
                return IExpirationPolicy.ExpirationResponse.RELEASE_IMMEDIATELY;
            }
        });
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        LinkedList<PoolRecord> borrowed = new LinkedList<PoolRecord>();
        LinkedList<PoolRecord> idle = new LinkedList<PoolRecord>();
        LinkedList<PoolRecord> notReusable = new LinkedList<PoolRecord>();
        this.mPoolRecordList.getRecordsByType(idle, borrowed, notReusable);
        buffer.append("Idle#: ");
        buffer.append(idle.size());
        buffer.append(" Borrowed#: ");
        buffer.append(borrowed.size());
        buffer.append(" NotReusable#: ");
        buffer.append(notReusable.size());
        buffer.append("\nIdle: ");
        for (PoolRecord poolRecord : idle) {
            buffer.append('\n');
            buffer.append(poolRecord);
        }
        buffer.append("\nBorrowed: ");
        for (PoolRecord poolRecord : borrowed) {
            buffer.append('\n');
            buffer.append(poolRecord);
        }
        buffer.append("\nNotReusable: ");
        for (PoolRecord poolRecord : notReusable) {
            buffer.append('\n');
            buffer.append(poolRecord);
        }
        return buffer.toString();
    }
}

