/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.pool.connection.impl;

import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.pool.connection.IConnectionFactory;
import com.cognos.xqe.pool.connection.IExpirationPolicy;
import com.cognos.xqe.pool.connection.impl.PoolRecord;
import com.cognos.xqe.pool.connection.impl.ProviderExpirableConnectionPool;
import java.util.Timer;
import java.util.concurrent.atomic.AtomicInteger;

public class ProviderConnectionPoolBounded
extends ProviderExpirableConnectionPool {
    protected static final String NON_POSITIVE_STRING = ")<= 0";
    final int mMaxNumberOfConnections;
    final AtomicInteger mNbCreationInProgress;

    public ProviderConnectionPoolBounded(Timer expirationTimer, IExpirationPolicy connectionExpirationPolicy, int connectionExpirationCheckPeriod, int maxNumberOfConnections, int connectionMaxConcurrentReuse) {
        super(expirationTimer, connectionExpirationPolicy, connectionExpirationCheckPeriod, connectionMaxConcurrentReuse);
        this.mMaxNumberOfConnections = maxNumberOfConnections;
        this.mNbCreationInProgress = new AtomicInteger(0);
        if (maxNumberOfConnections <= 0) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "maxNumberOfConnections (" + maxNumberOfConnections + NON_POSITIVE_STRING);
        }
    }

    @Override
    protected void prepareForConnectionCreation() {
        boolean poolRecordToDestroyed = false;
        if (this.mPoolRecordList.size() + this.mNbCreationInProgress.get() < this.mMaxNumberOfConnections) {
            this.mNbCreationInProgress.incrementAndGet();
        } else {
            poolRecordToDestroyed = this.mPoolRecordList.releaseOldestPoolRecord();
            if (!poolRecordToDestroyed) {
                throw new XQERuntimeException(XQEMessageKeys.EXE_MaxConnectionNumberExceeded, new Integer(this.mMaxNumberOfConnections).toString());
            }
            this.mNbCreationInProgress.incrementAndGet();
        }
    }

    @Override
    protected PoolRecord addCreatedConnection(Object connection, IConnectionFactory connectionFactory) {
        PoolRecord poolRecord = new PoolRecord(this, connection, connectionFactory);
        if (this.mNbCreationInProgress.get() <= 0) {
            this.mPoolRecordList.addCreatedPoolRecord(poolRecord);
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "mNbCreationInProgress (" + this.mNbCreationInProgress + NON_POSITIVE_STRING);
        }
        this.mPoolRecordList.addCreatedPoolRecord(poolRecord);
        this.mNbCreationInProgress.decrementAndGet();
        return poolRecord;
    }
}

