/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.query.engine;

import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.query.engine.IExecutionEnvironment;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import java.util.concurrent.atomic.AtomicLong;

public final class MultiRequestReference<T> {
    private static final AtomicLong REF_ID_GENERATOR = new AtomicLong();
    private final Long refId = MultiRequestReference.nextRefId();

    private static long nextRefId() {
        return REF_ID_GENERATOR.incrementAndGet();
    }

    public T get() {
        IExecutionEnvironment execEnv = ExecutionEnvironmentContext.getExecutionEnvironment();
        return this.get(execEnv);
    }

    public T get(IExecutionEnvironment execEnv) {
        if (null == execEnv) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_ExecutionEnvironmentMissing_INTERNAL);
        }
        return (T)execEnv.getMultiRequestContext().getReferenceById(this.refId);
    }

    public void set(T referent) {
        IExecutionEnvironment execEnv = ExecutionEnvironmentContext.getExecutionEnvironment();
        this.set(execEnv, referent);
    }

    public void set(IExecutionEnvironment execEnv, T referent) {
        if (null == execEnv) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_ExecutionEnvironmentMissing_INTERNAL);
        }
        execEnv.getMultiRequestContext().putReferenceById(this.refId, referent);
    }

    public void clear() {
        IExecutionEnvironment execEnv = ExecutionEnvironmentContext.getExecutionEnvironment();
        this.clear(execEnv);
    }

    public void clear(IExecutionEnvironment execEnv) {
        if (null == execEnv) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_ExecutionEnvironmentMissing_INTERNAL);
        }
        execEnv.getMultiRequestContext().removeReferenceById(this.refId);
    }
}

