/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.query.engine;

import com.cognos.xqe.ast.IXQEPersist;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQEPersistContext;
import com.cognos.xqe.ast.XQERestoreContext;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.masterdetail.MasterDetailProvider;
import com.cognos.xqe.query.parameters.Parameter;
import com.cognos.xqe.query.parameters.RequestParameters;
import com.cognos.xqe.runtree.PlannedV5QuerySet;
import com.cognos.xqe.trace.TraceLogWriter;
import com.cognos.xqe.trace.XQEDebugLog;
import com.cognos.xqe.trace.XQETrace;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.XPath;

public class PersistentQueryPlan {
    public static final String UTF_8 = "UTF-8";
    public static final String ELEMENT_CURSORS = "Cursors";
    public static final String ELEMENT_PARAMETERS = "Parameters";
    public static final String ELEMENT_CURSOR = "Cursor";
    private Map<String, byte[]> cursors = new TreeMap<String, byte[]>();
    private List<byte[]> plans = new ArrayList<byte[]>();

    public void addPlan(IPlanningEnvironment env, V5QuerySet querySet, int pass) {
        byte[] plan = this.planToBytes(env, querySet, pass);
        if (plan != null) {
            this.plans.add(plan);
        }
    }

    public void addPlan(IPlanningEnvironment env, PlannedV5QuerySet querySet) {
        byte[] plan = this.planToBytes(env, querySet);
        if (plan != null) {
            this.plans.add(plan);
        }
    }

    public void addCursor(String cursorName, IXQEQueryNode[] nodes) {
        byte[] cursor = this.subtreeToBytes(nodes);
        if (cursor != null) {
            this.cursors.put(cursorName, cursor);
        }
    }

    private byte[] planToBytes(IPlanningEnvironment env, V5QuerySet querySet, int pass) {
        byte[] result = null;
        RequestEnvironment reqEnv = (RequestEnvironment)env.getRequestEnvironment();
        PlannedV5QuerySet plannedV5QuerySet = (PlannedV5QuerySet)env.getNodeFactory().createXNode(501133);
        plannedV5QuerySet.setPlanTime(System.currentTimeMillis());
        plannedV5QuerySet.setPlanDuration(env.getPlanTime());
        plannedV5QuerySet.incrementUseCount();
        plannedV5QuerySet.setMasterDetailProvider(reqEnv.getMasterDetailProvider());
        plannedV5QuerySet.setCacheable(!querySet.isNonReusable());
        plannedV5QuerySet.setGovernorsObj(env.getExecutionEnvironment().getGovernors());
        plannedV5QuerySet.setOperation(reqEnv.getOperationName());
        plannedV5QuerySet.setReportName(reqEnv.getReportName());
        plannedV5QuerySet.setRetrieveDatasets(querySet.getRetrieveDatasetArray());
        plannedV5QuerySet.setCachedCollationKey(((ExecutionEnvironment)reqEnv.getExecutionEnvironment()).getLocalCollationSequenceKey());
        if (querySet.isNoDataMode()) {
            plannedV5QuerySet.setNoDataMode();
        }
        for (IXQEQueryNode child : querySet.getChildren()) {
            child.move(plannedV5QuerySet);
        }
        result = this.subtreeToBytes(new IXQEQueryNode[]{plannedV5QuerySet});
        for (IXQEQueryNode child : plannedV5QuerySet.getChildren()) {
            child.move(querySet);
        }
        return result;
    }

    private byte[] planToBytes(IPlanningEnvironment env, PlannedV5QuerySet querySet) {
        byte[] result = null;
        RequestParameters parameters = env.getExecutionEnvironment().getMultiRequestContext().getRequestParameters();
        RequestEnvironment reqEnv = (RequestEnvironment)env.getRequestEnvironment();
        MasterDetailProvider masterDetailProvider = reqEnv.getMasterDetailProvider();
        result = this.subtreeToBytes(new IXQEPersist[]{querySet, parameters, masterDetailProvider});
        return result;
    }

    private byte[] subtreeToBytes(IXQEPersist[] nodes) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        try {
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)stream, UTF_8);
            XQETrace trace = new XQETrace();
            trace.addStream(writer);
            trace.addTraceLevel(-1);
            XQEPersistContext ctx = new XQEPersistContext(trace);
            for (int count = 0; count < nodes.length; ++count) {
                IXQEPersist node = nodes[count];
                if (node == null) continue;
                node.persist(ctx, null);
            }
            ((Writer)writer).flush();
            ((Writer)writer).close();
        }
        catch (IOException ex) {
            XQEDebugLog.err.printStackTrace(ex);
        }
        return stream.toByteArray();
    }

    public void write(IPlanningEnvironment env, Writer writer) {
        XQETrace trace = new XQETrace();
        trace.addStream(writer);
        trace.addTraceLevel(-1);
        trace.beginElement("PersistentPlan");
        trace.writeAttribute("xmlns:i", "http://developer.cognos.com/Types/Integer");
        trace.writeAttribute("xmlns:l", "http://developer.cognos.com/Types/Long");
        trace.writeAttribute("xmlns:b", "http://developer.cognos.com/Types/Boolean");
        trace.writeAttribute("xmlns:s", "http://developer.cognos.com/Types/String");
        trace.writeAttribute("xmlns:d", "http://developer.cognos.com/Types/Double");
        trace.writeAttribute("xmlns:o", "http://developer.cognos.com/Types/Object");
        trace.writeAttribute("xmlns:n", "http://developer.cognos.com/Types/null");
        trace.writeAttribute("xmlns:sub", "http://developer.cognos.com/Types/SubType");
        trace.writeAttribute("xmlns:no", "http://developer.cognos.com/Types/NullOrdering");
        trace.writeAttribute("xmlns:jt", "http://developer.cognos.com/Types/JoinType");
        trace.writeAttribute("xmlns:dt", "http://developer.cognos.com/Types/IDataType");
        trace.writeAttribute("xmlns:fdt", "http://developer.cognos.com/Types/FDSDataTypeEnum");
        trace.writeAttribute("xmlns:cb", "http://developer.cognos.com/Types/ICube");
        trace.writeAttribute("xmlns:md", "http://developer.cognos.com/Types/IMetadata");
        trace.writeAttribute("xmlns:x", "http://developer.cognos.com/Types/IXQEQueryNode");
        trace.writeAttribute("xmlns:p", "http://developer.cognos.com/Types/IXQEPersist");
        trace.writeAttribute("xmlns:r", "http://developer.cognos.com/Types/Reference");
        trace.writeAttribute("xmlns:lcl", "http://developer.cognos.com/Types/Locale");
        trace.writeAttribute("xmlns:ra", "http://developer.cognos.com/Types/V5RollupAggregateEnum");
        trace.beginElement(ELEMENT_CURSORS);
        for (Map.Entry<String, byte[]> entry : this.cursors.entrySet()) {
            trace.beginElement(ELEMENT_CURSOR);
            trace.attribute("name", entry.getKey());
            trace.xml(new String(entry.getValue(), Charset.forName(UTF_8)));
            trace.endElement();
        }
        trace.endElement();
        for (byte[] plan : this.plans) {
            trace.xml(new String(plan, Charset.forName(UTF_8)));
        }
        trace.endElement();
    }

    public byte[] getBytes(IPlanningEnvironment env) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        try {
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)stream, UTF_8);
            this.write(env, writer);
            ((Writer)writer).flush();
            ((Writer)writer).close();
        }
        catch (IOException ex) {
            XQEDebugLog.err.printStackTrace(ex);
        }
        return stream.toByteArray();
    }

    public static PlannedV5QuerySet readPlan(PlanningEnvironment planEnv, RequestEnvironment reqEnv, Document doc) {
        PlannedV5QuerySet p = PersistentQueryPlan.convertDocToPlan(planEnv, reqEnv, doc);
        return p;
    }

    private static PlannedV5QuerySet convertDocToPlan(PlanningEnvironment environment, RequestEnvironment reqEnv, Document doc) {
        PlannedV5QuerySet plannedV5QuerySet = null;
        if (doc == null) {
            return null;
        }
        Element pqs = (Element)doc.selectSingleNode("//PlannedV5QuerySet");
        if (pqs != null) {
            MasterDetailProvider masterDetailProvider;
            RequestParameters reqParams;
            plannedV5QuerySet = new PlannedV5QuerySet();
            plannedV5QuerySet.setPlanningEnvironment(environment);
            XQERestoreContext ctx = new XQERestoreContext(environment);
            plannedV5QuerySet.restore(ctx, pqs);
            XPath xp = doc.createXPath("//p:RequestParameters");
            HashMap<String, String> namespaces = new HashMap<String, String>();
            namespaces.put("p", "http://developer.cognos.com/Types/IXQEPersist");
            xp.setNamespaceURIs(namespaces);
            Element params = (Element)xp.selectSingleNode((Object)doc.getRootElement());
            if (params != null && (reqParams = (RequestParameters)ctx.elementValue(params)) != null) {
                ((ExecutionEnvironment)environment.getExecutionEnvironment()).getMultiRequestContext().setRequestParameters(reqParams);
                for (Parameter value : reqParams.getParameters().values()) {
                    value.bind(environment);
                }
            }
            XPath mdxp = doc.createXPath("//p:MasterDetailProvider");
            mdxp.setNamespaceURIs(namespaces);
            Element md = (Element)mdxp.selectSingleNode((Object)doc.getRootElement());
            if (md != null && (masterDetailProvider = reqEnv.getMasterDetailProvider()) != null) {
                masterDetailProvider.restore(ctx, md);
            }
        }
        return plannedV5QuerySet;
    }

    public void writeToFile(IPlanningEnvironment env, String path) {
        File planFile = new File(path);
        if (!planFile.exists()) {
            planFile.getParentFile().mkdirs();
        } else {
            planFile.delete();
        }
        TraceLogWriter tlw = new TraceLogWriter(planFile);
        this.write(env, tlw);
    }
}

