/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.query.engine;

import com.cognos.xqe.ast.olap.util.MDXLevelInfoCache;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.bibushandler.datasource.ProviderCapabilites;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.data.providers.IDataProvider;
import com.cognos.xqe.data.providers.ProviderManager;
import com.cognos.xqe.metadata.IModelDataSource;
import com.cognos.xqe.metadata.provider.IMetadataConnection;
import com.cognos.xqe.metadata.provider.MetadataConnection;
import com.cognos.xqe.metadata.provider.MetadataService;
import com.cognos.xqe.query.engine.BasePlanningEnvironment;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.IExecutionEnvironment;
import com.cognos.xqe.query.engine.MetadataConnectionContext;
import com.cognos.xqe.runtree.olap.decoration.rulesfactory.OLAPDecorationRulesFactory;
import com.cognos.xqe.runtree.olap.edgemapping.edgeelementfactory.EdgeElementFactory;
import com.cognos.xqe.util.IParameterMaps;
import com.cognos.xqe.util.ParameterAccessCoordinator;
import com.cognos.xqe.util.ParameterMapDyn;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;

public class PlanningEnvironment
extends BasePlanningEnvironment<RequestEnvironment, ExecutionEnvironment, MetadataConnection> {
    private OLAPDecorationRulesFactory ruleFactory;
    private EdgeElementFactory edgeElementFactory;
    private ParameterAccessCoordinator planningPAC = null;
    private MDXLevelInfoCache levelInfoCache = new MDXLevelInfoCache(this);
    private boolean validateExpressions = true;
    private HashMap<String, ParameterAccessCoordinator> planningPACForQuery = null;
    private LinkedList<MetadataConnection> metadataConnStack = new LinkedList();
    private MetadataConnectionContext defaultMetadataConnectionContext;
    private HashMap<String, MetadataConnection> metadataConnectionsForQuery = null;
    private boolean readV5SpecFormat = true;

    public ParameterAccessCoordinator getPlanningPAC() {
        if (this.planningPACForQuery == null) {
            return this.getPlanningPACModelPath();
        }
        if (this.metadataConnStack.isEmpty()) {
            return this.getPlanningPACModelPath();
        }
        String metadataPath = this.metadataConnStack.getLast().getModelName();
        return this.getPlanningPACMetadataPath(metadataPath);
    }

    protected ParameterAccessCoordinator getPlanningPACModelPath() {
        if (this.planningPAC == null) {
            MetadataConnection mc = (MetadataConnection)super.getMetadataConnection();
            if (mc == null && super.getModelPath() != null) {
                boolean forceMetadataRefresh = false;
                boolean reuseCachedConnection = true;
                boolean forceCMTrusted = false;
                boolean metadataRequest = ((RequestEnvironment)this.getRequestEnvironment()).isMetadataRequest();
                boolean[] connectionOptions = MetadataService.getConnectionOptions(forceCMTrusted, forceMetadataRefresh, metadataRequest);
                mc = MetadataService.getInstance().getConnection(MetadataService.getProviderTypeFromModelPath(((RequestEnvironment)this.getRequestEnvironment()).getModelType(), super.getModelPath()), super.getModelPath(), (IExecutionEnvironment)this.getExecutionEnvironment(), reuseCachedConnection, connectionOptions);
            }
            this.planningPAC = this.createPAC(mc);
        }
        return this.planningPAC;
    }

    public ParameterAccessCoordinator getPlanningPACMetadataPath(String metadataPath) {
        if (this.useMetadataConnectionFromQuerySet(metadataPath)) {
            return this.getPlanningPACModelPath();
        }
        ParameterAccessCoordinator pac = this.planningPACForQuery.get(metadataPath);
        if (pac == null) {
            if (super.getModelPath().equals(metadataPath)) {
                pac = this.getPlanningPACModelPath();
            } else {
                MetadataConnection mc = this.getMetadataConnectionMetadataPath(metadataPath);
                pac = this.createPAC(mc);
            }
            this.planningPACForQuery.put(metadataPath, pac);
        }
        return pac;
    }

    protected ParameterAccessCoordinator createPAC(MetadataConnection mc) {
        ParameterAccessCoordinator pac = new ParameterAccessCoordinator();
        IParameterMaps modelPM = null;
        IParameterMaps modelQI = null;
        try {
            if (mc != null) {
                modelPM = mc.getParameterMapsModel();
                modelQI = mc.getQIParameterMapsModel();
            }
        }
        catch (UnsupportedOperationException e) {
            modelPM = null;
            modelQI = null;
        }
        if (modelPM != null) {
            pac.addParameterMap(modelPM);
        }
        if (modelQI != null) {
            pac.addParameterMap(modelQI);
        }
        ParameterAccessCoordinator dynPAC = new ParameterAccessCoordinator();
        ParameterMapDyn dynMAP = new ParameterMapDyn(IParameterMaps.EPRIORITY.APPL_ADMIN_DEFAULT.getKey());
        dynPAC.addParameterMap(dynMAP);
        pac.addParameterAccessCoordinator(dynPAC);
        return pac;
    }

    public OLAPDecorationRulesFactory getRuleFactory() {
        return this.ruleFactory;
    }

    public void setRuleFactory(OLAPDecorationRulesFactory aRuleFactory) {
        this.ruleFactory = aRuleFactory;
    }

    public EdgeElementFactory getEdgeElementFactory() {
        return this.edgeElementFactory;
    }

    public void setEdgeElementFactory(EdgeElementFactory anEdgeElementFactory) {
        this.edgeElementFactory = anEdgeElementFactory;
    }

    public MDXLevelInfoCache getLevelInfoCache() {
        return this.levelInfoCache;
    }

    public IDataSourceCapabilities getCapabilities(String dsType) {
        MetadataConnection mdConnection = this.getMetadataConnection();
        if (mdConnection != null) {
            List<IModelDataSource> modelDataSources = mdConnection.getModelDataSources();
            ExecutionEnvironment execEnv = (ExecutionEnvironment)this.getExecutionEnvironment();
            for (IModelDataSource modelDS : modelDataSources) {
                if (!modelDS.isMultidimensional() || dsType != null && !modelDS.getInterface().equals(dsType)) continue;
                IDataSource ds = execEnv.getOrAddDataSource(modelDS);
                IDataSourceCapabilities capabilities = ProviderCapabilites.getInstance().getOrAddDatasourceCapabilities(ds);
                if (capabilities == null) {
                    Locale locale = modelDS.getConnection().getContentLocale();
                    RequestEnvironment requestEnv = (RequestEnvironment)this.getRequestEnvironment();
                    ExecutionEnvironment executionEnv = (ExecutionEnvironment)requestEnv.getExecutionEnvironment();
                    IDataProvider provider = ProviderManager.getInstance().getProvider(ds.getType());
                    provider.resolveDataSourceCapabilities(executionEnv, ds, locale);
                    capabilities = ds.getCapabilities();
                }
                return capabilities;
            }
        }
        return null;
    }

    @Override
    public void setPlanningInactive() {
        super.setPlanningInactive();
        this.setRoot(null);
        this.edgeElementFactory = null;
        this.ruleFactory = null;
    }

    public void clearLevelInfoCache() {
        this.levelInfoCache.clearNestedCalcNodes();
    }

    public void setValidateExpressions(boolean value) {
        this.validateExpressions = value;
    }

    public boolean validateExpressions() {
        return this.validateExpressions;
    }

    public MetadataConnection getMetadataConnectionMetadataPath(String metadataPath) {
        if (this.useMetadataConnectionFromQuerySet(metadataPath)) {
            return (MetadataConnection)super.getMetadataConnection();
        }
        return this.metadataConnectionsForQuery.get(metadataPath);
    }

    public void addMetadataConnectionMetadataPath(String metadataPath, MetadataConnection mc) {
        MetadataConnection exist;
        if (this.metadataConnectionsForQuery != null && (exist = this.metadataConnectionsForQuery.get(metadataPath)) == null) {
            this.metadataConnectionsForQuery.put(metadataPath, mc);
        }
    }

    public void enableMultiModelForQuery() {
        if (this.metadataConnectionsForQuery == null) {
            this.metadataConnectionsForQuery = new HashMap();
        }
        if (this.planningPACForQuery == null) {
            this.planningPACForQuery = new HashMap();
        }
    }

    public boolean isMultiModelForQueryEnabled() {
        return this.metadataConnectionsForQuery != null && this.planningPACForQuery != null;
    }

    public boolean isMultimodelCase() {
        if (this.isMultiModelForQueryEnabled()) {
            return true;
        }
        return this.getRoot() != null && this.getRoot().getType() == 101002 && ((V5QuerySet)this.getRoot()).getPropertyValue("orgModelPath") != null;
    }

    @Override
    public String getModelPath() {
        if (!this.isMultiModelForQueryEnabled()) {
            return super.getModelPath();
        }
        return this.getMetadataConnection().getModelName();
    }

    @Override
    public MetadataConnection getMetadataConnection() {
        if (this.metadataConnectionsForQuery == null) {
            return (MetadataConnection)super.getMetadataConnection();
        }
        if (this.metadataConnStack.isEmpty()) {
            return (MetadataConnection)super.getMetadataConnection();
        }
        return this.metadataConnStack.getLast();
    }

    @Override
    public void setMetdataConnection(IMetadataConnection mc) {
        if (mc == null) {
            super.setMetdataConnection(mc);
            if (this.defaultMetadataConnectionContext != null) {
                this.defaultMetadataConnectionContext.setMetadataConnection(null);
            }
            this.planningPAC = null;
            return;
        }
        MetadataConnection conn = (MetadataConnection)mc;
        String metadataPath = conn.getModelName();
        if (this.useMetadataConnectionFromQuerySet(metadataPath)) {
            if (this.getMetadataConnection() != mc) {
                super.setMetdataConnection(mc);
                this.planningPAC = null;
            }
            if (this.defaultMetadataConnectionContext != null) {
                this.defaultMetadataConnectionContext.setMetadataConnection(conn);
            }
        } else {
            this.addMetadataConnectionMetadataPath(metadataPath, conn);
        }
    }

    public void popMetadataConnectionContext() {
        this.metadataConnStack.removeLast();
    }

    public MetadataConnectionContext pushMetadataConnectionContext(V5Query v5Query) {
        if (this.isMultiModelForQueryEnabled() && v5Query != null) {
            return this.pushMetadataConnectionContext(v5Query.getMetadataPath());
        }
        return null;
    }

    public MetadataConnectionContext pushMetadataConnectionContext(String metadataPath) {
        if (this.metadataConnectionsForQuery == null) {
            if (this.defaultMetadataConnectionContext == null) {
                this.defaultMetadataConnectionContext = new MetadataConnectionContext(this, (MetadataConnection)super.getMetadataConnection(), false);
            }
            return this.defaultMetadataConnectionContext;
        }
        MetadataConnection mc = null;
        if (this.useMetadataConnectionFromQuerySet(metadataPath)) {
            mc = (MetadataConnection)super.getMetadataConnection();
            if (this.defaultMetadataConnectionContext == null) {
                this.defaultMetadataConnectionContext = new MetadataConnectionContext(this, mc, false);
            }
        } else {
            mc = this.getMetadataConnectionMetadataPath(metadataPath);
        }
        this.metadataConnStack.addLast(mc);
        return new MetadataConnectionContext(this, mc, true);
    }

    protected boolean useMetadataConnectionFromQuerySet(String metadataPath) {
        return this.metadataConnectionsForQuery == null || this.planningPACForQuery == null || metadataPath == null || metadataPath.equals(super.getModelPath());
    }

    public void enableReadV5SpecFormat() {
        this.readV5SpecFormat = true;
    }

    public void disableReadV5SpecFormat() {
        this.readV5SpecFormat = false;
    }

    public boolean isReadV5SpecFormat() {
        return this.readV5SpecFormat;
    }
}

