/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.query.engine;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.bibushandler.BaseRequestEnvironment;
import com.cognos.xqe.bibushandler.IRequestEnvironment;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.IExecutionEnvironment;
import com.cognos.xqe.query.engine.MultiRequestContext;
import com.cognos.xqe.rsapi.RSAPIDataset;
import com.cognos.xqe.runtree.XNode;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.TraceLogManager;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.trace.XQETrace;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.List;
import org.dom4j.Element;

public final class QueryEngineLoggingUtils {
    private static final String UTF_8 = "UTF-8";
    public static final String DQA_XQE_LOGGING_PREFERENCE = "DQA.xqeLoggingPreference";
    public static final String XML_ELEMENT_EXECUTION_TRACE_ATTRIBUTE_ENABLED = "queryExecution[@traceEnabled]";
    public static final String XML_ELEMENT_PLANNING_TRACE_ATTRIBUTE_ENABLED = "queryPlanning[@traceEnabled]";
    public static final String XML_ELEMENT_PLANNING_TRACE_WHY_TRANSFORMATION_APPLIED = "queryPlanning.traceLevels.whyTransformationApplied[@enabled]";
    private static final String XML_TREE_AFTER_TRANSFORMATION = "queryPlanning.dumpTreeAfterTransformation[@enabled]";
    public static final String XML_ELEMENT_ITERATOR_PROFILING_ENABLED = "queryExecution.iteratorProfiling[@enabled]";
    public static final String XML_ELEMENT_LOG_LEVEL = "diagnostics[@level]";
    public static final Boolean RUNTREE_EXECUTION_ENABLED_DEFAULT = false;
    public static final Boolean RUNTREE_ENABLED_DEFAULT = true;
    public static final String RUNTREE_EXECUTION_ENABLED = "queryExecution.traceLevels.runTreeExecution[@enabled]";
    public static final String RUNTREE_ENABLED = "queryExecution.traceLevels.runTree[@enabled]";
    public static final int TRACE_ENABLED_NOT_SET = -1;
    public static final int NO_TRACING = 0;
    public static final int EXECUTION_TRACE_ENABLED = 1;
    public static final int PLANNING_TRACE_ENABLED = 2;
    public static final int XQE_TRACE_LOG_ENABLED = 4;
    public static final int XQE_INFO_LOG_ENABLED = 8;
    public static final int XQE_WARN_LOG_ENABLED = 16;
    public static final int XQE_ERROR_LOG_ENABLED = 32;
    public static final int ALL_TRACE_ENABLED = 63;
    private static final int THREE = 3;
    private static final String USER_PREFERENCE_VARS = "userPreferenceVars";
    private static final String USER_PREF_ITEM = "item";
    private static final String EXECUTION_ELEMENT = "execution";
    private static final String RUNTREE_ELEMENT = "runtree";
    private static final String RESULTS_ELEMENT = "results";
    private static final XQELogger ERROR_LOGGER = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Exception", LogLevel.ERROR);

    public static boolean isTracingEnabled(IRequestEnvironment reqEnv) {
        return QueryEngineLoggingUtils.isTracingEnabled(XML_ELEMENT_PLANNING_TRACE_ATTRIBUTE_ENABLED, reqEnv) || QueryEngineLoggingUtils.isTracingEnabled(XML_ELEMENT_EXECUTION_TRACE_ATTRIBUTE_ENABLED, reqEnv) || QueryEngineLoggingUtils.isTracingEnabled(XML_ELEMENT_LOG_LEVEL, reqEnv) || QueryEngineLoggingUtils.isJDBCTraceEnabled();
    }

    public static boolean isPlanningTraceEnabled(IRequestEnvironment reqEnv) {
        return QueryEngineLoggingUtils.isTracingEnabled(XML_ELEMENT_PLANNING_TRACE_ATTRIBUTE_ENABLED, reqEnv);
    }

    public static boolean overrideXqeLoggingLevel(IRequestEnvironment reqEnv) {
        return QueryEngineLoggingUtils.isTracingEnabled(XML_ELEMENT_LOG_LEVEL, reqEnv);
    }

    public static boolean isLogV5SubquerySpecificationGenerationTraceEnabled(MultiRequestContext multiRequestContext) {
        return multiRequestContext.fetchBooleanConfiguration("queryPlanning.logV5SubquerySpecification[@enabled]", false);
    }

    public static boolean isExecutionTraceEnabled(IRequestEnvironment reqEnv) {
        return QueryEngineLoggingUtils.isTracingEnabled(XML_ELEMENT_EXECUTION_TRACE_ATTRIBUTE_ENABLED, reqEnv);
    }

    public static boolean isJDBCTraceEnabled() {
        return XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "JDBCAPITrace", LogLevel.INFO).isOn();
    }

    private static boolean isTracingEnabled(String traceProperty, IRequestEnvironment reqEnv) {
        if (reqEnv == null) {
            return false;
        }
        int traceValue = reqEnv.getExecutionEnvironment().getMultiRequestContext().getTraceEnabled();
        LogLevel logLevelId = reqEnv.getExecutionEnvironment().getMultiRequestContext().getDQALoggingLevel();
        if (traceValue == -1) {
            MultiRequestContext multiRequestContext = reqEnv.getExecutionEnvironment().getMultiRequestContext();
            int serverSetting = 0;
            if (multiRequestContext.fetchBooleanConfiguration(XML_ELEMENT_EXECUTION_TRACE_ATTRIBUTE_ENABLED, false)) {
                serverSetting |= 1;
            }
            if (multiRequestContext.fetchBooleanConfiguration(XML_ELEMENT_PLANNING_TRACE_ATTRIBUTE_ENABLED, false)) {
                serverSetting |= 2;
            }
            int dqaLoggingPreference = 0;
            if (serverSetting < 63 && reqEnv instanceof BaseRequestEnvironment) {
                dqaLoggingPreference = ((BaseRequestEnvironment)reqEnv).getDQALoggingPreference();
            }
            traceValue = serverSetting | dqaLoggingPreference;
            reqEnv.getExecutionEnvironment().getMultiRequestContext().setTraceEnabled(traceValue & 3);
            logLevelId = traceValue < 4 ? LogLevel.NONE : LogLevel.valueOf(traceValue >> 3);
            reqEnv.getExecutionEnvironment().getMultiRequestContext().setDQALoggingLevel(logLevelId);
        }
        if (traceProperty.equals(XML_ELEMENT_EXECUTION_TRACE_ATTRIBUTE_ENABLED)) {
            return QueryEngineLoggingUtils.isPropertyOn(traceValue & 1);
        }
        if (traceProperty.equals(XML_ELEMENT_PLANNING_TRACE_ATTRIBUTE_ENABLED)) {
            return QueryEngineLoggingUtils.isPropertyOn(traceValue & 2);
        }
        if (traceProperty.equals(XML_ELEMENT_LOG_LEVEL)) {
            return logLevelId != LogLevel.NONE;
        }
        return false;
    }

    private static boolean isPropertyOn(int prefProperty) {
        return prefProperty != 0;
    }

    public static void setPlanningTraceEnabled(boolean enabled) {
        QueryEngineLoggingUtils.setTraceEnabled(XML_ELEMENT_PLANNING_TRACE_ATTRIBUTE_ENABLED);
    }

    public static void setExecutionTraceEnabled(boolean enabled) {
        QueryEngineLoggingUtils.setTraceEnabled(XML_ELEMENT_EXECUTION_TRACE_ATTRIBUTE_ENABLED);
    }

    private static void setTraceEnabled(String traceProperty) {
        XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE).setProperty(traceProperty, "true");
    }

    public static boolean isRuntreeLoggingEnabled(XQETrace trace) {
        return trace != null && (trace.getTraceLevel() & 0x80) != 0;
    }

    public static boolean isRuntreeExecutionLoggingEnabled(XQETrace trace) {
        return trace != null && (trace.getTraceLevel() & 0x800) != 0;
    }

    public static boolean isRuntreeEnabled(RequestEnvironment reqEnv) {
        return QueryEngineLoggingUtils.isExecutionTraceEnabled(reqEnv);
    }

    public static boolean isExecutionLoggingEnabled(XQETrace trace) {
        return trace != null && (trace.getTraceLevel() & 0x200) != 0;
    }

    public static boolean isExecutionLoggingEnabled(IRequestEnvironment reqEnv) {
        if (!QueryEngineLoggingUtils.isExecutionTraceEnabled(reqEnv)) {
            return false;
        }
        XQEConfiguration config = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        return config.getBooleanProperty(RUNTREE_EXECUTION_ENABLED, RUNTREE_EXECUTION_ENABLED_DEFAULT);
    }

    public static boolean isProfilingEnabled(IRequestEnvironment reqEnvironment) {
        XQEConfiguration configuration = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        if (!QueryEngineLoggingUtils.isExecutionTraceEnabled(reqEnvironment)) {
            return false;
        }
        return configuration.getBooleanProperty(XML_ELEMENT_ITERATOR_PROFILING_ENABLED, true);
    }

    public static boolean isProfilingEnabled(XQETrace trace) {
        return trace != null && QueryEngineLoggingUtils.isExecutionLoggingEnabled(trace) && (trace.getTraceLevel() & 0x400) != 0;
    }

    public static void addTraceLevels(XQETrace trace, IRequestEnvironment reqEnv) {
        if (trace == null) {
            return;
        }
        XQEConfiguration configuration = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        if (!QueryEngineLoggingUtils.isPlanningTraceEnabled(reqEnv)) {
            trace.resetTraceLevels();
            return;
        }
        trace.addTraceLevel(1);
        if (configuration.getBooleanProperty(XML_ELEMENT_PLANNING_TRACE_WHY_TRANSFORMATION_APPLIED, false)) {
            trace.addTraceLevel(2);
        }
        if (configuration.getBooleanProperty("queryPlanning.traceLevels.whyTransformationNotApplied[@enabled]", false)) {
            trace.addTraceLevel(4);
        }
        if (configuration.getBooleanProperty("queryPlanning.traceLevels.complexNodeProperties[@enabled]", false)) {
            trace.addTraceLevel(64);
        }
        if (configuration.getBooleanProperty(XML_TREE_AFTER_TRANSFORMATION, true)) {
            trace.addTraceLevel(8);
        }
    }

    public static void addExecutionTraceLevels(XQETrace trace, IRequestEnvironment reqEnv) {
        XQEConfiguration configuration = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        if (!QueryEngineLoggingUtils.isExecutionTraceEnabled(reqEnv)) {
            return;
        }
        trace.addTraceLevel(512);
        if (configuration.getBooleanProperty(XML_ELEMENT_ITERATOR_PROFILING_ENABLED, true)) {
            trace.addTraceLevel(1024);
        }
        if (configuration.getBooleanProperty(RUNTREE_ENABLED, RUNTREE_ENABLED_DEFAULT).booleanValue()) {
            trace.addTraceLevel(128);
        }
        if (configuration.getBooleanProperty(RUNTREE_EXECUTION_ENABLED, RUNTREE_EXECUTION_ENABLED_DEFAULT).booleanValue()) {
            trace.addTraceLevel(2048);
        }
    }

    public static void dumpRuntreeLog(IExecutionEnvironment environment, XNode xNode) {
        block3: {
            XQETrace trace = environment.getTrace();
            if (!QueryEngineLoggingUtils.isRuntreeLoggingEnabled(trace)) {
                return;
            }
            Object reqEnv = environment.getRequestEnvironment();
            Writer logWriter = TraceLogManager.getInstance().createRuntreeTraceWriter((IRequestEnvironment)reqEnv);
            reqEnv.setCurrentTraceWriter(logWriter);
            trace.addStream(logWriter);
            xNode.dump(trace);
            try {
                trace.removeStream(logWriter);
                reqEnv.setCurrentTraceWriter(null);
                logWriter.close();
            }
            catch (IOException e) {
                ERROR_LOGGER.log(e);
                logWriter = null;
                if (QueryEngineLoggingUtils.isProfilingEnabled(reqEnv) || QueryEngineLoggingUtils.isExecutionLoggingEnabled(reqEnv)) break block3;
                TraceLogManager.getInstance().closeTrace((IRequestEnvironment)reqEnv);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dumpExecutionLog(ExecutionEnvironment environment, XNode xNode, IValue result) {
        Writer logWriter = null;
        XQETrace trace = environment.getTrace();
        if ((trace.getTraceLevel() & 0x800) == 0) {
            return;
        }
        RequestEnvironment reqEnv = (RequestEnvironment)environment.getRequestEnvironment();
        try {
            logWriter = TraceLogManager.getInstance().createExecutionTraceWriter(reqEnv);
            reqEnv.setCurrentTraceWriter(logWriter);
            trace.addStream(logWriter);
            trace.beginElement(EXECUTION_ELEMENT, -1);
            trace.beginElement(RUNTREE_ELEMENT, -1);
            xNode.dump(trace);
            trace.endElement();
            trace.beginElement(RESULTS_ELEMENT, -1);
            result.toXML(trace);
            trace.endElement();
            trace.endElement();
        }
        finally {
            if (logWriter != null) {
                try {
                    trace.removeStream(logWriter);
                    reqEnv.setCurrentTraceWriter(null);
                    logWriter.close();
                }
                catch (IOException ioe) {
                    logWriter = null;
                }
            }
            if (!QueryEngineLoggingUtils.isProfilingEnabled(reqEnv)) {
                TraceLogManager.getInstance().closeTrace(reqEnv);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dumpProfilingLog(IExecutionEnvironment environment, IXQEQueryNode xNode) {
        XQETrace trace = environment.getTrace();
        if (!QueryEngineLoggingUtils.isProfilingEnabled(trace)) {
            return;
        }
        Object reqEnv = environment.getRequestEnvironment();
        OutputStream fos = TraceLogManager.getInstance().createProfilingTraceOutputStream((IRequestEnvironment)reqEnv);
        BufferedWriter logWriter = null;
        if (fos != null) {
            block13: {
                try {
                    try {
                        logWriter = new BufferedWriter(new OutputStreamWriter(fos, UTF_8));
                        reqEnv.setCurrentTraceWriter(logWriter);
                        trace.addStream(logWriter);
                    }
                    catch (UnsupportedEncodingException uee) {
                        throw new XQERuntimeException(XQEMessageKeys.GEN_UnexpectedException, (Throwable)uee);
                    }
                    xNode.dump(trace);
                    if (logWriter == null) break block13;
                }
                catch (Throwable throwable) {
                    if (logWriter != null) {
                        try {
                            trace.removeStream(logWriter);
                            reqEnv.setCurrentTraceWriter(null);
                            ((Writer)logWriter).close();
                        }
                        catch (IOException ioe) {
                            logWriter = null;
                        }
                    }
                    if (xNode instanceof RSAPIDataset) {
                        Boolean dmrFlag = ((RSAPIDataset)xNode).forDMRReport();
                        TraceLogManager.getInstance().setManifestProperty((IRequestEnvironment)reqEnv, "isDMR", String.valueOf(dmrFlag));
                    }
                    TraceLogManager.getInstance().closeTrace((IRequestEnvironment)reqEnv);
                    throw throwable;
                }
                try {
                    trace.removeStream(logWriter);
                    reqEnv.setCurrentTraceWriter(null);
                    ((Writer)logWriter).close();
                }
                catch (IOException ioe) {
                    logWriter = null;
                }
            }
            if (xNode instanceof RSAPIDataset) {
                Boolean dmrFlag = ((RSAPIDataset)xNode).forDMRReport();
                TraceLogManager.getInstance().setManifestProperty((IRequestEnvironment)reqEnv, "isDMR", String.valueOf(dmrFlag));
            }
            TraceLogManager.getInstance().closeTrace((IRequestEnvironment)reqEnv);
        }
    }

    public static String getDQALoggingPreference(Element bibusHeader) {
        Element userPreferences = bibusHeader.element(USER_PREFERENCE_VARS);
        if (userPreferences == null) {
            return null;
        }
        List userPreferenceItems = userPreferences.elements(USER_PREF_ITEM);
        for (Element userPref : userPreferenceItems) {
            Element userPrefElement = userPref;
            List childrenElements = userPrefElement.elements();
            Element prefName = (Element)childrenElements.get(0);
            if (!prefName.getText().equals(DQA_XQE_LOGGING_PREFERENCE)) continue;
            Element prefValue = (Element)childrenElements.get(1);
            return prefValue.getText();
        }
        return null;
    }
}

