/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.query.engine;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.exception.IMessageKey;
import com.cognos.xqe.exception.XQEMessage;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.util.xml.XMLWriter;
import com.ibm.json.java.OrderedJSONObject;
import java.io.StringWriter;
import java.util.List;
import java.util.Locale;

public class ResponseMessage
implements Comparable<ResponseMessage> {
    public static final String QUERY_FEEDBACK = "queryFeedback";
    public static final String FOR_MISSING_MEMBERS = "forMissingMembers";
    public static final String SEVERITY_LEVEL = "severityLevel";
    private static final String MESSAGE_TAG = "message";
    private static final String SEVERITY_ATTRIBUTE = "severity";
    private static final String TYPE_ATTRIBUTE = "type";
    private static final String TITLE_ATTRIBUTE = "title";
    private static final String TEXT_ATTRIBUTE = "text";
    private static final String LOCATION_ATTRIBUTE = "location";
    private static final String REPORT_QUERY_ATTRIBUTE = "reportQuery";
    private static final String QUERY_LANGUAGE_ATTRIBUTE = "queryLanguage";
    public static final String SEVERITY_ERROR_STR = "error";
    public static final String SEVERITY_WARNING_STR = "warning";
    public static final String SEVERITY_KEY_TRANF_STR = "keyTransformation";
    public static final String SEVERITY_INFO_STR = "information";
    public static final int SEVERITY_UNKNOWN_INT = -1;
    public static final int SEVERITY_MIN_INT = 0;
    public static final int SEVERITY_ERROR_INT = 0;
    public static final int SEVERITY_WARNING_INT = 1;
    public static final int SEVERITY_KEY_TRANSF_INT = 2;
    public static final int SEVERITY_INFO_INT = 3;
    public static final int SEVERITY_MAX_INT = 9;
    private static final String TYPE_PLAN_STAT_STR = "planningStats";
    private static final String TYPE_EXEC_STAT_STR = "executionStats";
    private static final String XQE_MESSAGE_TITLE_STR = "XQE Message";
    public static final String MDX_NODE_TYPE_STR = "MDX";
    public static final String SQL_NODE_TYPE_STR = "SQL";
    public static final String RQP_NODE_TYPE_STR = "cognosSQL";
    public static final String DMR_NODE_TYPE_STR = "DMR";
    public static final String XTAB_REL_NODE_TYPE_STR = "XTabRel";
    private static final String EXCEPTION_TYPE_STR = "Exception";
    private final int severity;
    private final ResponseMessageType type;
    private final XQEMessage mMessage;
    private final Boolean mUseOldFormat;
    private String location = null;
    private String infoMsg = null;
    private String reportQuery = null;
    private String queryLanguage = null;

    private static int validateSeverity(int aSeverity) {
        if (aSeverity < 0 || aSeverity > 9) {
            aSeverity = 0;
        }
        return aSeverity;
    }

    public ResponseMessage(int aSeverity, ResponseMessageType aType, XQEMessage message) {
        this.severity = ResponseMessage.validateSeverity(aSeverity);
        this.type = aType;
        this.mMessage = message;
        this.mUseOldFormat = false;
        message.getMessageKey();
    }

    public ResponseMessage(ResponseMessageType aType, String msg) {
        this(3, aType, msg);
    }

    public ResponseMessage(int aSeverity, ResponseMessageType aType, String msg) {
        this.severity = ResponseMessage.validateSeverity(aSeverity);
        this.type = aType;
        this.mMessage = null;
        this.infoMsg = msg;
        this.mUseOldFormat = true;
    }

    public ResponseMessage(int aSeverity, ResponseMessageType aType, XQERuntimeException ex) {
        this(aSeverity, aType, ex.getXQEMessage());
    }

    public ResponseMessage(int aSeverity, ResponseMessageType aType, IMessageKey.Param0 messageKey) {
        this.severity = ResponseMessage.validateSeverity(aSeverity);
        this.type = aType;
        this.mMessage = new XQEMessage(messageKey, (List<IXQEQueryNode>)null);
        this.mUseOldFormat = true;
    }

    public ResponseMessage(int aSeverity, ResponseMessageType aType, IMessageKey.Param1 messageKey, String par1) {
        this.severity = ResponseMessage.validateSeverity(aSeverity);
        this.type = aType;
        this.mMessage = new XQEMessage(messageKey, par1, (List<IXQEQueryNode>)null);
        this.mUseOldFormat = true;
    }

    public ResponseMessage(int aSeverity, ResponseMessageType aType, IMessageKey.Param2 messageKey, String par1, String par2) {
        this.severity = ResponseMessage.validateSeverity(aSeverity);
        this.type = aType;
        this.mMessage = new XQEMessage(messageKey, par1, par2, (List<IXQEQueryNode>)null);
        this.mUseOldFormat = true;
    }

    public ResponseMessage(int aSeverity, ResponseMessageType aType, IMessageKey.Param3 messageKey, String par1, String par2, String par3) {
        this.severity = ResponseMessage.validateSeverity(aSeverity);
        this.type = aType;
        this.mMessage = new XQEMessage(messageKey, par1, par2, par3, (List<IXQEQueryNode>)null);
        this.mUseOldFormat = true;
    }

    public ResponseMessage(int aSeverity, ResponseMessageType aType, IMessageKey.Param4 messageKey, String par1, String par2, String par3, String par4) {
        this.severity = ResponseMessage.validateSeverity(aSeverity);
        this.type = aType;
        this.mMessage = new XQEMessage(messageKey, par1, par2, par3, par4, (List<IXQEQueryNode>)null);
        this.mUseOldFormat = true;
    }

    public ResponseMessage(int aSeverity, ResponseMessageType aType, IMessageKey.Param5 messageKey, String par1, String par2, String par3, String par4, String par5) {
        this.severity = ResponseMessage.validateSeverity(aSeverity);
        this.type = aType;
        this.mMessage = new XQEMessage(messageKey, par1, par2, par3, par4, par5, (List<IXQEQueryNode>)null);
        this.mUseOldFormat = true;
    }

    public final int getSeverity() {
        return this.severity;
    }

    public final String getLocation() {
        if (this.location != null) {
            return this.location;
        }
        return null;
    }

    public final XQEMessage getMessage() {
        return this.mMessage;
    }

    public final IMessageKey getMessageKey() {
        if (this.mMessage == null) {
            return null;
        }
        return this.mMessage.getMessageKey();
    }

    public final String[] getParameters() {
        if (this.mMessage == null) {
            return null;
        }
        return this.mMessage.getParams();
    }

    public final ResponseMessageType getType() {
        return this.type;
    }

    public Boolean usesOldFormat() {
        return this.mUseOldFormat;
    }

    private void writeOptionalAttribute(XMLWriter writer, String name, Object value) {
        if (value != null) {
            writer.attribute(name, value);
        }
    }

    public void toXMLString(XMLWriter writer, Locale aLocale) {
        writer.beginElement(MESSAGE_TAG, -1);
        writer.attribute(SEVERITY_ATTRIBUTE, ResponseMessage.severityLevelToString(this.severity));
        writer.attribute(TYPE_ATTRIBUTE, ResponseMessage.typeToString(this.type));
        if (this.severity >= 2) {
            if (this.queryLanguage != null) {
                writer.attribute(QUERY_LANGUAGE_ATTRIBUTE, this.queryLanguage);
            }
            if (this.reportQuery != null) {
                writer.attribute(REPORT_QUERY_ATTRIBUTE, this.reportQuery);
            }
            writer.attribute(TITLE_ATTRIBUTE, XQE_MESSAGE_TITLE_STR);
            writer.data(this.infoMsg);
        } else if (this.type == ResponseMessageType.MIGRATE_TYPE_INT) {
            writer.attribute(TITLE_ATTRIBUTE, XQE_MESSAGE_TITLE_STR);
            writer.data(this.infoMsg);
            this.writeOptionalAttribute(writer, LOCATION_ATTRIBUTE, this.getLocation());
        } else if (this.usesOldFormat().booleanValue()) {
            String message = this.getLocalizedMessage(aLocale);
            writer.attribute(TITLE_ATTRIBUTE, message);
            writer.attribute(TEXT_ATTRIBUTE, message);
            this.writeOptionalAttribute(writer, LOCATION_ATTRIBUTE, this.getLocation());
        } else {
            XQEMessage message = this.getMessage();
            writer.attribute(TITLE_ATTRIBUTE, message.getTitle(aLocale));
            this.writeOptionalAttribute(writer, LOCATION_ATTRIBUTE, this.getLocation());
            writer.data(message.getBody(aLocale));
        }
        writer.endElement();
    }

    public Object toJSON(Locale aLocale) {
        OrderedJSONObject obj = new OrderedJSONObject();
        obj.put((Object)SEVERITY_ATTRIBUTE, (Object)ResponseMessage.severityLevelToString(this.severity));
        obj.put((Object)TYPE_ATTRIBUTE, (Object)ResponseMessage.typeToString(this.type));
        if (2 <= this.severity) {
            if (null != this.queryLanguage) {
                obj.put((Object)QUERY_LANGUAGE_ATTRIBUTE, (Object)this.queryLanguage);
            }
            if (null != this.reportQuery) {
                obj.put((Object)REPORT_QUERY_ATTRIBUTE, (Object)this.reportQuery);
            }
            obj.put((Object)TITLE_ATTRIBUTE, (Object)XQE_MESSAGE_TITLE_STR);
            obj.put((Object)MESSAGE_TAG, (Object)this.infoMsg);
        } else if (ResponseMessageType.MIGRATE_TYPE_INT == this.type) {
            obj.put((Object)TITLE_ATTRIBUTE, (Object)XQE_MESSAGE_TITLE_STR);
            obj.put((Object)MESSAGE_TAG, (Object)this.infoMsg);
            if (null != this.getLocation()) {
                obj.put((Object)LOCATION_ATTRIBUTE, (Object)this.getLocation());
            }
        } else if (this.usesOldFormat().booleanValue()) {
            String message = this.getLocalizedMessage(aLocale);
            obj.put((Object)TITLE_ATTRIBUTE, (Object)message);
            obj.put((Object)MESSAGE_TAG, (Object)message);
            if (null != this.getLocation()) {
                obj.put((Object)LOCATION_ATTRIBUTE, (Object)this.getLocation());
            }
        } else {
            XQEMessage message = this.getMessage();
            obj.put((Object)TITLE_ATTRIBUTE, (Object)message.getTitle(aLocale));
            obj.put((Object)MESSAGE_TAG, (Object)message.getBody(aLocale));
            if (null != this.getLocation()) {
                obj.put((Object)LOCATION_ATTRIBUTE, (Object)this.getLocation());
            }
        }
        return obj;
    }

    public String toString() {
        StringWriter sw = new StringWriter();
        XMLWriter writer = new XMLWriter();
        writer.addStream(sw);
        this.toXMLString(writer, null);
        writer.flush();
        return sw.toString();
    }

    public String getLocalizedMessage(Locale locale) {
        if (this.severity >= 2) {
            return this.infoMsg;
        }
        if (this.type == ResponseMessageType.MIGRATE_TYPE_INT) {
            return this.infoMsg;
        }
        return this.mMessage.getBody(locale);
    }

    public static final int severityLevelToInt(String severityLevel) {
        int iSeverityLevel = 0;
        if (severityLevel.equals(SEVERITY_ERROR_STR)) {
            iSeverityLevel = 0;
        } else if (severityLevel.equals(SEVERITY_WARNING_STR)) {
            iSeverityLevel = 1;
        } else if (severityLevel.equals(SEVERITY_KEY_TRANF_STR)) {
            iSeverityLevel = 2;
        } else if (severityLevel.equals(SEVERITY_INFO_STR)) {
            iSeverityLevel = 3;
        }
        return iSeverityLevel;
    }

    public static final String severityLevelToString(int iSeverityLevel) {
        String severityLevel = SEVERITY_ERROR_STR;
        if (iSeverityLevel == 0) {
            severityLevel = SEVERITY_ERROR_STR;
        } else if (iSeverityLevel == 1) {
            severityLevel = SEVERITY_WARNING_STR;
        } else if (iSeverityLevel == 2) {
            severityLevel = SEVERITY_INFO_STR;
        } else if (iSeverityLevel == 3) {
            severityLevel = SEVERITY_INFO_STR;
        }
        return severityLevel;
    }

    public static final String typeToString(ResponseMessageType eType) {
        String type = null;
        switch (eType) {
            case TYPE_PLAN_STAT_INT: {
                type = TYPE_PLAN_STAT_STR;
                break;
            }
            case TYPE_EXEC_STAT_INT: {
                type = TYPE_EXEC_STAT_STR;
                break;
            }
            case MDX_NODE_TYPE_INT: {
                type = MDX_NODE_TYPE_STR;
                break;
            }
            case SQL_NODE_TYPE_INT: {
                type = SQL_NODE_TYPE_STR;
                break;
            }
            case RQP_NODE_TYPE_INT: {
                type = RQP_NODE_TYPE_STR;
                break;
            }
            case DMR_NODE_TYPE_INT: {
                type = DMR_NODE_TYPE_STR;
                break;
            }
            case XTAB_REL_NODE_TYPE_INT: {
                type = XTAB_REL_NODE_TYPE_STR;
                break;
            }
            case TYPE_EXCEPTION: {
                type = EXCEPTION_TYPE_STR;
                break;
            }
            case MIGRATE_TYPE_INT: {
                type = "migrate";
                break;
            }
            default: {
                type = "UNKNOWN";
            }
        }
        return type;
    }

    public void setLocation(String loc) {
        this.location = loc;
    }

    public void setQueryLanguage(String lang) {
        this.queryLanguage = lang;
    }

    public String getQueryLanguage() {
        return this.queryLanguage;
    }

    public void setReportQuery(String query) {
        this.reportQuery = query;
    }

    @Override
    public int compareTo(ResponseMessage comparisonMessage) {
        return this.getLocalizedMessage(Locale.US).compareTo(comparisonMessage.getLocalizedMessage(Locale.US));
    }

    public int hashCode() {
        return this.getLocalizedMessage(Locale.US).hashCode();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof ResponseMessage) {
            return this.compareTo((ResponseMessage)other) == 0;
        }
        return false;
    }

    public static enum ResponseMessageType {
        TYPE_PLAN_STAT_INT,
        TYPE_EXEC_STAT_INT,
        MDX_NODE_TYPE_INT,
        SQL_NODE_TYPE_INT,
        RQP_NODE_TYPE_INT,
        DMR_NODE_TYPE_INT,
        XTAB_REL_NODE_TYPE_INT,
        TYPE_EXCEPTION,
        MIGRATE_TYPE_INT,
        UNKNOWN;

    }
}

