/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.query.engine;

import com.cognos.xqe.cache.CacheMetricsTracker;
import com.cognos.xqe.cache.ICacheListener;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPQueryExecuteMetrics;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class TestEnvironmentOptions {
    private static final int NUM_SECONDS_TO_WAIT = 60;
    private final TestHitCountTracker theCount = new TestHitCountTracker();
    private final List<WeakReference<Future<Void>>> concurrentTasks = new ArrayList<WeakReference<Future<Void>>>();
    private IDataSourceCapabilities modifiableCapabilities = null;

    public boolean searchForUnexpectedDuplicateOrdinalsWhenPipelining() {
        return true;
    }

    public TestHitCountTracker getHitCountTracker() {
        return this.theCount;
    }

    public synchronized void addConcurrentTaskFuture(Future<Void> future) {
        this.concurrentTasks.add(new WeakReference<Future<Void>>(future));
    }

    public synchronized void waitForAllConcurrentTasksToComplete() throws InterruptedException, ExecutionException, TimeoutException {
        for (WeakReference<Future<Void>> wrFuture : this.concurrentTasks) {
            Future future = (Future)wrFuture.get();
            if (future == null) continue;
            future.get(60L, TimeUnit.SECONDS);
        }
        this.concurrentTasks.clear();
    }

    public IDataSourceCapabilities getModifiableCapabilities() {
        return this.modifiableCapabilities;
    }

    public void setModifiableCapabilities(IDataSourceCapabilities modifiableCapabilities) {
        this.modifiableCapabilities = modifiableCapabilities;
    }

    public static class TestHitCountTracker {
        private final CacheMetricsTracker mResultSetCacheListener = new CacheMetricsTracker(false);
        private final CacheMetricsTracker mExpressionCacheListener = new CacheMetricsTracker(false);
        private final CacheMetricsTracker mDataCacheListener = new CacheMetricsTracker(true);
        private final CacheMetricsTracker mAggregateCacheListener = new CacheMetricsTracker(true);
        private final CacheMetricsTracker mAggregateCubeListener = new CacheMetricsTracker(true);
        private final CacheMetricsTracker mFactQueryListener = new CacheMetricsTracker(true);
        private final CacheMetricsTracker mAggregateRollupTasksListener = new CacheMetricsTracker(false);
        private final CacheMetricsTracker mPushdownListener = new CacheMetricsTracker(false);
        private int pipelinedRS = 0;
        private int pipelinedCallables = 0;
        private int streamingIterators = 0;

        public static TestHitCountTracker current() {
            ExecutionEnvironment execEnv = (ExecutionEnvironment)ExecutionEnvironmentContext.getExecutionEnvironment();
            if (execEnv == null) {
                return null;
            }
            TestEnvironmentOptions teo = execEnv.getTestEnvironmentOptions();
            if (teo == null) {
                return null;
            }
            return teo.getHitCountTracker();
        }

        public static void updateFromQueryMetrics(ROLAPQueryExecuteMetrics queryMetrics) {
            TestHitCountTracker thct = TestHitCountTracker.current();
            if (thct != null) {
                thct.getDataCacheListener().incrementHits(queryMetrics.getDataCacheHits());
                thct.getAggregateCacheListener().incrementHits(queryMetrics.getAggrCacheHits());
                thct.getAggregateCubeListener().incrementHits(queryMetrics.getAggrCubeHits());
                thct.getFactQueryListener().incrementHits(queryMetrics.getFetchCount());
                thct.getAggregateRollupTaskListener().incrementHits(queryMetrics.getNumAggregateQueryTasks());
            }
        }

        public void resetAll() {
            this.mResultSetCacheListener.clear();
            this.mExpressionCacheListener.clear();
            this.mDataCacheListener.clear();
            this.mAggregateCacheListener.clear();
            this.mAggregateCubeListener.clear();
            this.mFactQueryListener.clear();
            this.mPushdownListener.clear();
            this.mAggregateRollupTasksListener.clear();
            this.pipelinedRS = 0;
            this.pipelinedCallables = 0;
            this.streamingIterators = 0;
        }

        public final int getPipelinedResultSets() {
            return this.pipelinedRS;
        }

        public void incrementNumberOfPipelineResultSets() {
            ++this.pipelinedRS;
        }

        public final int getPipelinedCallables() {
            return this.pipelinedCallables;
        }

        public void incrementNumberOfPipelineCallables() {
            ++this.pipelinedCallables;
        }

        public final int getStreamingIterators() {
            return this.streamingIterators;
        }

        public void incrementNumberOfStreamingIterators() {
            ++this.streamingIterators;
        }

        public ICacheListener getResultSetCacheListener() {
            return this.mResultSetCacheListener;
        }

        public CacheMetricsTracker getExpressionCacheListener() {
            return this.mExpressionCacheListener;
        }

        public CacheMetricsTracker getDataCacheListener() {
            return this.mDataCacheListener;
        }

        public CacheMetricsTracker getAggregateCacheListener() {
            return this.mAggregateCacheListener;
        }

        public CacheMetricsTracker getAggregateCubeListener() {
            return this.mAggregateCubeListener;
        }

        public CacheMetricsTracker getFactQueryListener() {
            return this.mFactQueryListener;
        }

        public CacheMetricsTracker getPushdownListener() {
            return this.mPushdownListener;
        }

        public CacheMetricsTracker getAggregateRollupTaskListener() {
            return this.mAggregateRollupTasksListener;
        }
    }
}

