/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.query.masterdetail;

import com.cognos.xqe.ast.IXQEPersist;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQEPersistContext;
import com.cognos.xqe.ast.XQERestoreContext;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.result.V5MasterDetailLink;
import com.cognos.xqe.ast.v5.result.V5QueryResultDefinition;
import com.cognos.xqe.ast.v5Exp.V5Parameter;
import com.cognos.xqe.query.masterdetail.MasterDetailLink;
import com.cognos.xqe.query.masterdetail.MasterDetailQuery;
import com.cognos.xqe.rsapi.RSAPIDataset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.dom4j.Attribute;
import org.dom4j.Element;

public class MasterDetailProvider
implements IXQEPersist {
    private static final String ATTRIBUTE_DETAIL_QUERY_NAME_SEED = "detailQueryNameSeed";
    private static final String ELEMENT_QRD_TO_QUERIES = "qrd2Queries";
    private final Map<String, MasterDetailQuery> qrd2Queries = new HashMap<String, MasterDetailQuery>();
    private int detailQueryNameSeed = 0;

    public String addLink(V5QueryResultDefinition qrd, V5MasterDetailLink linkNode, V5QuerySet querySet) {
        String qrdName = (String)qrd.getPropertyValue("name");
        MasterDetailQuery mdQuery = this.qrd2Queries.get(qrdName);
        if (null == mdQuery) {
            mdQuery = new MasterDetailQuery(qrdName);
            this.qrd2Queries.put(qrdName, mdQuery);
        }
        return mdQuery.addLink(linkNode, querySet);
    }

    public MasterDetailLink getLink(String linkName) {
        for (MasterDetailQuery mdQuery : this.qrd2Queries.values()) {
            if (mdQuery.getLink(linkName) == null) continue;
            return mdQuery.getLink(linkName);
        }
        return null;
    }

    public boolean hasMasterDetailQuery() {
        return !this.qrd2Queries.isEmpty();
    }

    public boolean isMasterDetailLinkParameter(String paramName, String queryName) {
        for (MasterDetailQuery mdQuery : this.qrd2Queries.values()) {
            if (!mdQuery.isMasterDetailLinkParameter(paramName, queryName)) continue;
            return true;
        }
        return false;
    }

    public List<String> getMasterDetailLinkNamesForParameter(String paramName, String queryName) {
        for (MasterDetailQuery mdQuery : this.qrd2Queries.values()) {
            List<String> linkNames = mdQuery.getMasterDetailLinkNamesForParameter(paramName, queryName);
            if (linkNames == null || linkNames.isEmpty()) continue;
            return linkNames;
        }
        return null;
    }

    public List<V5DataItem> getV5DataItemInMasterQuery(V5Parameter v5Parameter, String queryName) {
        ArrayList<V5DataItem> dataItems = new ArrayList<V5DataItem>();
        List<String> linkNames = this.getMasterDetailLinkNamesForParameter(v5Parameter.getParameterName().trim(), queryName);
        if (linkNames != null) {
            for (String name : linkNames) {
                V5DataItem v5di;
                MasterDetailLink link = this.getLink(name);
                String mquery = link.getMasterQueryName();
                String di = link.getMasterRefDataItem();
                V5QuerySet queryset = (V5QuerySet)v5Parameter.getAncestorOfType(101002);
                V5Query query = queryset.getV5Query(mquery);
                if (query == null || (v5di = query.getDataItemByName(di)) == null) continue;
                dataItems.add(v5di);
            }
        }
        return dataItems;
    }

    public boolean isDetailQrd(String qrdName) {
        for (MasterDetailQuery mdQuery : this.qrd2Queries.values()) {
            if (!mdQuery.isDetailQrd(qrdName)) continue;
            return true;
        }
        return false;
    }

    public boolean isDetailQuery(String queryName) {
        for (MasterDetailQuery mdQuery : this.qrd2Queries.values()) {
            if (!mdQuery.isDetailQuery(queryName)) continue;
            return true;
        }
        return false;
    }

    public boolean isMasterQuery(String queryName) {
        for (MasterDetailQuery mdQuery : this.qrd2Queries.values()) {
            if (!mdQuery.isMasterQuery(queryName)) continue;
            return true;
        }
        return false;
    }

    public String getDetailQueryName(String qrdName) {
        for (MasterDetailQuery mdQuery : this.qrd2Queries.values()) {
            if (!mdQuery.isDetailQrd(qrdName)) continue;
            return mdQuery.getDetailQueryName(qrdName);
        }
        return null;
    }

    public boolean isDetailRSAPIDataset(RSAPIDataset rsapiDataset) {
        return this.isDetailQrd(rsapiDataset.getName());
    }

    public List<MasterDetailLink> getMasterDetailLinks(String masterQueryQRD) {
        MasterDetailQuery mdQuery = this.qrd2Queries.get(masterQueryQRD);
        if (null == mdQuery) {
            return new ArrayList<MasterDetailLink>();
        }
        return mdQuery.getMasterDetailLinks();
    }

    public List<MasterDetailLink> getMasterDetailLinksForDetailQrd(String detailQueryQRD) {
        for (MasterDetailQuery mdQuery : this.qrd2Queries.values()) {
            if (!mdQuery.isDetailQrd(detailQueryQRD)) continue;
            return mdQuery.getMasterDetailLinksForDetailQrd(detailQueryQRD);
        }
        return new ArrayList<MasterDetailLink>();
    }

    public Collection<RSAPIDataset> getRSAPIDatasetSiblings(RSAPIDataset rsapiDataset) {
        IXQEQueryNode[] rsapiDataSets;
        LinkedList<RSAPIDataset> result = new LinkedList<RSAPIDataset>();
        for (IXQEQueryNode node : rsapiDataSets = rsapiDataset.getParent().getChildrenOfType(401005)) {
            RSAPIDataset dataset = (RSAPIDataset)node;
            if (dataset == rsapiDataset) continue;
            result.add(dataset);
        }
        return result;
    }

    public Collection<RSAPIDataset> getDetailRSAPIDatasets(RSAPIDataset rsapiDataset) {
        IXQEQueryNode[] rsapiDataSets;
        LinkedList<RSAPIDataset> result = new LinkedList<RSAPIDataset>();
        for (IXQEQueryNode node : rsapiDataSets = rsapiDataset.getParent().getChildrenOfType(401005)) {
            RSAPIDataset dataset = (RSAPIDataset)node;
            if (dataset == rsapiDataset || !this.isDetailRSAPIDataset(dataset)) continue;
            result.add(dataset);
        }
        return result;
    }

    public Collection<RSAPIDataset> getMasterRSAPIDatasets(IXQEQueryNode[] rsapiDatasets) {
        LinkedList<RSAPIDataset> result = new LinkedList<RSAPIDataset>();
        for (IXQEQueryNode node : rsapiDatasets) {
            RSAPIDataset dataset = (RSAPIDataset)node;
            if (this.isDetailRSAPIDataset(dataset)) continue;
            result.add(dataset);
        }
        return result;
    }

    public void setParentMDLink(MasterDetailLink link) {
        for (MasterDetailQuery mdQuery : this.qrd2Queries.values()) {
            MasterDetailLink parentLink = mdQuery.getParentOf(link);
            if (parentLink == null) continue;
            link.setParentMDLink(parentLink);
            break;
        }
    }

    public void setParentMDLink(MasterDetailLink link, String dataItemName) {
        for (MasterDetailQuery mdQuery : this.qrd2Queries.values()) {
            MasterDetailLink parentLink = mdQuery.getParentOf(link, dataItemName);
            if (parentLink == null) continue;
            link.setParentMDLink(parentLink);
            break;
        }
    }

    public String getNewDetailQueryName(String oldName) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(oldName);
        buffer.append("$");
        buffer.append(this.detailQueryNameSeed);
        ++this.detailQueryNameSeed;
        return buffer.toString();
    }

    public void reset() {
        this.qrd2Queries.clear();
        this.detailQueryNameSeed = 0;
    }

    public String getMasterQueryName(String detailQueryName) {
        for (MasterDetailQuery mdQuery : this.qrd2Queries.values()) {
            if (!mdQuery.isDetailQuery(detailQueryName)) continue;
            return mdQuery.getMasterQueryName(detailQueryName);
        }
        return null;
    }

    public boolean isSameParameterInMasterQuery(String promptName, String queryName) {
        return this.isSameParameterInMasterQuery(promptName, queryName, queryName);
    }

    private boolean isSameParameterInMasterQuery(String promptName, String initialQuery, String queryName) {
        String masterQuery = this.getMasterQueryName(queryName);
        if (masterQuery == null || masterQuery.equals(initialQuery)) {
            return false;
        }
        if (this.isMasterDetailLinkParameter(promptName, masterQuery)) {
            return true;
        }
        if (masterQuery.equals(queryName)) {
            return false;
        }
        return this.isSameParameterInMasterQuery(promptName, initialQuery, masterQuery);
    }

    @Override
    public void persist(XQEPersistContext ctx, String optionalName) {
        if (ctx.beginElement(this, optionalName, -1)) {
            this.persistAttributeProperties(ctx);
            this.persistElementProperties(ctx);
            ctx.endElement();
        }
    }

    public void persistAttributeProperties(XQEPersistContext ctx) {
        ctx.property(ATTRIBUTE_DETAIL_QUERY_NAME_SEED, this.detailQueryNameSeed);
    }

    public void persistElementProperties(XQEPersistContext ctx) {
        if (this.qrd2Queries != null) {
            ctx.elementProperty(ELEMENT_QRD_TO_QUERIES, this.qrd2Queries);
        }
    }

    @Override
    public void restore(XQERestoreContext ctx, Element node) {
        this.restoreAttributes(ctx, node);
        this.restoreChildren(ctx, node);
    }

    public void restoreAttributes(XQERestoreContext ctx, Element node) {
        int size = node.attributeCount();
        for (int i = 0; i < size; ++i) {
            Attribute att = node.attribute(i);
            this.restoreAttributeProperty(ctx, att, node);
        }
    }

    protected void restoreAttributeProperty(XQERestoreContext ctx, Attribute att, Element node) {
        String attName = att.getName();
        if (attName.equals(ATTRIBUTE_DETAIL_QUERY_NAME_SEED)) {
            Object val = ctx.attributeValue(att);
            this.detailQueryNameSeed = (Integer)val;
        }
    }

    protected void restoreChildren(XQERestoreContext ctx, Element node) {
        List childList = node.elements();
        int nChildren = childList.size();
        for (int i = 0; i < nChildren; ++i) {
            Element child = (Element)childList.get(i);
            if (child.getNamespace().getURI().isEmpty()) continue;
            this.restoreElementProperty(ctx, child, node);
        }
    }

    protected void restoreElementProperty(XQERestoreContext ctx, Element node, Element inputNode) {
        String pname = node.attributeValue("pname");
        if (pname.equals(ELEMENT_QRD_TO_QUERIES)) {
            Object val = ctx.elementValue(node);
            this.qrd2Queries.clear();
            this.qrd2Queries.putAll((Map)val);
        }
    }
}

