/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.query.parameters;

import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.XQEPersistContext;
import com.cognos.xqe.ast.XQERestoreContext;
import com.cognos.xqe.ast.v5Exp.V5LiteralRange;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.parameters.Parameter;
import com.cognos.xqe.query.parameters.ParameterValueItem;
import com.cognos.xqe.query.parameters.V5ParameterValueItem;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import org.dom4j.Element;

public class BoundedRangeParameterValueItem
extends ParameterValueItem {
    private V5ParameterValueItem startValue = null;
    private V5ParameterValueItem endValue = null;

    public BoundedRangeParameterValueItem() {
    }

    public BoundedRangeParameterValueItem(Parameter theAssociatedParameter) {
        this.startValue = new V5ParameterValueItem(theAssociatedParameter);
        this.endValue = new V5ParameterValueItem(theAssociatedParameter);
    }

    public V5ParameterValueItem getStartValue() {
        return this.startValue;
    }

    public V5ParameterValueItem getEndValue() {
        return this.endValue;
    }

    @Override
    public void parse(Element itemElement) {
        super.parse(itemElement);
        this.startValue.parse(itemElement.element("start"));
        this.endValue.parse(itemElement.element("end"));
    }

    @Override
    public void parseJSON(JSONObject jValue) {
        super.parseJSON(jValue);
        this.startValue.parseJSON((JSONObject)jValue.get((Object)"start"));
        this.endValue.parseJSON((JSONObject)jValue.get((Object)"end"));
    }

    @Override
    void setExternalValue(PlanningEnvironment environment) {
        this.startValue.setExternalValue(environment);
        this.endValue.setExternalValue(environment);
    }

    @Override
    public void bind(PlanningEnvironment environment) {
        this.startValue.bind(environment);
        this.endValue.bind(environment);
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        V5LiteralRange literalRange = (V5LiteralRange)nodeFactory.createNode(201022);
        literalRange.setSubType(2);
        literalRange.setInclusive(this.getInclusive());
        literalRange.addChild(this.startValue.getBoundValue());
        literalRange.addChild(this.endValue.getBoundValue());
        super.setBoundValue(literalRange);
    }

    @Override
    public void asDOMString(StringBuilder buffer) {
        buffer.append("<item xsi:type=\"bus:boundRangeParmValueItem\">");
        super.asDOMString(buffer);
        this.startValue.asDOMString(buffer, "start");
        this.endValue.asDOMString(buffer, "end");
        buffer.append("</item>");
    }

    @Override
    public void appendJSON(JSONArray jItems) {
        JSONObject jObj = new JSONObject();
        jItems.add((Object)jObj);
        jObj.put((Object)"type", (Object)this.getClass().getSimpleName());
        this.addInclusive(jObj);
        this.startValue.appendJSON(jObj, "start");
        this.endValue.appendJSON(jObj, "end");
    }

    @Override
    public void asSAPVariablesString(StringBuilder buffer, PlanningEnvironment environment) {
        super.asSAPVariablesString(buffer, environment);
        buffer.append(this.startValue.getSAPTypeInRangeVariableValue()).append(":").append(this.endValue.getSAPTypeInRangeVariableValue());
    }

    public String getStartValueLiteral(String prefix, String suffix, IDataSourceCapabilities capabilities) {
        StringBuilder startBuffer = new StringBuilder();
        this.startValue.asSQLString(startBuffer, prefix, suffix, capabilities);
        return startBuffer.toString();
    }

    public String getEndValueLiteral(String prefix, String suffix, IDataSourceCapabilities capabilities) {
        StringBuilder endBuffer = new StringBuilder();
        this.endValue.asSQLString(endBuffer, prefix, suffix, capabilities);
        return endBuffer.toString();
    }

    @Override
    public boolean hasNullValue() {
        return this.startValue.hasNullValue() || this.endValue.hasNullValue();
    }

    public int hashCode() {
        if (this.startValue != null && this.endValue != null) {
            return this.startValue.hashCode() + this.endValue.hashCode();
        }
        return 0;
    }

    public boolean equals(Object pvi) {
        if (pvi instanceof BoundedRangeParameterValueItem) {
            return this.startValue != null && this.endValue != null && this.startValue.equals(((BoundedRangeParameterValueItem)pvi).getStartValue()) && this.endValue.equals(((BoundedRangeParameterValueItem)pvi).getEndValue());
        }
        return false;
    }

    @Override
    public void persistElementProperties(XQEPersistContext ctx) {
        super.persistElementProperties(ctx);
        if (this.startValue != null) {
            ctx.elementProperty("start", this.startValue);
        }
        if (this.endValue != null) {
            ctx.elementProperty("end", this.endValue);
        }
    }

    @Override
    protected void restoreElementProperty(XQERestoreContext ctx, Element node, Element inputNode) {
        String pname = node.attributeValue("pname");
        if (pname.equals("start")) {
            Object val = ctx.elementValue(node);
            this.startValue = (V5ParameterValueItem)val;
        } else if (pname.equals("end")) {
            Object val = ctx.elementValue(node);
            this.endValue = (V5ParameterValueItem)val;
        } else {
            super.restoreElementProperty(ctx, node, inputNode);
        }
    }
}

