/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.query.parameters;

import com.cognos.xqe.ast.IXQEPersist;
import com.cognos.xqe.ast.XQEPersistContext;
import com.cognos.xqe.ast.XQERestoreContext;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.parameters.BoundedRangeParameterValueItem;
import com.cognos.xqe.query.parameters.HierarchicalParmValueItem;
import com.cognos.xqe.query.parameters.Parameter;
import com.cognos.xqe.query.parameters.ParameterValueItem;
import com.cognos.xqe.query.parameters.SimpleParameterValueItem;
import com.cognos.xqe.query.parameters.UnboundedEndRangeParameterValueItem;
import com.cognos.xqe.query.parameters.UnboundedStartRangeParameterValueItem;
import com.cognos.xqe.query.parameters.V5ParameterValueItem;
import com.cognos.xqe.query.parameters.V5ParameterValueItemPattern;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.Element;

public class ParameterValues
extends ArrayList<ParameterValueItem>
implements IXQEPersist {
    private static final long serialVersionUID = 1L;
    public static final String ITEM_ELEMENT = "item";
    public static final String VALUE_ITEM_TYPE_PROP = "type";
    public static final String VALUE_ITEM_TYPE_SIMPLE = "simpleParmValueItem";
    public static final String VALUE_ITEM_TYPE_HIERARCHICAL = "hierarchicalParmValueItem";
    public static final String VALUE_ITEM_TYPE_BOUND = "boundRangeParmValueItem";
    public static final String VALUE_ITEM_TYPE_UNBOUNDSTART = "unboundedStartRangeParmValueItem";
    public static final String VALUE_ITEM_TYPE_UNBOUNDEND = "unboundedEndRangeParmValueItem";
    public static final String VALUE_ITEM_NIL_PROP = "nil";
    public static final String SINGLE_QUOTE_STR = "'";
    private static final String ATTRIBUTE_VALUE_EXPLICITLY_NOT_SUPPLIED = "valueExplicitlyNotSupplied";
    private static final String ATTRIBUTE_SAP_HIERARCHY_VARIABLE_ADDED_TO_SLICER = "sapHierarachyVariableAddedToSlicer";
    private static final String ELEMENT_ASSOCIATED_PARAMETER = "associatedParameter";
    private static final char COLON_CHAR = ':';
    private boolean valueExplicitlyNotSupplied = false;
    private Parameter associatedParameter = null;
    private Boolean sapHierarachyVariableAddedToSlicer = null;

    public ParameterValues(Parameter theAssociatedParameter) {
        this.associatedParameter = theAssociatedParameter;
    }

    public ParameterValues() {
    }

    public Parameter getAssociatedParameter() {
        return this.associatedParameter;
    }

    public void setAssociatedParameter(Parameter theAssociatedParameter) {
        Parameter.LOCATION location = null;
        if (this.associatedParameter != null) {
            location = this.associatedParameter.getLocation();
        }
        this.associatedParameter = theAssociatedParameter;
        if (location != null) {
            this.associatedParameter.setLocation(location);
        }
    }

    protected boolean parse(Element valueElement) {
        if (valueElement == null) {
            this.setValueExplicitlyNotSupplied(true);
        } else {
            this.clear();
            if (ParameterValues.isNil(valueElement)) {
                this.setValueExplicitlyNotSupplied(true);
            } else {
                List items = valueElement.elements();
                if (items.size() == 0) {
                    this.setValueExplicitlyNotSupplied(true);
                } else {
                    this.setValueExplicitlyNotSupplied(false);
                    for (Element itemElement : items) {
                        ParameterValueItem item = null;
                        if (ParameterValues.isNil(itemElement)) {
                            if (this.associatedParameter.isMasterDetailLinkParameter()) {
                                this.setValueExplicitlyNotSupplied(true);
                            }
                            item = new V5ParameterValueItem(this.associatedParameter);
                        } else {
                            String valueItemTypeName = itemElement.attributeValue(VALUE_ITEM_TYPE_PROP);
                            if (valueItemTypeName != null) {
                                if (valueItemTypeName.contains(":")) {
                                    valueItemTypeName = valueItemTypeName.substring(valueItemTypeName.indexOf(58) + 1);
                                }
                                if (valueItemTypeName.equals(VALUE_ITEM_TYPE_SIMPLE)) {
                                    item = new V5ParameterValueItem(this.associatedParameter);
                                } else if (valueItemTypeName.equals(VALUE_ITEM_TYPE_BOUND)) {
                                    item = new BoundedRangeParameterValueItem(this.associatedParameter);
                                } else if (valueItemTypeName.equals(VALUE_ITEM_TYPE_UNBOUNDSTART)) {
                                    item = new UnboundedStartRangeParameterValueItem(this.associatedParameter);
                                } else if (valueItemTypeName.equals(VALUE_ITEM_TYPE_UNBOUNDEND)) {
                                    item = new UnboundedEndRangeParameterValueItem(this.associatedParameter);
                                } else if (valueItemTypeName.equals(VALUE_ITEM_TYPE_HIERARCHICAL)) {
                                    item = new HierarchicalParmValueItem(this.associatedParameter);
                                }
                            } else {
                                boolean bStart = false;
                                boolean bEnd = false;
                                List itemChildren = itemElement.elements();
                                for (Element element : itemChildren) {
                                    String childName = element.getName();
                                    if (childName.equals("start")) {
                                        bStart = true;
                                        continue;
                                    }
                                    if (!childName.equals("end")) continue;
                                    bEnd = true;
                                }
                                item = bStart && bEnd ? new BoundedRangeParameterValueItem(this.associatedParameter) : (bStart ? new UnboundedEndRangeParameterValueItem(this.associatedParameter) : (bEnd ? new UnboundedStartRangeParameterValueItem(this.associatedParameter) : new V5ParameterValueItem(this.associatedParameter)));
                            }
                            ((ParameterValueItem)item).parse(itemElement);
                        }
                        this.add(item);
                    }
                }
            }
        }
        return this.containsValues() || this.isValueExplicitlyNotSupplied();
    }

    protected boolean parseJSON(JSONArray jsonValues) {
        if (jsonValues == null || jsonValues.size() == 0) {
            this.setValueExplicitlyNotSupplied(true);
        } else {
            this.clear();
            this.setValueExplicitlyNotSupplied(false);
            for (int i = 0; i < jsonValues.size(); ++i) {
                JSONObject jValue = (JSONObject)jsonValues.get(i);
                ParameterValueItem item = null;
                if (ParameterValues.isNilJSON(jValue)) {
                    if (this.associatedParameter.isMasterDetailLinkParameter()) {
                        this.setValueExplicitlyNotSupplied(true);
                    }
                    item = new V5ParameterValueItem(this.associatedParameter);
                } else {
                    String valueItemTypeName = (String)jValue.get((Object)VALUE_ITEM_TYPE_PROP);
                    if (valueItemTypeName != null) {
                        if (valueItemTypeName.contains(":")) {
                            valueItemTypeName = valueItemTypeName.substring(valueItemTypeName.indexOf(58) + 1);
                        }
                        if (valueItemTypeName.equals(VALUE_ITEM_TYPE_SIMPLE)) {
                            item = new V5ParameterValueItem(this.associatedParameter);
                        } else if (valueItemTypeName.equals(VALUE_ITEM_TYPE_BOUND)) {
                            item = new BoundedRangeParameterValueItem(this.associatedParameter);
                        } else if (valueItemTypeName.equals(VALUE_ITEM_TYPE_UNBOUNDSTART)) {
                            item = new UnboundedStartRangeParameterValueItem(this.associatedParameter);
                        } else if (valueItemTypeName.equals(VALUE_ITEM_TYPE_UNBOUNDEND)) {
                            item = new UnboundedEndRangeParameterValueItem(this.associatedParameter);
                        } else if (valueItemTypeName.equals(VALUE_ITEM_TYPE_HIERARCHICAL)) {
                            item = new HierarchicalParmValueItem(this.associatedParameter);
                        }
                    } else {
                        boolean bStart = jValue.containsKey((Object)"start");
                        boolean bEnd = jValue.containsKey((Object)"end");
                        item = bStart && bEnd ? new BoundedRangeParameterValueItem(this.associatedParameter) : (bStart ? new UnboundedEndRangeParameterValueItem(this.associatedParameter) : (bEnd ? new UnboundedStartRangeParameterValueItem(this.associatedParameter) : new V5ParameterValueItem(this.associatedParameter)));
                    }
                    if (item != null) {
                        ((ParameterValueItem)item).parseJSON(jValue);
                    }
                }
                if (item == null) continue;
                this.add(item);
            }
        }
        return this.containsValues() || this.isValueExplicitlyNotSupplied();
    }

    public static boolean isNil(Element element) {
        String nilValue = element.attributeValue(VALUE_ITEM_NIL_PROP);
        return nilValue != null && nilValue.equals("true");
    }

    public static boolean isNilJSON(JSONObject jValue) {
        Boolean nilValue = (Boolean)jValue.get((Object)VALUE_ITEM_NIL_PROP);
        return Boolean.TRUE.equals(nilValue);
    }

    public void addValue(boolean allowRanges, String lowIdentifier, String lowDisplay, String highIdentifier, String highDisplay) {
        boolean hasLowValue = lowIdentifier != null && lowIdentifier.length() > 0;
        boolean hasHighValue = highIdentifier != null && highIdentifier.length() > 0;
        ParameterValueItem newValue = null;
        if (allowRanges) {
            if (hasLowValue && !hasHighValue) {
                UnboundedEndRangeParameterValueItem newRangeValue = new UnboundedEndRangeParameterValueItem(this.associatedParameter);
                newRangeValue.getStartValue().setAll(true, lowDisplay, lowIdentifier);
                newValue = newRangeValue;
            } else if (hasHighValue && !hasLowValue) {
                UnboundedStartRangeParameterValueItem newRangeValue = new UnboundedStartRangeParameterValueItem(this.associatedParameter);
                newRangeValue.getEndValue().setAll(true, highDisplay, highIdentifier);
                newValue = newRangeValue;
            } else if (hasLowValue) {
                BoundedRangeParameterValueItem newRangeValue = new BoundedRangeParameterValueItem(this.associatedParameter);
                newRangeValue.getStartValue().setAll(true, lowDisplay, lowIdentifier);
                newRangeValue.getEndValue().setAll(true, highDisplay, highIdentifier);
                newValue = newRangeValue;
            }
        } else if (hasLowValue || hasHighValue) {
            V5ParameterValueItem parameterValueItem = new V5ParameterValueItem(this.associatedParameter);
            if (hasLowValue) {
                parameterValueItem.setAll(true, lowDisplay, lowIdentifier);
            } else {
                parameterValueItem.setAll(true, highDisplay, highIdentifier);
            }
            newValue = parameterValueItem;
        }
        if (newValue != null) {
            this.add(newValue);
        }
    }

    public void addValue(String value) {
        V5ParameterValueItem item = new V5ParameterValueItem(this.associatedParameter);
        item.setInternalValue(value);
        this.add(item);
    }

    public void addValue(IValue value) {
        SimpleParameterValueItem item = new SimpleParameterValueItem(this.associatedParameter);
        item.setValue(value);
        this.add(item);
    }

    public void addValue(boolean inclusive, String theDisplayValue, String theInternalValue) {
        V5ParameterValueItem item = new V5ParameterValueItem(this.associatedParameter);
        item.setInclusive(inclusive);
        item.setDisplayValue(theDisplayValue);
        item.setInternalValue(theInternalValue);
        this.add(item);
    }

    public void bind(PlanningEnvironment environment) {
        this.setExternalValues(environment);
        for (ParameterValueItem iterator : this) {
            iterator.bind(environment);
        }
        if (this.getAssociatedParameter().getErrorCode() != null) {
            this.getAssociatedParameter().clearParameterValueItems();
        }
    }

    void setExternalValues(PlanningEnvironment environment) {
        for (ParameterValueItem iterator : this) {
            iterator.setExternalValue(environment);
        }
    }

    public String asDOMString(String wrapperName) {
        StringBuilder buffer = new StringBuilder();
        boolean isValueExplicitlyNotSupplied = this.isValueExplicitlyNotSupplied();
        for (ParameterValueItem iterator : this) {
            iterator.asDOMString(buffer);
        }
        if (buffer.length() > 0 || isValueExplicitlyNotSupplied) {
            StringBuilder wrapperBuffer = new StringBuilder();
            wrapperBuffer.append("<");
            wrapperBuffer.append(wrapperName);
            wrapperBuffer.append(" ");
            if (buffer.length() == 0 && isValueExplicitlyNotSupplied) {
                wrapperBuffer.append("xsi:nil=\"true\" ");
            }
            wrapperBuffer.append("SOAP-ENC:arrayType=\"bus:parmValueItem[]\" xsi:type=\"SOAP-ENC:Array\">");
            buffer.insert(0, wrapperBuffer);
            buffer.append("</");
            buffer.append(wrapperName);
            buffer.append(">");
        }
        return buffer.toString();
    }

    public void appendJSON(String wrapperName, JSONObject owner) {
        boolean isValueExplicitlyNotSupplied = this.isValueExplicitlyNotSupplied();
        JSONArray jItems = new JSONArray();
        for (ParameterValueItem iterator : this) {
            iterator.appendJSON(jItems);
        }
        if (jItems.size() > 0 || isValueExplicitlyNotSupplied) {
            if (jItems.size() == 0 && isValueExplicitlyNotSupplied) {
                JSONObject jNil = new JSONObject();
                jNil.put((Object)VALUE_ITEM_NIL_PROP, (Object)true);
                jItems.add((Object)jNil);
                owner.put((Object)wrapperName, (Object)jItems);
                return;
            }
            if (jItems.size() > 0) {
                owner.put((Object)wrapperName, (Object)jItems);
            }
        }
    }

    public String asSQLString(String prefix, String suffix, IDataSourceCapabilities capabilities) {
        StringBuilder buffer = new StringBuilder();
        for (ParameterValueItem iterator : this) {
            if (buffer.length() > 0) {
                if (!this.getAssociatedParameter().getCapabilities().isMultivalued()) break;
                buffer.append(',');
            }
            iterator.asSQLString(buffer, prefix, suffix, capabilities);
        }
        return buffer.toString();
    }

    public String getValueLiteral(String prefix, String suffix, IDataSourceCapabilities capabilities) {
        return this.getValueLiteral(prefix, suffix, capabilities, false);
    }

    public String getValueLiteral(String prefix, String suffix, IDataSourceCapabilities capabilities, boolean isParamDescendantOfLike) {
        ParameterValueItem iterator2;
        StringBuilder buffer = new StringBuilder();
        boolean bParamValueItemPatternFound = false;
        for (ParameterValueItem iterator2 : this) {
            if (!(iterator2 instanceof V5ParameterValueItemPattern)) continue;
            bParamValueItemPatternFound = true;
            break;
        }
        Iterator iterator3 = this.iterator();
        while (iterator3.hasNext() && (iterator2 = (ParameterValueItem)iterator3.next()) instanceof SimpleParameterValueItem) {
            if (buffer.length() > 0) {
                if (!this.getAssociatedParameter().getCapabilities().isMultivalued()) break;
                buffer.append(',');
                buffer.append(' ');
            }
            if (bParamValueItemPatternFound && isParamDescendantOfLike && !(iterator2 instanceof V5ParameterValueItemPattern)) continue;
            iterator2.asSQLString(buffer, prefix, suffix, capabilities);
        }
        return buffer.toString();
    }

    public String asCSVString() {
        StringBuilder buffer = new StringBuilder();
        for (ParameterValueItem iterator : this) {
            V5ParameterValueItem simpleValue;
            String externalName;
            if (!(iterator instanceof V5ParameterValueItem) || (externalName = (simpleValue = (V5ParameterValueItem)iterator).getExternalValue()) == null || externalName.length() <= 0) continue;
            if (buffer.length() > 0) {
                buffer.append(", ");
            }
            buffer.append(externalName);
        }
        return buffer.toString();
    }

    public boolean containsValues() {
        return this.size() > 0;
    }

    public final boolean isValueExplicitlyNotSupplied() {
        return this.valueExplicitlyNotSupplied;
    }

    public void setValueExplicitlyNotSupplied(boolean flag) {
        this.valueExplicitlyNotSupplied = flag;
    }

    public boolean hasNullValue() {
        for (ParameterValueItem iterator : this) {
            if (!iterator.hasNullValue()) continue;
            return true;
        }
        return false;
    }

    public List<String> getExternalValues(boolean replaceNulls) {
        ArrayList<String> externalValues = new ArrayList<String>();
        String externalValue = null;
        for (ParameterValueItem iterator : this) {
            externalValue = iterator instanceof HierarchicalParmValueItem ? ((HierarchicalParmValueItem)iterator).getValue().getExternalValue() : ((V5ParameterValueItem)iterator).getExternalValue();
            if (replaceNulls && externalValue == null) {
                externalValue = "";
            }
            externalValues.add(externalValue);
        }
        return externalValues;
    }

    public String getIsNullPattern(IDataSourceCapabilities capabilities) {
        String pattern = capabilities.getStringValue("predicates.IsNull", null);
        if (pattern == null || pattern.length() == 0) {
            return null;
        }
        return String.format(pattern, "");
    }

    public void setSAPHierVarialbeAddedToSlicer() {
        this.sapHierarachyVariableAddedToSlicer = true;
    }

    public Boolean getSAPHierVarialbeAddedToSlicer() {
        return this.sapHierarachyVariableAddedToSlicer;
    }

    @Override
    public void persist(XQEPersistContext ctx, String optionalName) {
        if (ctx.beginElement(this, optionalName, -1)) {
            this.persistAttributeProperties(ctx);
            this.persistElementProperties(ctx);
            ctx.endElement();
        }
    }

    public void persistAttributeProperties(XQEPersistContext ctx) {
        ctx.property(ATTRIBUTE_VALUE_EXPLICITLY_NOT_SUPPLIED, this.valueExplicitlyNotSupplied);
        ctx.property(ATTRIBUTE_SAP_HIERARCHY_VARIABLE_ADDED_TO_SLICER, this.sapHierarachyVariableAddedToSlicer);
    }

    public void persistElementProperties(XQEPersistContext ctx) {
        if (this.associatedParameter != null) {
            ctx.elementProperty(ELEMENT_ASSOCIATED_PARAMETER, this.associatedParameter);
        }
        for (ParameterValueItem val : this) {
            ctx.elementProperty(null, val);
        }
    }

    @Override
    public void restore(XQERestoreContext ctx, Element node) {
        this.restoreAttributes(ctx, node);
        this.restoreChildren(ctx, node);
    }

    public void restoreAttributes(XQERestoreContext ctx, Element node) {
        int size = node.attributeCount();
        for (int i = 0; i < size; ++i) {
            Attribute att = node.attribute(i);
            this.restoreAttributeProperty(ctx, att, node);
        }
    }

    protected void restoreAttributeProperty(XQERestoreContext ctx, Attribute att, Element node) {
        String attName = att.getName();
        if (attName.equals(ATTRIBUTE_VALUE_EXPLICITLY_NOT_SUPPLIED)) {
            Object val = ctx.attributeValue(att);
            this.valueExplicitlyNotSupplied = (Boolean)val;
        } else if (attName.equals(ATTRIBUTE_SAP_HIERARCHY_VARIABLE_ADDED_TO_SLICER)) {
            Object val = ctx.attributeValue(att);
            this.sapHierarachyVariableAddedToSlicer = (Boolean)val;
        }
    }

    protected void restoreChildren(XQERestoreContext ctx, Element node) {
        List childList = node.elements();
        int nChildren = childList.size();
        for (int i = 0; i < nChildren; ++i) {
            Element child = (Element)childList.get(i);
            if (child.getNamespace().getURI().isEmpty()) continue;
            this.restoreElementProperty(ctx, child, node);
        }
    }

    protected void restoreElementProperty(XQERestoreContext ctx, Element node, Element inputNode) {
        String pname = node.attributeValue("pname");
        if (pname != null && pname.equals(ELEMENT_ASSOCIATED_PARAMETER)) {
            Object val = ctx.elementValue(node);
            this.associatedParameter = (Parameter)val;
        } else {
            Object val = ctx.elementValue(node);
            if (val != null) {
                this.add((ParameterValueItem)val);
            }
        }
    }

    public void replaceAssociatedParameter(Parameter newParam) {
        this.setAssociatedParameter(newParam);
        for (int i = 0; i < this.size(); ++i) {
            ParameterValueItem valueItem = (ParameterValueItem)this.get(i);
            if (!(valueItem instanceof SimpleParameterValueItem)) continue;
            ((SimpleParameterValueItem)valueItem).setAssociatedParameter(newParam);
        }
    }
}

