/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.resultsets;

import com.cognos.xqe.metrics.IProfiledIterator;
import com.cognos.xqe.metrics.IteratorProfilingManager;
import com.cognos.xqe.resultset.interfaces.ICell;
import com.cognos.xqe.resultset.interfaces.ICellIterator;
import com.cognos.xqe.trace.ProfilingTimer;

public abstract class BaseCellIterator
implements ICellIterator,
IProfiledIterator {
    private long count;
    private long totalTime;
    private long cpuTime;
    private ProfilingTimer timer;
    protected Integer nodeId;
    private boolean profilingEnabled;

    public BaseCellIterator(Integer theNodeId) {
        this.nodeId = theNodeId;
        if (IteratorProfilingManager.getInstance().register(this)) {
            this.timer = new ProfilingTimer();
            this.count = 0L;
            this.totalTime = 0L;
            this.cpuTime = 0L;
            this.profilingEnabled = true;
        }
    }

    public abstract ICell nextImpl();

    @Override
    public final ICell next() {
        if (this.profilingEnabled) {
            ++this.count;
            this.timer.reset();
            this.timer.start();
        }
        ICell cell = this.nextImpl();
        if (this.profilingEnabled) {
            this.timer.stop();
            this.totalTime += this.timer.getElapsedTime();
            this.cpuTime += this.timer.getCPUTime();
        }
        return cell;
    }

    @Override
    public long getCount() {
        return this.count;
    }

    @Override
    public long getTotalElapsedTime() {
        return this.totalTime;
    }

    @Override
    public long getTotalCPUTime() {
        return this.cpuTime;
    }

    @Override
    public Integer getNodeId() {
        return this.nodeId;
    }
}

