/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.resultsets;

import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.NumericValue;
import com.cognos.xqe.data.values.ValueConversionException;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.resultsets.ContextBase;
import com.cognos.xqe.resultsets.ContextMember;
import com.cognos.xqe.util.xml.XMLWriter;
import com.ibm.icu.text.Collator;

public class ContextValue
extends ContextBase
implements IValue {
    static final long serialVersionUID = 0L;
    private IValue mValue;

    public ContextValue() {
    }

    public ContextValue(IValue aValue) {
        this.mValue = aValue;
    }

    @Override
    public IDataType getDataType() {
        return this.mValue.getDataType();
    }

    @Override
    public boolean isMetadata() {
        return this.mValue.isMetadata();
    }

    @Override
    public boolean isPrimitive() {
        return this.mValue.isPrimitive();
    }

    @Override
    public boolean isResultSet() {
        return this.mValue.isResultSet();
    }

    @Override
    public int compareTo(Object arg0) {
        if (arg0 == this) {
            return 0;
        }
        if (arg0 instanceof ContextValue) {
            if (((ContextValue)arg0).getValue() instanceof NumericValue) {
                return this.compareToNumeric(((ContextValue)arg0).getValue());
            }
            return this.getValue().compareTo(((ContextValue)arg0).getValue());
        }
        if (arg0 instanceof IValue) {
            if (arg0 instanceof NumericValue) {
                return this.compareToNumeric((IValue)arg0);
            }
            return this.getValue().compareTo(arg0);
        }
        return -1;
    }

    private int compareToNumeric(IValue value) {
        if (this.getValue().getDataType().getCCLTypeCode() >= value.getDataType().getCCLTypeCode()) {
            return this.getValue().compareTo(value);
        }
        return value.compareTo(this.getValue()) * -1;
    }

    @Override
    public Object copy() {
        ContextValue value = new ContextValue();
        value.copyFrom(this);
        return value;
    }

    @Override
    public void copyFrom(IValue dValue) {
        ContextValue sourceValue = null;
        try {
            sourceValue = (ContextValue)dValue;
        }
        catch (ClassCastException cce) {
            throw new ValueConversionException(XQEMessageKeys.DAT_GeneralConversionError, (Throwable)cce, dValue.getDataType().getTypeName(), dValue.toString(), this.getDataType().getTypeName());
        }
        super.copy(sourceValue);
        if (sourceValue.getValue() != null) {
            if (this.mValue == null) {
                this.mValue = (IValue)sourceValue.getValue().copy();
            } else {
                this.mValue.copyFrom(sourceValue.getValue());
            }
        }
    }

    public void setValue(IValue val) {
        this.mValue = val;
    }

    public IValue getValue() {
        return this.mValue;
    }

    @Override
    public boolean contextIsAMember() {
        return false;
    }

    @Override
    public boolean contextIsAValue() {
        return true;
    }

    @Override
    public boolean isSummary() {
        ContextMember aContextMember = this.getContextMember();
        if (aContextMember == null) {
            if (this.isNullContext()) {
                return false;
            }
            return !this.getRowset().isDetailRowset();
        }
        return aContextMember.isSummary();
    }

    @Override
    public boolean isQueryCalculation() {
        ContextMember aContextMember = this.getContextMember();
        if (aContextMember == null) {
            return false;
        }
        return aContextMember.isQueryCalculation();
    }

    public String toString() {
        return this.mValue.toString();
    }

    @Override
    protected String getContextTypeName() {
        return "ContextValue";
    }

    @Override
    protected void dumpNestedObjects(XMLWriter xmlWriter) {
        super.dumpNestedObjects(xmlWriter);
        if (this.mValue != null) {
            this.mValue.toXML(xmlWriter);
        }
    }

    @Override
    public boolean isNull() {
        if (this.mValue == null) {
            return true;
        }
        return this.mValue.isNull();
    }

    @Override
    public void setNull() {
        if (this.mValue != null) {
            this.mValue.setNull();
        }
    }

    public int hashCode() {
        return this.mValue.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj != null && this.mValue.getClass().equals(obj.getClass())) {
            return this.mValue.equals(obj);
        }
        return false;
    }

    @Override
    public Object hashKey() {
        return this.mValue.hashKey();
    }

    @Override
    public Object hashKey(Collator collator) {
        return this.mValue.hashKey(collator);
    }

    @Override
    public void release() {
    }
}

