/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.resultsets;

import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.data.values.ValueState;
import com.cognos.xqe.resultsets.ContextMember;
import com.cognos.xqe.resultsets.ContextMemberWrapper;
import com.cognos.xqe.resultsets.ContextValue;
import com.cognos.xqe.runtree.v5.edgeupdate.XEdgeUpdateSpec;
import com.cognos.xqe.util.xml.XMLWriter;
import com.ibm.icu.text.Collator;

public final class ContextValueWrapper
extends ContextValue {
    private Value mChangedValue;

    public ContextValueWrapper(ContextValue contextValue) {
        this.copyFrom(contextValue);
    }

    public ContextValueWrapper() {
    }

    @Override
    public IDataType getDataType() {
        if (this.mChangedValue != null) {
            return this.mChangedValue.getDataType();
        }
        return super.getDataType();
    }

    @Override
    public boolean isMetadata() {
        if (this.mChangedValue != null) {
            return this.mChangedValue.isMetadata();
        }
        return super.isMetadata();
    }

    @Override
    public boolean isPrimitive() {
        if (this.mChangedValue != null) {
            return this.mChangedValue.isPrimitive();
        }
        return super.isPrimitive();
    }

    @Override
    public boolean isResultSet() {
        if (this.mChangedValue != null) {
            return this.mChangedValue.isResultSet();
        }
        return super.isResultSet();
    }

    private void changeValue(Value value) {
        this.mChangedValue = value;
    }

    private void changeValueState(ValueState newState) {
        if (this.mChangedValue == null) {
            this.mChangedValue = DataValueFactory.createStringValue();
        }
        this.mChangedValue.setState(newState);
    }

    public void updateV5Row(XEdgeUpdateSpec updateSpec) {
        switch (updateSpec.getUpdateType()) {
            case VALUE: {
                this.changeValue((Value)updateSpec.getNewValueOrState());
                break;
            }
            case VALUE_STATE: {
                ValueState newState = (ValueState)((Object)updateSpec.getNewValueOrState());
                this.changeValueState(newState);
                break;
            }
            case PROPERTY_VALUE: 
            case PROPERTY_VALUE_STATE: {
                ContextMember contextMember = this.getContextMember();
                ContextMemberWrapper wrapper = new ContextMemberWrapper(contextMember);
                wrapper.updateV5Row(updateSpec);
                this.setContextMember(wrapper);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    @Override
    public Object copy() {
        ContextValueWrapper value = new ContextValueWrapper();
        value.copyFrom(this);
        return value;
    }

    @Override
    public void copyFrom(IValue dValue) {
        if (dValue instanceof ContextValueWrapper) {
            ContextValueWrapper sourceWrapper = (ContextValueWrapper)dValue;
            this.mChangedValue = sourceWrapper.mChangedValue;
        }
        super.copyFrom(dValue);
    }

    @Override
    public IValue getValue() {
        if (this.mChangedValue != null) {
            return this.mChangedValue;
        }
        return super.getValue();
    }

    @Override
    public String toString() {
        if (this.mChangedValue != null) {
            return this.mChangedValue.toString();
        }
        return super.toString();
    }

    @Override
    protected void dumpNestedObjects(XMLWriter xmlWriter) {
        if (this.mChangedValue != null) {
            ContextMember context = this.getContextMember();
            if (context != null) {
                context.toXML(xmlWriter);
            }
            this.mChangedValue.toXML(xmlWriter);
        } else {
            super.dumpNestedObjects(xmlWriter);
        }
    }

    @Override
    public boolean isNull() {
        if (this.mChangedValue != null) {
            return this.mChangedValue.isNull();
        }
        return super.isNull();
    }

    @Override
    public void setNull() {
        if (this.mChangedValue != null) {
            this.mChangedValue.setNull();
        } else {
            super.setNull();
        }
    }

    @Override
    public int hashCode() {
        if (this.mChangedValue != null) {
            return this.mChangedValue.hashCode();
        }
        return super.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this.mChangedValue != null) {
            return this.mChangedValue.equals(obj);
        }
        return super.equals(obj);
    }

    @Override
    public Object hashKey() {
        if (this.mChangedValue != null) {
            return this.mChangedValue.hashKey();
        }
        return super.hashKey();
    }

    @Override
    public Object hashKey(Collator collator) {
        if (this.mChangedValue != null) {
            return this.mChangedValue.hashKey(collator);
        }
        return super.hashKey(collator);
    }
}

