/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.resultsets;

import com.cognos.xqe.cache.CacheException;
import com.cognos.xqe.cache.ICacheKey;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.StringValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.AggregateTypeEnum;
import com.cognos.xqe.metadata.IAggregateRule;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IMultiRequestHandle;
import com.cognos.xqe.metadata.MemberTypeEnum;
import com.cognos.xqe.metadata.MetadataType;
import com.cognos.xqe.metadata.RollupTypeEnum;
import com.cognos.xqe.metadata.provider.MetadataConnection;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.olap.mdx.metadata.metadatacache.MetadataCacheKey;
import com.cognos.xqe.util.UniqueNameGenerator;
import com.cognos.xqe.util.bean.BeanPropertySupport;
import com.cognos.xqe.util.xml.XMLWriter;
import com.ibm.icu.text.Collator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.builder.CompareToBuilder;

public class MemberProxy
implements IMember {
    private XDataContext context;
    private ICacheKey cacheKey;
    private ILevel level;
    private Map<String, Object> properties;
    protected String v5UniqueName;

    public MemberProxy(XDataContext dataContext, long memberKey, int levelIndex) {
        this.context = dataContext;
        this.cacheKey = new MetadataCacheKey(memberKey);
        this.level = this.context.getLevel(levelIndex);
    }

    private synchronized Object retrievePropValueFromCache(String propName) {
        try {
            if (this.properties == null) {
                this.properties = this.context.getCachedMemberProperties(this.cacheKey);
            }
            return this.properties.get(propName);
        }
        catch (CacheException e) {
            throw new XQERuntimeException(e);
        }
    }

    @Override
    public IAggregateRule[] getAggregateRules() {
        return null;
    }

    @Override
    public Object getBusinessKey() {
        return null;
    }

    @Override
    public Value getBusinessKeyValue() {
        return (Value)this.retrievePropValueFromCache("BK");
    }

    @Override
    public String getCaption() {
        return (String)this.retrievePropValueFromCache("MEMBER_CAPTION");
    }

    @Override
    public Value getCaptionValue() {
        StringValue v = DataValueFactory.createStringValue();
        ((Value)v).set(this.getCaption());
        return v;
    }

    @Override
    public int getChildIndex(IMember child) {
        return 0;
    }

    @Override
    public IMember getChildMember(String name) {
        return null;
    }

    @Override
    public IMember[] getChildMembers() {
        return null;
    }

    @Override
    public List<IMember> getChildren() {
        return null;
    }

    public List<IMember> getChildren(int startIndex, int count) {
        return null;
    }

    @Override
    public int getChildrenCardinality() {
        return 0;
    }

    @Override
    public IMember getDataMember() {
        return this;
    }

    @Override
    public IDimension getDimension() {
        return this.level.getDimension();
    }

    @Override
    public IHierarchy getHierarchy() {
        return this.level.getHierarchy();
    }

    @Override
    public ILevel getLevel() {
        return this.level;
    }

    @Override
    public int getNumberOfParents() {
        return 0;
    }

    @Override
    public IMember getParent() {
        return null;
    }

    @Override
    public int getParentLevelNumber() {
        return 0;
    }

    @Override
    public String getParentObjectUniqueName() {
        return null;
    }

    @Override
    public AggregateTypeEnum getRegularAggregate() {
        return null;
    }

    @Override
    public RollupTypeEnum getRollupType() {
        return null;
    }

    @Override
    public AggregateTypeEnum getSemiAggregate() {
        return null;
    }

    @Override
    public IMember[] getSiblings(boolean includeSelf) {
        return null;
    }

    @Override
    public MemberTypeEnum getType() {
        return MemberTypeEnum.REGULAR;
    }

    @Override
    public String getUniqueName() {
        return (String)this.retrievePropValueFromCache("MEMBER_UNIQUE_NAME");
    }

    @Override
    public boolean isCalculatedMember() {
        return false;
    }

    @Override
    public boolean isExtendedCalculatedMember() {
        return false;
    }

    @Override
    public boolean isExtendedCalculatedMemberTypeChildRef() {
        return false;
    }

    @Override
    public boolean isExtendedCalculatedMemberWithFormula() {
        return false;
    }

    @Override
    public boolean isProviderDefaultMember() {
        return false;
    }

    @Override
    public boolean isContextMember() {
        return false;
    }

    @Override
    public boolean isMeasure() {
        return false;
    }

    @Override
    public boolean isRelational() {
        return false;
    }

    @Override
    public boolean isSuppressed() {
        return false;
    }

    @Override
    public boolean isMetadata() {
        return true;
    }

    @Override
    public void release() {
    }

    @Override
    public String getName() {
        return (String)this.retrievePropValueFromCache("MEMBER_NAME");
    }

    @Override
    public String getParentUniqueName() {
        return (String)this.retrievePropValueFromCache("PARENT_UNIQUE_NAME");
    }

    @Override
    public String getV5UniqueName() {
        if (this.v5UniqueName == null) {
            this.v5UniqueName = UniqueNameGenerator.createMemberV5UniqueName(this.getLevel(), this.getUniqueName());
        }
        return this.v5UniqueName;
    }

    @Override
    public String getID() {
        return this.getV5UniqueName();
    }

    @Override
    public int compareTo(Object other) {
        if (!(other instanceof IMember)) {
            return -1;
        }
        CompareToBuilder ctb = new CompareToBuilder();
        ctb.append((Object)this.getUniqueName(), (Object)((IMetadata)other).getUniqueName());
        return ctb.toComparison();
    }

    @Override
    public Set<String> getAvailableProperties() {
        return null;
    }

    @Override
    public BeanPropertySupport getBeanPropertySupport() {
        return null;
    }

    @Override
    public List<IMetadata> getChildMetadataObjects() {
        return null;
    }

    @Override
    public MetadataConnection getConnection() {
        return null;
    }

    @Override
    public IDataType getDataType() {
        return DataTypeFactory.getMemberType();
    }

    @Override
    public String getDescription() {
        return null;
    }

    @Override
    public String getScreenTip() {
        return null;
    }

    @Override
    public MetadataType getObjectType() {
        return MetadataType.MEMBER;
    }

    @Override
    public IMetadata getParentObject() {
        return null;
    }

    @Override
    public Object getProperty(String propertyName) {
        return this.retrievePropValueFromCache(propertyName);
    }

    @Override
    public String getUniqueID() {
        return null;
    }

    @Override
    public boolean hasChildMetadataObjects() {
        return false;
    }

    @Override
    public void copyFrom(IValue value) {
    }

    @Override
    public int fastHash() {
        return 0;
    }

    @Override
    public Object hashKey() {
        return null;
    }

    @Override
    public Object hashKey(Collator collator) {
        return null;
    }

    @Override
    public boolean isNull() {
        return false;
    }

    @Override
    public boolean isPrimitive() {
        return false;
    }

    @Override
    public boolean isResultSet() {
        return false;
    }

    @Override
    public void setNull() {
    }

    @Override
    public int sizeOf() {
        return 0;
    }

    @Override
    public void toXML(XMLWriter xmlWriter) {
    }

    @Override
    public Object toJSON() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object copy() {
        return this;
    }

    @Override
    public boolean isDMR() {
        return false;
    }

    @Override
    public boolean isMFW() {
        return false;
    }

    @Override
    public boolean isDataBaseCalculation() {
        return false;
    }

    @Override
    public IMetadata getParentObjectSkipFolders() {
        return null;
    }

    @Override
    public String getV5MUN() {
        return null;
    }

    @Override
    public boolean isAccessible() {
        return false;
    }

    @Override
    public void setParentMetadataObject(IMetadata parent) {
    }

    @Override
    public IMultiRequestHandle[] getHandles() {
        return null;
    }

    @Override
    public List<IMetadata> getDescendantMetadataObjectsSkipFolders() {
        return null;
    }

    @Override
    public boolean isHidden() {
        return false;
    }

    @Override
    public boolean isVisible(boolean inShortcut) {
        return false;
    }
}

