/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.resultsets.caching;

import com.cognos.xqe.cache.ICaching;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.data.providers.relational.AbstractConnection;
import com.cognos.xqe.data.providers.relational.jdbc.JDBCConnection;
import com.cognos.xqe.data.providers.relational.jdbc.JDBCLog;
import com.cognos.xqe.data.providers.relational.jdbc.JDBCTabularResult;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.pool.connection.IPooledConnection;
import com.cognos.xqe.resultset.interfaces.ITabularIterator;
import com.cognos.xqe.resultset.interfaces.ITabularResultSet;
import com.cognos.xqe.resultsets.BaseIterator;
import com.cognos.xqe.resultsets.caching.CachedResultSet;
import com.cognos.xqe.resultsets.caching.CachedResultSetManager;
import com.cognos.xqe.resultsets.caching.ForwardOnlyColumnarCache;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.relational.vectorization.IVectorContext;
import com.cognos.xqe.runtree.relational.vectorization.XVectorContext;
import com.cognos.xqe.runtree.relational.vectorization.XVectorTabularIterator;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.util.resource.ReleasableResourceTracker;
import com.cognos.xqerdp.flint.FlintConnection;
import com.cognos.xqerdp.flint.FlintTabularResult;
import java.util.concurrent.TimeUnit;

public final class CachedColumnarResultSet
extends CachedResultSet
implements IVectorContext {
    private static final int ONE = 1;
    private ForwardOnlyColumnarCache cache;
    private static XQELogger infoLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "CacheManager", LogLevel.INFO);

    public CachedColumnarResultSet(XDataContext context, ITabularResultSet iResultSet, CachedResultSetManager.IPooledConnectionDelegator iResultSetPooledConnectionDelegator, ReleasableResourceTracker tracker, int cachedResultSetId, String theKey, int maxMemory) {
        super(context, iResultSet, iResultSetPooledConnectionDelegator, tracker, cachedResultSetId, theKey, maxMemory);
    }

    @Override
    public synchronized boolean isCanceledJDBCTabularResultSet() {
        if (this.canceled) {
            return true;
        }
        if (this.cache != null && (this.cache.getCancelReason() != null || this.cache.isCanceled())) {
            return true;
        }
        if (this.inputResultSet instanceof JDBCTabularResult) {
            return ((JDBCTabularResult)this.inputResultSet).isCanceled();
        }
        if (this.inputResultSet instanceof FlintTabularResult) {
            return ((FlintTabularResult)this.inputResultSet).isCanceled();
        }
        return false;
    }

    @Override
    public synchronized ITabularIterator getTabularIterator() {
        return new CachedColumnarResultSetIterator(this.getDataContext(), null);
    }

    @Override
    public synchronized ITabularIterator getTabularIterator(XVectorContext vContext) {
        return new CachedColumnarResultSetIterator(this.getDataContext(), vContext);
    }

    public String toString() {
        return String.format("CachedResultSet-%d (%d)", this.id, this.refCount);
    }

    public void loadInBackground() {
        this.cache.loadInBackground();
    }

    @Override
    public void release() {
        IPooledConnection pooledConnection = null != this.resultSetPooledConnectionDelegator ? this.resultSetPooledConnectionDelegator.delegatePooledConnection() : null;
        this.decrementReferenceCount();
        if (null != pooledConnection) {
            AbstractConnection connection;
            IDataSourceCapabilities capabilities;
            if (this.cache != null && !this.cache.isCompleted() && (capabilities = (connection = (AbstractConnection)pooledConnection.getConnection()).getCapabilities()).getIntegerValue("limits.maxStatements") == 1) {
                if (connection instanceof JDBCConnection) {
                    ((JDBCConnection)connection).removeResultSet(this.key);
                } else if (connection instanceof FlintConnection) {
                    ((FlintConnection)connection).removeResultSet(this.key);
                }
                this.cache.release();
                if (infoLogger.isOn()) {
                    infoLogger.log(String.format("Evicted cached result set [id=%1$d, refCount=%2$d]because limits.maxStatements=1 and JDBC ResultSet was not fully read and closed.", this.getId(), this.getReferenceCount()));
                }
            }
            pooledConnection.returnConnection();
        }
        if (null != this.resultSetPooledConnectionDelegator && this.resultSetPooledConnectionDelegator.getPooledConnectionBorrowedTimeBegin() > 0L) {
            long begin = this.resultSetPooledConnectionDelegator.getPooledConnectionBorrowedTimeBegin();
            long end = System.nanoTime();
            JDBCLog.getLogger().log(String.format("FlintResultSet: %s - Returning the Flint Pooled Connection (%s).\nTotal Time Flint Pooled Connection was borrowed: %.3f secs.", this.resultSetPooledConnectionDelegator, pooledConnection, Float.valueOf((float)(end - begin) * 1.0f / (float)TimeUnit.SECONDS.toNanos(1L))));
        }
        if (infoLogger.isOn()) {
            infoLogger.log(String.format("'release' for cached result set [id=%1$d, refCount=%2$d].", this.getId(), this.getReferenceCount()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void releaseImpl() {
        block13: {
            try {
                if (this.cache == null) break block13;
                try {
                    this.cache.release();
                }
                finally {
                    this.cache = null;
                }
            }
            finally {
                this.resultSetPooledConnectionDelegator = null;
                if (this.inputResultSet != null) {
                    try {
                        this.inputResultSet.release();
                    }
                    finally {
                        this.inputResultSet = null;
                    }
                }
            }
        }
        if (infoLogger.isOn()) {
            infoLogger.log(String.format("Releasing cached result set [id=%1$d].", this.getId()));
        }
    }

    private final class CachedColumnarResultSetIterator
    extends XVectorTabularIterator
    implements ICaching {
        private ITabularIterator tabIt;

        protected CachedColumnarResultSetIterator(XDataContext context, XVectorContext vContext) {
            super(context, CachedColumnarResultSet.this.nodeId, CachedColumnarResultSet.this.rowsetInfo);
            try {
                if (CachedColumnarResultSet.this.cache == null) {
                    try {
                        CachedColumnarResultSet.this.cache = new ForwardOnlyColumnarCache(context, CachedColumnarResultSet.this.inputResultSet, CachedColumnarResultSet.this.id, CachedColumnarResultSet.this.maxMemory);
                        CachedColumnarResultSet.this.inputResultSet = null;
                    }
                    catch (XQERuntimeException xre) {
                        CachedColumnarResultSet.this.canceled = true;
                        throw xre;
                    }
                }
                this.tabIt = CachedColumnarResultSet.this.cache.getTabularIterator(context, vContext);
            }
            catch (RuntimeException e) {
                this.release();
                throw e;
            }
        }

        @Override
        public Object nextImpl() {
            return this.tabIt.next();
        }

        @Override
        public Object nextBatch() {
            return this.tabIt.nextBatch();
        }

        @Override
        public long positionOnRow(long detailRowNumber, boolean top) {
            return ((BaseIterator)((Object)this.tabIt)).positionOnRow(detailRowNumber, top);
        }

        @Override
        public long getIndex() {
            return this.tabIt.getIndex();
        }

        @Override
        public void release() {
            block6: {
                try {
                    if (this.tabIt == null) break block6;
                    try {
                        this.tabIt.release();
                    }
                    finally {
                        this.tabIt = null;
                    }
                }
                finally {
                    super.release();
                }
            }
        }

        @Override
        public boolean isCaching() {
            return true;
        }
    }
}

