/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.resultsets.caching;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.data.providers.relational.jdbc.JDBCTabularResult;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.pool.connection.IPooledConnection;
import com.cognos.xqe.query.engine.IExecutionEnvironment;
import com.cognos.xqe.resultset.interfaces.ITabularResultSet;
import com.cognos.xqe.resultsets.caching.CachedColumnarResultSet;
import com.cognos.xqe.resultsets.caching.CachedResultSet;
import com.cognos.xqe.resultsets.caching.CachedTabularResultSet;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.util.resource.ReleasableResourceTracker;
import java.sql.Timestamp;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;

public final class CachedResultSetManager {
    private boolean cachingEnabled;
    private LRUHashMap resultSetCache;
    protected int maxMemory;
    private static final AtomicInteger LAST_CACHED_RESULT_SET_ID = new AtomicInteger(0);
    private static XQELogger infoLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "CacheManager", LogLevel.INFO);
    private static XQELogger errorLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Exception", LogLevel.ERROR);

    public CachedResultSetManager(boolean theCachingEnabled, int theMemory, int theThreshold) {
        this.cachingEnabled = theCachingEnabled;
        this.maxMemory = theMemory;
        this.resultSetCache = new LRUHashMap(theThreshold);
    }

    public void configure(boolean theCachingEnabled, int theMemory, int theThreshold) {
        this.cachingEnabled = theCachingEnabled;
        this.maxMemory = theMemory;
        this.resultSetCache = new LRUHashMap(theThreshold);
    }

    public synchronized ITabularResultSet getCachedResultSet(String key) {
        CachedResultSet cachedResultSet = this.resultSetCache.get(key);
        if (cachedResultSet != null) {
            if (cachedResultSet.isCanceledJDBCTabularResultSet()) {
                this.removeResultSet(key);
                return null;
            }
            XDataContext dc = cachedResultSet.getDataContext();
            if (dc.isCanceled()) {
                dc.setCanceled(false);
            }
            if (infoLogger.isOn()) {
                infoLogger.log(String.format("Reusing cached result [id=%1$d].", cachedResultSet.getId()));
            }
            cachedResultSet.setTimeLastUsed(System.currentTimeMillis());
        }
        return cachedResultSet;
    }

    public synchronized ITabularResultSet createCachedResultSet(XDataContext context, ITabularResultSet iResultSet, IPooledConnectionDelegator iResultSetPooledConnectionDelegator, ReleasableResourceTracker tracker, String key, String dsName) {
        CachedResultSet cachedResultSet = iResultSet instanceof JDBCTabularResult && ((JDBCTabularResult)iResultSet).getVectorizationContext() != null ? new CachedColumnarResultSet(context, iResultSet, iResultSetPooledConnectionDelegator, tracker, LAST_CACHED_RESULT_SET_ID.incrementAndGet(), key, this.maxMemory) : new CachedTabularResultSet(context, iResultSet, iResultSetPooledConnectionDelegator, tracker, LAST_CACHED_RESULT_SET_ID.incrementAndGet(), key, this.maxMemory);
        this.resultSetCache.put(key, cachedResultSet);
        IExecutionEnvironment executionEnv = context.getEnvironment();
        String camPassport = executionEnv.getRequestEnvironment().getCAMPassport();
        if (infoLogger.isOn()) {
            infoLogger.log(String.format("Caching result set [id=%1$d, CAMID=%2$s, dataSource=%3$s, key=(%4$s)].", cachedResultSet.getId(), camPassport, dsName, key));
        }
        if (this.resultSetCache.thresholdReached() && infoLogger.isOn()) {
            infoLogger.log(String.format("Threshold value of %1$d cached result sets has been reached.", this.resultSetCache.mMaxSize));
        }
        return cachedResultSet;
    }

    public boolean isCachingEnabled() {
        return this.cachingEnabled;
    }

    public Set<Object> getCachedEntrySet() {
        return this.resultSetCache.getCachedEntrySet();
    }

    public void release() {
        this.resultSetCache.clear();
    }

    public void removeResultSet(String key) {
        this.resultSetCache.removeResultSet(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeResultSet(long idleTime) {
        LRUHashMap lRUHashMap = this.resultSetCache;
        synchronized (lRUHashMap) {
            String[] keys;
            for (String key : keys = this.resultSetCache.keySet().toArray(new String[0])) {
                if (this.resultSetCache.readValue(key).getTimeLastUsed() >= idleTime) continue;
                if (infoLogger.isOn()) {
                    infoLogger.log(String.format("Query Reuse removes cursor %1$s because its TimeLastUsed(%2$s) < idleTime(%3$s).", key, new Timestamp(this.resultSetCache.readValue(key).getTimeLastUsed()), new Timestamp(idleTime)));
                }
                this.removeResultSet(key);
            }
        }
    }

    public int getMaxMemory() {
        return this.maxMemory;
    }

    public int getThreshold() {
        return this.resultSetCache.getMaxSize();
    }

    public void setThreshold(int newValue) {
        this.resultSetCache.setMaxSize(newValue);
    }

    public void setMaxMemory(int newValue) {
        this.maxMemory = newValue;
    }

    private static final class LRUHashMap
    extends LinkedHashMap<String, CachedResultSet> {
        private static final long serialVersionUID = -8547179731571733159L;
        private static final float DEFAULT_GROWTH_FACTOR = 0.75f;
        private int mMaxSize;

        LRUHashMap(int maxSize) {
            super(maxSize, 0.75f, true);
            this.mMaxSize = maxSize;
        }

        @Override
        public synchronized CachedResultSet get(Object key) {
            CachedResultSet cachedResultSet = (CachedResultSet)super.get(key);
            if (cachedResultSet != null) {
                cachedResultSet.incrementReferenceCount();
            }
            return cachedResultSet;
        }

        public synchronized CachedResultSet readValue(Object key) {
            CachedResultSet cachedResultSet = (CachedResultSet)super.get(key);
            return cachedResultSet;
        }

        @Override
        public synchronized CachedResultSet put(String key, CachedResultSet cachedResultSet) {
            cachedResultSet.incrementReferenceCount();
            return super.put(key, cachedResultSet);
        }

        public synchronized void removeResultSet(String key) {
            CachedResultSet rs = (CachedResultSet)this.remove(key);
            if (rs != null) {
                rs.decrementReferenceCount();
            }
        }

        @Override
        public synchronized void clear() {
            OutOfMemoryError outOfMemoryError = null;
            Throwable throwable = null;
            for (CachedResultSet cachedResultSet : this.values()) {
                try {
                    cachedResultSet.decrementReferenceCount();
                }
                catch (OutOfMemoryError oom) {
                    if (outOfMemoryError != null) continue;
                    outOfMemoryError = oom;
                    throwable = null;
                }
                catch (Throwable t) {
                    if (null != outOfMemoryError) continue;
                    errorLogger.log(t);
                    if (throwable != null) continue;
                    throwable = t;
                }
            }
            super.clear();
            if (null != outOfMemoryError) {
                throw outOfMemoryError;
            }
            if (null != throwable) {
                throw new XQERuntimeException(throwable);
            }
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, CachedResultSet> entry) {
            boolean result;
            boolean bl = result = this.size() > this.mMaxSize;
            if (result) {
                CachedResultSet cachedResultSet = entry.getValue();
                cachedResultSet.decrementReferenceCount();
            }
            return result;
        }

        synchronized boolean thresholdReached() {
            return this.size() >= this.mMaxSize;
        }

        private synchronized Set<Object> getCachedEntrySet() {
            HashSet result = null;
            if (!this.isEmpty()) {
                result = new HashSet(this.size());
                result.addAll(this.entrySet());
            }
            return result;
        }

        public int getMaxSize() {
            return this.mMaxSize;
        }

        public void setMaxSize(int newValue) {
            this.mMaxSize = newValue;
        }
    }

    public static interface IPooledConnectionDelegator {
        public IPooledConnection delegatePooledConnection();

        public long getPooledConnectionBorrowedTimeBegin();
    }
}

