/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.resultsets.caching;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.IRow;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.query.engine.TransformationEngine;
import com.cognos.xqe.resultset.interfaces.IIterator;
import com.cognos.xqe.resultset.interfaces.IRowsetInfo;
import com.cognos.xqe.resultset.interfaces.IScrollableIterator;
import com.cognos.xqe.resultset.interfaces.ITabularIterator;
import com.cognos.xqe.resultset.interfaces.ITabularResultSet;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.XTabularIterator;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.util.IReleasable;
import com.cognos.xqe.util.io.BufferedDataInputStream;
import com.cognos.xqe.util.io.BufferedDataOutputStream;
import com.cognos.xqe.util.io.TempFileUtil;
import com.cognos.xqe.util.primitive.LongArrayList;
import java.io.File;
import java.io.IOException;
import java.util.NoSuchElementException;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public final class ScrollableTabularCache
implements IReleasable {
    private IIterator tableIterator;
    private IRowsetInfo rowsetInfo;
    private long rowCount = -1L;
    private ReadWriteLock lock = new ReentrantReadWriteLock();
    private File tempFile;
    private BufferedDataInputStream inputStream;
    private BufferedDataOutputStream outputStream;
    private static final int INITIAL_CAPACITY = 5000;
    private LongArrayList map = new LongArrayList(5000);
    private long indexOfLastRowAccessed = -1L;
    private IRow lastRowAccessed;
    private static XQELogger mErrorLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Exception", LogLevel.ERROR);

    public ScrollableTabularCache(XDataContext xDataContext, ITabularResultSet resultSet) {
        this(xDataContext, resultSet, false);
    }

    public ScrollableTabularCache(XDataContext xDataContext, ITabularResultSet resultSet, boolean fetchAll) {
        try {
            this.tempFile = TempFileUtil.createTempFile(this.getClass().getSimpleName(), ".cache");
            this.outputStream = new BufferedDataOutputStream(this.tempFile);
            this.inputStream = new BufferedDataInputStream(this.tempFile);
        }
        catch (Exception e) {
            this.release();
            throw new XQERuntimeException(e);
        }
        this.rowsetInfo = resultSet.getTabularRowsetInfo();
        this.lastRowAccessed = DataValueFactory.createRowValue(xDataContext.getLocalCollator(), this.rowsetInfo);
        this.tableIterator = resultSet.getTabularIterator();
        if (fetchAll) {
            ITabularIterator tabIt = this.getTabularIterator(xDataContext);
            while (tabIt.next() != null) {
            }
            tabIt.release();
        }
    }

    public IRowsetInfo getTabularRowsetInfo() {
        return this.rowsetInfo;
    }

    public ITabularIterator getTabularIterator(XDataContext xDataContext) {
        return new TabularCacheIterator(xDataContext, TransformationEngine.DUMMY_NODEID, this.rowsetInfo);
    }

    public IScrollableIterator getScrollableTabularIterator(XDataContext xDataContext) {
        return new TabularCacheIterator(xDataContext, TransformationEngine.DUMMY_NODEID, this.rowsetInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release() {
        if (this.tableIterator != null) {
            try {
                this.tableIterator.release();
                this.tableIterator = null;
            }
            catch (Exception e) {
                mErrorLogger.log(e);
            }
            finally {
                this.tableIterator = null;
            }
        }
        if (this.inputStream != null) {
            try {
                this.inputStream.close();
                this.inputStream = null;
            }
            catch (Exception e) {
                mErrorLogger.log(e);
            }
            finally {
                this.inputStream = null;
            }
        }
        if (this.outputStream != null) {
            try {
                this.outputStream.close();
                this.outputStream = null;
            }
            catch (Exception e) {
                mErrorLogger.log(e);
            }
            finally {
                this.outputStream = null;
            }
        }
        if (this.tempFile != null) {
            try {
                TempFileUtil.deleteTempFile(this.tempFile);
                this.tempFile = null;
            }
            catch (Exception e) {
                mErrorLogger.log(e);
            }
            finally {
                this.tempFile = null;
            }
        }
        this.lastRowAccessed = null;
        this.map = null;
        this.rowsetInfo = null;
    }

    private IRow fetchRow(XDataContext context, long index, IRow row) {
        IRow result;
        block19: {
            result = row;
            this.lock.writeLock().lock();
            try {
                if (index > this.rowCount) {
                    if (this.outputStream == null) {
                        IRow iRow = null;
                        return iRow;
                    }
                    while (index > this.rowCount) {
                        try {
                            result = (IRow)this.tableIterator.next();
                            if (result == null) {
                                this.outputStream.close();
                                this.outputStream = null;
                                this.tableIterator.release();
                                this.tableIterator = null;
                                break block19;
                            }
                            ++this.rowCount;
                            if (this.rowCount != 0L && this.lastRowAccessed.equals(result)) {
                                this.map.add(this.map.get((int)this.rowCount - 1));
                            } else {
                                this.map.add(this.outputStream.size());
                                row.copyFrom(result);
                                row.encode(context, this.outputStream);
                                this.lastRowAccessed.copyFrom(result);
                            }
                            this.indexOfLastRowAccessed = index;
                        }
                        catch (IOException e) {
                            throw new XQERuntimeException(XQEMessageKeys.GEN_UnexpectedException, (Throwable)e);
                        }
                    }
                    break block19;
                }
                if (this.outputStream != null) {
                    this.outputStream.flush();
                }
                if (this.map.get((int)index) == this.map.get((int)this.indexOfLastRowAccessed)) {
                    row.copyFrom(this.lastRowAccessed);
                } else {
                    if (this.indexOfLastRowAccessed + 1L != index) {
                        this.inputStream.seek(this.map.get((int)index));
                    }
                    row.decode(context, this.inputStream);
                }
                this.indexOfLastRowAccessed = index;
                if (!this.lastRowAccessed.equals(row)) {
                    this.lastRowAccessed.copyFrom(row);
                }
            }
            catch (IOException e) {
                throw new XQERuntimeException(e);
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
        return result;
    }

    protected class TabularCacheIterator
    extends XTabularIterator
    implements IScrollableIterator {
        private IRow row;
        private long index;
        private IRow current;

        public TabularCacheIterator(XDataContext xDataContext, Integer id, IRowsetInfo theRowsetInfo) {
            super(xDataContext, id);
            this.index = -1L;
            this.current = null;
            ScrollableTabularCache.this.rowsetInfo = theRowsetInfo;
            this.row = DataValueFactory.createRowValue(xDataContext.getLocalCollator(), ScrollableTabularCache.this.rowsetInfo);
        }

        @Override
        public Object nextImpl() {
            this.current = ScrollableTabularCache.this.fetchRow(this.context, ++this.index, this.row);
            return this.current;
        }

        @Override
        public boolean hasPrevious() {
            return this.index > -1L;
        }

        @Override
        public Object previous() {
            this.current = ScrollableTabularCache.this.fetchRow(this.context, this.index--, this.row);
            return this.current;
        }

        @Override
        public boolean absolute(long rowIndex) {
            if (rowIndex != this.index) {
                IRow tmpRow = ScrollableTabularCache.this.fetchRow(this.context, rowIndex, this.row);
                if (tmpRow == null) {
                    throw new NoSuchElementException();
                }
                this.index = rowIndex;
                this.current = tmpRow;
            }
            return true;
        }

        @Override
        public void reset() {
            this.index = -1L;
            this.current = null;
        }

        @Override
        public long getIndex() {
            return this.index;
        }

        @Override
        public Object current() {
            return this.current;
        }

        @Override
        public void release() {
            this.row = null;
        }
    }
}

