/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.resultsets.caching;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.ResultSetValue;
import com.cognos.xqe.data.values.RowValue;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.query.engine.TransformationEngine;
import com.cognos.xqe.resultset.interfaces.IRowsetInfo;
import com.cognos.xqe.resultset.interfaces.IScrollableIterator;
import com.cognos.xqe.resultset.interfaces.ITabularIterator;
import com.cognos.xqe.resultset.interfaces.ITabularResultSet;
import com.cognos.xqe.runtree.ScrollableIterator;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.XTabularIterator;
import com.cognos.xqe.util.io.BufferedDataInputStream;
import com.cognos.xqe.util.io.BufferedDataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;

public final class SimpleTabularCache
extends ResultSetValue
implements ITabularResultSet {
    public static final long serialVersionUID = -1L;
    private ITabularIterator tableIt;
    private File tempFile;
    private IRowsetInfo rowsetInfo;

    private SimpleTabularCache(XDataContext context, IRowsetInfo theRowsetInfo, ITabularIterator tabIt) {
        super(context, TransformationEngine.DUMMY_NODEID, context.getEnvironment().getMultiRequestContext().getResourceTracker());
        try {
            this.rowsetInfo = theRowsetInfo;
            this.tableIt = tabIt;
            XQEConfiguration configuration = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
            String fName = configuration.getXqeTempDirectory() + File.separator + this.tableIt.toString() + ".cache";
            this.tempFile = new File(fName);
            this.tempFile.delete();
            BufferedDataOutputStream outputStream = null;
            try {
                outputStream = new BufferedDataOutputStream(this.tempFile);
            }
            catch (FileNotFoundException e) {
                throw new XQERuntimeException(e);
            }
            try {
                RowValue row;
                while ((row = (RowValue)this.tableIt.next()) != null) {
                    row.encode(context, outputStream);
                }
                outputStream.flush();
                outputStream.close();
            }
            catch (IOException e) {
                throw new XQERuntimeException(e);
            }
        }
        catch (RuntimeException e) {
            this.release();
            throw e;
        }
    }

    public static SimpleTabularCache decorate(XDataContext context, IRowsetInfo theRowsetInfo, ITabularIterator tabIt) {
        return new SimpleTabularCache(context, theRowsetInfo, tabIt);
    }

    @Override
    public IRowsetInfo getTabularRowsetInfo() {
        return this.rowsetInfo;
    }

    @Override
    public ITabularIterator getTabularIterator() {
        return new SimpleTabularCacheIterator();
    }

    @Override
    public IScrollableIterator getScrollableTabularIterator() {
        return new ScrollableIterator(this.getDataContext(), this.getTabularIterator(), TransformationEngine.DUMMY_NODEID);
    }

    @Override
    public void releaseImpl() {
        if (this.tableIt != null) {
            this.tableIt.release();
            this.tableIt = null;
        }
        if (this.tempFile != null) {
            this.tempFile.delete();
            this.tempFile = null;
        }
    }

    @Override
    public boolean isVectorized() {
        return false;
    }

    private class SimpleTabularCacheIterator
    extends XTabularIterator {
        private BufferedDataInputStream inputStream;
        private IRowsetInfo rowsetInfo;
        private long index;
        private RowValue result;

        SimpleTabularCacheIterator() {
            super(null, TransformationEngine.DUMMY_NODEID);
            this.index = -1L;
            this.result = DataValueFactory.createRowValue(this.context.getLocalCollator(), this.rowsetInfo);
            try {
                this.inputStream = new BufferedDataInputStream(SimpleTabularCache.this.tempFile);
            }
            catch (IOException e) {
                throw new XQERuntimeException(e);
            }
        }

        @Override
        public Object nextImpl() {
            try {
                this.result.decode(this.context, this.inputStream);
            }
            catch (IOException e) {
                throw new XQERuntimeException(e);
            }
            ++this.index;
            return this.result;
        }

        @Override
        public void reset() {
            this.index = -1L;
            try {
                this.inputStream.seek(0L);
            }
            catch (IOException e) {
                throw new XQERuntimeException(e);
            }
        }

        @Override
        public long getIndex() {
            return this.index;
        }

        @Override
        public void release() {
            try {
                this.inputStream.close();
            }
            catch (IOException e) {
                mErrorLogger.log(e);
                this.inputStream = null;
            }
            this.inputStream = null;
        }
    }
}

