/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.resultsets.md;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.IRow;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.resultset.interfaces.ITuple;
import com.cognos.xqe.runtree.XIterator;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;

public class TabularAxisIterator
extends XIterator {
    private XIterator sourceAxisIterator;
    private IRow aRow;
    private IValue[] values;
    private static XQELogger mErrorLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Exception", LogLevel.ERROR);

    public TabularAxisIterator(XIterator axisIterator, Integer id) {
        super(axisIterator.getDataContext(), id);
        this.sourceAxisIterator = axisIterator;
    }

    @Override
    public Object nextImpl() {
        ITuple aTuple = (ITuple)this.sourceAxisIterator.next();
        if (aTuple == null) {
            return null;
        }
        IMember[] members = aTuple.getMembers();
        if (this.values == null) {
            this.values = new IValue[members.length];
            this.aRow = DataValueFactory.createRowValue(this.values);
        }
        System.arraycopy(members, 0, this.values, 0, members.length);
        return this.aRow;
    }

    @Override
    public void release() {
        if (this.sourceAxisIterator != null) {
            try {
                this.sourceAxisIterator.release();
            }
            catch (Exception ex) {
                mErrorLogger.log(ex);
            }
            finally {
                this.sourceAxisIterator = null;
            }
        }
    }
}

