/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.resultsets.ndm;

import com.cognos.xqe.data.DataSubType;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.types.MemberType;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.DecimalValue;
import com.cognos.xqe.data.values.DoubleValue;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.NVarcharValue;
import com.cognos.xqe.data.values.NullValue;
import com.cognos.xqe.data.values.TimestampValue;
import com.cognos.xqe.format.FormatId;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMeasure;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.MetadataType;
import com.cognos.xqe.metadata.provider.Member;
import com.cognos.xqe.metadata.wrapper.HierarchyWrapper;
import com.cognos.xqe.metadata.wrapper.LevelWrapper;
import com.cognos.xqe.metadata.wrapper.MeasureWrapper;
import com.cognos.xqe.resultsets.ContextBase;
import com.cognos.xqe.resultsets.ContextMember;
import com.cognos.xqe.resultsets.ContextValue;
import com.cognos.xqe.rsapi.RSAPIDataItem;
import com.cognos.xqe.rsapi.RSAPIDataset;
import com.cognos.xqe.rsapi.RSAPIEdge;
import com.cognos.xqe.rsapi.RSAPIEdgeRowset;
import com.cognos.xqe.rsapi.RSAPIUsage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public class NoDataModeRowSet {
    private static final int ROWS_NUMBER_IN_DETAIL_ROWSET = 3;
    private static final int ROWS_NUMBER_IN_GROUPING_ROWSET = 2;
    private static final int NDM_NUMERIC_VALUE = 1234;
    private static final int NDM_NUMERIC_ANOTHER_VALUE = 12345;
    private static final String NDM_STRING_VALUE = "abcd";
    private static final String NDM_STRING_ANOTHER_VALUE = "abcde";
    private static final long NDM_DATETIME_VALUE = 1290020465000L;
    private static final long NDM_DATETIME_ANOTHER_VALUE = 1290020468000L;
    private final RSAPIEdge edge;
    final int iEdgeOrdinal;
    private final String[] munSufficses = new String[]{"0001", "0002"};
    private List<List<IValue>> rows = new ArrayList<List<IValue>>();
    private final ListIterator<List<IValue>> iterator;
    private Map<RSAPIEdgeRowset, Integer> groupingRowsetsIndexes = new HashMap<RSAPIEdgeRowset, Integer>();

    public NoDataModeRowSet(RSAPIDataset dataset, int axisPositionalOrdinal) {
        this.edge = dataset.getEdge(axisPositionalOrdinal);
        this.iEdgeOrdinal = this.edge.getOrdinal();
        RSAPIEdgeRowset rootRowset = this.edge.getRootRowset();
        this.fakeRowset(rootRowset, 3);
        this.iterator = this.rows.listIterator();
    }

    public void close() {
    }

    public List<IValue> next() {
        if (this.iterator.hasNext()) {
            return this.iterator.next();
        }
        return new ArrayList<IValue>();
    }

    private ContextValue createContextValue(int diIndex, IValue value, RSAPIEdgeRowset rowset) {
        ContextValue aValue = new ContextValue(value);
        aValue.setRowset(rowset);
        aValue.setDataItemIndex(diIndex);
        return aValue;
    }

    private ContextMember createContextMember(Member aMember, int diIndex, RSAPIEdgeRowset rowset) {
        ContextMember aContextMember = new ContextMember();
        aContextMember.setMember(aMember);
        aContextMember.setEdgeOrdinal(this.iEdgeOrdinal);
        aContextMember.setQueryCalculation(false);
        aContextMember.setSummary(false);
        aContextMember.setRowset(rowset);
        aContextMember.setDataItemIndex(diIndex);
        return aContextMember;
    }

    private ILevel getLevelInformation(IMetadata metadata) {
        if (null == metadata) {
            return null;
        }
        ILevel level = null;
        if (metadata instanceof ILevel) {
            level = (ILevel)metadata;
        } else if (metadata instanceof IHierarchy) {
            level = ((IHierarchy)metadata).getLevel(0);
        } else if (metadata instanceof IMeasure) {
            level = ((IMeasure)metadata).getLevel();
        } else if (metadata instanceof IMember) {
            level = ((IMember)metadata).getLevel();
        } else if (metadata instanceof HierarchyWrapper) {
            level = ((HierarchyWrapper)metadata).getLevel(0);
        } else if (metadata instanceof LevelWrapper) {
            level = ((LevelWrapper)metadata).getWrappedLevel();
        } else if (metadata instanceof MeasureWrapper) {
            level = ((MeasureWrapper)metadata).getLevel();
        }
        return level;
    }

    private ContextValue createContextValueForMeasure(IMetadata metadata, ILevel level, int diIndex, RSAPIEdgeRowset rowset) {
        DoubleValue value = DataValueFactory.createDoubleValue();
        value.set(1234);
        ContextValue aValue = this.createContextValue(diIndex, value, rowset);
        return aValue;
    }

    private ContextValue createTabularContextValue(RSAPIDataItem dataItem, int diIndex, RSAPIEdgeRowset rowset, int index) {
        IDataType dataType = dataItem.getDataType();
        IValue value = null;
        if (dataType.getSubType() == DataSubType.TEXTTYPE) {
            value = this.createNVarcharValue(index);
        } else if (dataType.getSubType() == DataSubType.NUMERICTYPE) {
            value = this.createDecimalValue(index);
        } else if (dataType.getSubType() == DataSubType.DATETIMETYPE) {
            value = this.createTimestampValue(index);
        } else {
            FormatId formatId = dataItem.getFormatId();
            if (formatId != null) {
                if (formatId.equals(FormatId.STRING_FORMAT_FID)) {
                    value = this.createNVarcharValue(index);
                } else if (formatId.equals(FormatId.NUMBER_FORMAT_FID)) {
                    value = this.createDecimalValue(index);
                } else if (formatId.equals(FormatId.DATETIME_FORMAT_FID)) {
                    value = this.createTimestampValue(index);
                } else {
                    NullValue nullValue = DataValueFactory.createNullValue();
                    value = nullValue;
                }
            } else {
                NullValue nullValue = DataValueFactory.createNullValue();
                value = nullValue;
            }
        }
        return this.createContextValue(diIndex, value, rowset);
    }

    public IValue createTimestampValue(int index) {
        TimestampValue timestampValue = DataValueFactory.createTimestampValue();
        if (index > 0) {
            timestampValue.set(1290020468000L);
        } else {
            timestampValue.set(1290020465000L);
        }
        TimestampValue value = timestampValue;
        return value;
    }

    public IValue createDecimalValue(int index) {
        DecimalValue decimalValue = DataValueFactory.createDecimalValue();
        if (index > 0) {
            decimalValue.set(12345);
        } else {
            decimalValue.set(1234);
        }
        DecimalValue value = decimalValue;
        return value;
    }

    public IValue createNVarcharValue(int index) {
        NVarcharValue nvarcharValue = DataValueFactory.createNVarcharValue();
        if (index > 0) {
            nvarcharValue.set(NDM_STRING_ANOTHER_VALUE);
        } else {
            nvarcharValue.set(NDM_STRING_VALUE);
        }
        NVarcharValue value = nvarcharValue;
        return value;
    }

    private void createContextMemberForGroupingRowset(ContextMember contextMember) {
        IDataType dataType;
        IMetadata metadata;
        ILevel level;
        RSAPIDataItem dataitem;
        RSAPIEdgeRowset parent;
        ContextMember aContextMember = null;
        if (null != contextMember.getRowset() && null != (parent = ((RSAPIEdgeRowset)contextMember.getRowset()).getParentRowset()) && null != (dataitem = parent.getRefDataItem()) && null != (level = this.getLevelInformation(metadata = dataitem.getModelReference())) && (dataType = metadata.getDataType()) == DataTypeFactory.getLevelType()) {
            Member aMember = new Member(NDM_STRING_VALUE);
            aMember.setLevel(level);
            aContextMember = this.createContextMember(aMember, -1, parent);
            contextMember.setContextMember(aContextMember);
            this.createContextMemberForGroupingRowset(aContextMember);
        }
    }

    private void fakeRowset(RSAPIEdgeRowset rowset, int rowCount) {
        if (rowset.isDetailRowset()) {
            RSAPIDataItem dataItem;
            if (rowset.isMeasureRowset() && DataSubType.NUMERICTYPE == (dataItem = rowset.getRefDataItem()).getDataType().getSubType()) {
                rowCount = 1;
            }
            for (int i = 0; i < rowCount; ++i) {
                List<IValue> values = this.fakeRowValues4DetailRowset(rowset);
                this.rows.add(values);
            }
            if (null != rowset.getFooterRowset()) {
                List<IValue> values = this.fakeRowValues4DetailRowset(rowset.getFooterRowset());
                this.rows.add(values);
            }
            if (null != rowset.getSiblingRowset()) {
                this.fakeRowset(rowset.getSiblingRowset(), 1);
            }
            return;
        }
        rowCount = 2;
        if (rowset.getNestedRowset().isEmptyNestedUnder(rowset)) {
            this.fakeRowValues4EmptyValueSets(rowset, rowCount);
        } else {
            for (int i = 0; i < rowCount; ++i) {
                this.groupingRowsetsIndexes.put(rowset, i);
                this.fakeRowset(rowset.getNestedRowset(), 3);
            }
        }
        if (null != rowset.getFooterRowset()) {
            this.groupingRowsetsIndexes.put(rowset, 1);
            List<IValue> values = this.fakeRowValues4DetailRowset(rowset.getFooterRowset());
            this.rows.add(values);
        }
        if (null != rowset.getSiblingRowset()) {
            this.fakeRowset(rowset.getSiblingRowset(), 1);
        }
    }

    private List<IValue> fakeRowValues4DetailRowset(RSAPIEdgeRowset rowset) {
        IValue value;
        ArrayList<IValue> values = new ArrayList<IValue>();
        RSAPIDataItem[] dataItems = rowset.getDataItems();
        if (dataItems.length > 0) {
            for (int diIndex = 0; diIndex < dataItems.length; ++diIndex) {
                value = this.createDataItemValue(dataItems[diIndex], diIndex, rowset, -1);
                values.add(value);
            }
        } else {
            RSAPIDataItem dataItem = rowset.getRefDataItem();
            if (null != dataItem) {
                value = this.createDataItemValue(dataItem, -1, rowset, -1);
                values.add(value);
            } else {
                this.createDataItemValuesForEmptyRowset(rowset, values);
            }
        }
        RSAPIEdgeRowset groupingRowset = rowset.getGroupingRowset();
        if (null != groupingRowset && !groupingRowset.isDetailRowset()) {
            this.addContextMemberForGroupingRowset(values, groupingRowset);
            rowset = groupingRowset;
        }
        while (null != rowset.getParentRowset()) {
            if ((rowset = rowset.getParentRowset()).isDetailRowset()) continue;
            this.addContextMemberForGroupingRowset(values, rowset);
        }
        return values;
    }

    private void fakeRowValues4EmptyValueSets(RSAPIEdgeRowset rowset, int rowCount) {
        for (int i = 0; i < rowCount; ++i) {
            this.groupingRowsetsIndexes.put(rowset, i);
            List<IValue> nestedRowsetValues = this.fakeRowValues4DetailRowset(rowset.getNestedRowset());
            this.rows.add(nestedRowsetValues);
            RSAPIEdgeRowset headerRowset = rowset.getNestedRowset().getHeaderRowset();
            if (null == headerRowset) continue;
            List<IValue> headerRowsetValues = this.fakeRowValues4DetailRowset(headerRowset);
            this.rows.add(headerRowsetValues);
        }
    }

    private void addContextMemberForGroupingRowset(List<IValue> values, RSAPIEdgeRowset groupingRowset) {
        ContextMember aContextMember = null;
        RSAPIDataItem dataitem = groupingRowset.getRefDataItem();
        IMetadata metadata = dataitem.getModelReference();
        ILevel level = this.getLevelInformation(metadata);
        int iMunSuffics = this.groupingRowsetsIndexes.get(groupingRowset);
        if (null != level) {
            dataitem.setDataType(MemberType.MEMBERTYPE);
            IDataType dataType = metadata.getDataType();
            if (dataType == DataTypeFactory.getLevelType()) {
                Member aMember = new Member(NDM_STRING_VALUE);
                aMember.setUniqueName(NDM_STRING_VALUE + this.munSufficses[iMunSuffics]);
                aMember.setLevel(level);
                aContextMember = this.createContextMember(aMember, -1, groupingRowset);
                this.createContextMemberForGroupingRowset(aContextMember);
                values.add(0, aContextMember);
            }
        } else {
            IValue value = this.createDataItemValue(dataitem, -1, groupingRowset, iMunSuffics);
            values.add(0, value);
        }
    }

    private IValue createDataItemValue(RSAPIDataItem dataItem, int diIndex, RSAPIEdgeRowset rowset, int index) {
        IMetadata metadata = dataItem.getModelReference();
        ILevel level = this.getLevelInformation(metadata);
        if (null == level) {
            if (metadata != null && dataItem.getUsage() == RSAPIUsage.FACT && rowset.getEdge().getOrdinal() > 0) {
                NVarcharValue nvarcharValue = DataValueFactory.createNVarcharValue();
                nvarcharValue.set(dataItem.getName());
                return this.createContextValue(diIndex, nvarcharValue, rowset);
            }
            ContextValue aValue = this.createTabularContextValue(dataItem, diIndex, rowset, index);
            return aValue;
        }
        RSAPIUsage usage = dataItem.getUsage();
        if (usage == RSAPIUsage.FACT) {
            if (rowset.getEdge().getOrdinal() > 0) {
                return this.createContextMemberForCellEdge(dataItem, metadata, level, diIndex, rowset);
            }
            return this.createContextValueForMeasure(metadata, level, diIndex, rowset);
        }
        Member aMember = new Member(NDM_STRING_VALUE);
        aMember.setLevel(level);
        ContextMember aContextMember = this.createContextMember(aMember, diIndex, rowset);
        return aContextMember;
    }

    private void createDataItemValuesForEmptyRowset(RSAPIEdgeRowset rowset, List<IValue> values) {
        RSAPIDataItem[] dataItems = null;
        RSAPIEdgeRowset groupingRowset = rowset.getGroupingRowset();
        if (groupingRowset != null && groupingRowset.getRefDataItem() != null) {
            dataItems = groupingRowset.getDataItems();
            if (0 == dataItems.length) {
                dataItems = new RSAPIDataItem[]{groupingRowset.getRefDataItem()};
            }
        } else if (rowset.getParentRowset() != null && 0 == (dataItems = rowset.getParentRowset().getDataItems()).length) {
            dataItems = new RSAPIDataItem[]{rowset.getParentRowset().getRefDataItem()};
        }
        for (RSAPIDataItem di : dataItems) {
            IMetadata metadata = di.getModelReference();
            if (metadata != null && this.isMeasure(metadata)) {
                ILevel level = this.getLevelInformation(metadata);
                ContextValue value = this.createContextValueForMeasure(metadata, level, -2, rowset);
                values.add(value);
                continue;
            }
            IValue value = this.createDataItemValue(di, -2, rowset, -1);
            if (((ContextBase)((Object)value)).contextIsAMember()) {
                ((ContextMember)value).setQueryCalculation(true);
                ((ContextMember)value).setSummary(true);
            }
            values.add(value);
        }
    }

    private boolean isMeasure(IMetadata metadata) {
        boolean bMeasure = false;
        MetadataType metadataType = metadata.getObjectType();
        bMeasure = MetadataType.LEVEL == metadataType ? MetadataType.isMeasureDimension(((ILevel)metadata).getDimension()) : MetadataType.isMeasure(metadata);
        return bMeasure;
    }

    public long getRowCount() {
        return this.rows.size();
    }

    private ContextMember createContextMemberForCellEdge(RSAPIDataItem dataItem, IMetadata metadata, ILevel level, int diIndex, RSAPIEdgeRowset rowset) {
        Member aMember = RSAPIUsage.IDENTIFIER == dataItem.getUsage() ? new Member(NDM_STRING_VALUE) : new Member(dataItem.getName());
        aMember.setUniqueName(metadata.getUniqueName());
        aMember.setLevel(level);
        return this.createContextMember(aMember, diIndex, rowset);
    }

    public int getEdgeOrdinal() {
        return this.iEdgeOrdinal;
    }
}

