/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.resultsets.tabular;

import com.cognos.xqe.ast.XQEPersistContext;
import com.cognos.xqe.ast.XQERestoreContext;
import com.cognos.xqe.data.DataSubType;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.types.MemberType;
import com.cognos.xqe.resultset.interfaces.IColumnInfo;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.transformation.relational.binding.SQLQueryItem;
import com.cognos.xqe.transformation.relational.binding.SQLQueryItemList;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.text.Normalizer;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.dom4j.Attribute;
import org.dom4j.Element;

public class ColumnInfo
implements IColumnInfo,
Serializable {
    public static final String STRING_PROPERTY_NAME = "name";
    public static final String STRING_PROPERTY_DATATYPE = "dataType";
    public static final String STRING_PROPERTY_NULLSOK = "nullsOk";
    public static final String STRING_PROPERTY_HIDDEN = "hidden";
    public static final String STRING_PROPERTY_UNIQUE = "unique";
    public static final String STRING_PROPERTY_ISSORTED = "isSorted";
    private static final long serialVersionUID = 1L;
    protected String name;
    protected IDataType dataType;
    protected boolean nullsOk;
    protected boolean hidden;
    protected boolean unique;
    protected boolean isSorted;
    protected Normalizer.Form nf;
    private ColumnInfo[] attributes;

    public ColumnInfo() {
    }

    public ColumnInfo(String theName, IDataType theDataType) {
        this(theName, theDataType, false);
    }

    public ColumnInfo(String theName, IDataType theDataType, boolean sorted) {
        this.name = theName;
        this.dataType = theDataType;
        this.isSorted = sorted;
        this.nullsOk = true;
    }

    public ColumnInfo(SQLQueryItem qItem) {
        this(qItem.getName(), qItem.getDataType());
        SQLQueryItemList qItemAttributes = qItem.getAttributeList();
        if (qItemAttributes != null) {
            this.attributes = new ColumnInfo[qItemAttributes.size()];
            for (int i = 0; i < this.attributes.length; ++i) {
                this.attributes[i] = new ColumnInfo((SQLQueryItem)qItemAttributes.get(i));
            }
        }
    }

    public ColumnInfo[] getAttributes() {
        return this.attributes;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String theColumnName) {
        this.name = theColumnName;
    }

    @Override
    public String getLabel() {
        return this.getName();
    }

    @Override
    public boolean isNullable() {
        return this.nullsOk;
    }

    @Override
    public void setNullable(boolean isNullable) {
        this.nullsOk = isNullable;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean isHidden) {
        this.hidden = isHidden;
    }

    public boolean isUnique() {
        return this.unique;
    }

    public void setUnique(boolean isUnique) {
        this.unique = isUnique;
    }

    @Override
    public boolean isDimension() {
        return this.dataType == MemberType.MEMBERTYPE;
    }

    @Override
    public boolean isMeasure() {
        return false;
    }

    @Override
    public boolean isString() {
        return this.dataType.getSubType() == DataSubType.TEXTTYPE;
    }

    @Override
    public boolean isNumeric() {
        return this.dataType.getSubType() == DataSubType.NUMERICTYPE;
    }

    @Override
    public boolean isSorted() {
        return this.isSorted;
    }

    @Override
    public void setDataType(IDataType aDataType) {
        this.dataType = aDataType;
    }

    @Override
    public IDataType getDataType() {
        return this.dataType;
    }

    @Override
    public ColumnInfo copy() {
        return new ColumnInfo(this.name, this.dataType);
    }

    @Override
    public void encode(XDataContext context, DataOutput oStream) throws IOException {
        oStream.writeUTF(this.name);
        byte cclDType = this.dataType.getCCLTypeCode();
        oStream.writeByte(cclDType);
    }

    @Override
    public void decode(XDataContext context, DataInput iStream) throws IOException {
        this.name = iStream.readUTF();
        byte cclDType = iStream.readByte();
        this.dataType = DataTypeFactory.getDataType(cclDType);
    }

    @Override
    public int sizeOf() {
        return 0;
    }

    @Override
    public void persist(XQEPersistContext ctx, String optionalName) {
        if (ctx.beginElement(this, optionalName, -1)) {
            this.persistAttributeProperties(ctx);
            this.persistElementProperties(ctx);
            ctx.endElement();
        }
    }

    protected void persistAttributeProperties(XQEPersistContext ctx) {
        if (this.name != null) {
            ctx.property(STRING_PROPERTY_NAME, this.name);
        }
        if (this.dataType != null) {
            ctx.property(STRING_PROPERTY_DATATYPE, this.dataType);
        }
        ctx.property(STRING_PROPERTY_NULLSOK, this.nullsOk);
        ctx.property(STRING_PROPERTY_HIDDEN, this.hidden);
        ctx.property(STRING_PROPERTY_UNIQUE, this.unique);
        ctx.property(STRING_PROPERTY_ISSORTED, this.isSorted);
    }

    protected void persistElementProperties(XQEPersistContext ctx) {
    }

    @Override
    public void restore(XQERestoreContext ctx, Element node) {
        this.restoreAttributes(ctx, node);
        this.restoreChildren(ctx, node);
    }

    public void restoreAttributes(XQERestoreContext ctx, Element node) {
        int size = node.attributeCount();
        for (int i = 0; i < size; ++i) {
            Attribute att = node.attribute(i);
            this.restoreAttributeProperty(ctx, att, node);
        }
    }

    protected void restoreChildren(XQERestoreContext ctx, Element node) {
        List childList = node.elements();
        int nChildren = childList.size();
        for (int i = 0; i < nChildren; ++i) {
            Element child = (Element)childList.get(i);
            if (child.getNamespace().getURI().isEmpty()) continue;
            this.restoreElementProperty(ctx, child, node);
        }
    }

    protected void restoreElementProperty(XQERestoreContext ctx, Element node, Element inputNode) {
    }

    protected void restoreAttributeProperty(XQERestoreContext ctx, Attribute att, Element node) {
        String attName = att.getName();
        if (attName.equals(STRING_PROPERTY_NAME)) {
            Object val = ctx.attributeValue(att);
            this.name = (String)val;
        } else if (attName.equals(STRING_PROPERTY_DATATYPE)) {
            Object val = ctx.attributeValue(att);
            this.dataType = (IDataType)val;
        } else if (attName.equals(STRING_PROPERTY_NULLSOK)) {
            Object val = ctx.attributeValue(att);
            this.nullsOk = (Boolean)val;
        } else if (attName.equals(STRING_PROPERTY_HIDDEN)) {
            Object val = ctx.attributeValue(att);
            this.hidden = (Boolean)val;
        } else if (attName.equals(STRING_PROPERTY_UNIQUE)) {
            Object val = ctx.attributeValue(att);
            this.unique = (Boolean)val;
        } else if (attName.equals(STRING_PROPERTY_ISSORTED)) {
            Object val = ctx.attributeValue(att);
            this.isSorted = (Boolean)val;
        }
    }

    @Override
    public boolean isNormalized() {
        return this.nf != null;
    }

    @Override
    public void setNormalizationForm(Normalizer.Form form) {
        this.nf = form;
    }

    @Override
    public Normalizer.Form getNormalizationForm() {
        return this.nf;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }
}

