/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.resultsets.tabular;

import com.cognos.xqe.ast.sql.SQLSortKey;
import com.cognos.xqe.data.ValueComparator;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.MemberStringPropertyValue;
import com.cognos.xqe.data.values.RowValue;
import com.cognos.xqe.data.values.TextValue;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.resultset.interfaces.IColumnInfo;
import com.cognos.xqe.resultset.interfaces.IRowsetInfo;
import com.cognos.xqe.resultsets.ContextMember;
import com.cognos.xqe.resultsets.tabular.DimensionColumnInfo;
import com.cognos.xqe.resultsets.tabular.OrderBy;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRMemberProxy;
import com.ibm.icu.text.Collator;

public class RowComparator
extends ValueComparator {
    private final OrderBy[] sorts;
    private final IRowsetInfo rowsetInfo;
    private Collator collator = null;
    private boolean sortMemberByCaption = true;

    public RowComparator(IRowsetInfo pRowsetInfo, OrderBy[] pSorts) {
        this.sorts = pSorts;
        this.rowsetInfo = pRowsetInfo;
    }

    public RowComparator(IRowsetInfo pRowsetInfo, OrderBy[] pSorts, Collator pCollator, boolean pSortMemberByCaption) {
        this.sorts = pSorts;
        this.rowsetInfo = pRowsetInfo;
        this.collator = pCollator;
        this.sortMemberByCaption = pSortMemberByCaption;
    }

    @Override
    public int compare(IValue o1, IValue o2) {
        RowValue r1 = (RowValue)o1;
        RowValue r2 = (RowValue)o2;
        int result = 0;
        for (int i = 0; i < this.sorts.length && result == 0; ++i) {
            String c2;
            String c1;
            OrderBy orderBy = this.sorts[i];
            int position = orderBy.getPosition();
            IColumnInfo columnInfo = this.rowsetInfo.getColumnInfo(position);
            if (columnInfo instanceof DimensionColumnInfo) {
                ILevel l = orderBy.getLevel((DimensionColumnInfo)columnInfo);
                IMember m1 = (IMember)r1.getColumn(position);
                IMember m2 = (IMember)r2.getColumn(position);
                if (l != null) {
                    while (m1 != null && m1.getLevel() != l) {
                        if (m1.isContextMember()) {
                            m1 = ((ContextMember)m1).getContextMember();
                            continue;
                        }
                        m1 = m1.getParent();
                    }
                    while (m2 != null && m2.getLevel() != l) {
                        if (m2.isContextMember()) {
                            m2 = ((ContextMember)m2).getContextMember();
                            continue;
                        }
                        m2 = m2.getParent();
                    }
                }
                if (m1 != null && m2 != null) {
                    result = this.collator != null ? this.collator.compare(m1.getName(), m2.getName()) : m1.getName().compareTo(m2.getName());
                }
                if (orderBy.isAscending()) continue;
                result *= -1;
                continue;
            }
            IValue v1 = r1.getColumn(position);
            IValue v2 = r2.getColumn(position);
            if (v1.isNull() && v2.isNull()) {
                result = 0;
                continue;
            }
            if (v1.isNull()) {
                if (orderBy.getNullOrdering() == SQLSortKey.NullOrdering.NULLS_FIRST) {
                    result = -1;
                    continue;
                }
                result = 1;
                continue;
            }
            if (v2.isNull()) {
                if (orderBy.getNullOrdering() == SQLSortKey.NullOrdering.NULLS_FIRST) {
                    result = 1;
                    continue;
                }
                result = -1;
                continue;
            }
            if (v1 instanceof IMember) {
                c1 = null;
                c2 = null;
                if (this.sortMemberByCaption) {
                    c1 = ((IMember)v1).getCaptionValue().getString();
                    c2 = ((IMember)v2).getCaptionValue().getString();
                } else {
                    c1 = ((IMember)v1).getUniqueName();
                    c2 = ((IMember)v2).getUniqueName();
                }
                result = this.collator != null ? this.collator.compare(c1, c2) : c1.compareTo(c2);
            } else if (v1 instanceof MemberStringPropertyValue && ((MemberStringPropertyValue)v1).getMember() instanceof DMRMemberProxy) {
                c1 = ((MemberStringPropertyValue)v1).getMember().getCaptionValue().getString();
                c2 = ((MemberStringPropertyValue)v2).getMember().getCaptionValue().getString();
                result = this.collator != null ? this.collator.compare(c1, c2) : c1.compareTo(c2);
            } else {
                result = v1 instanceof TextValue && v2 instanceof TextValue ? (this.collator != null ? ((TextValue)v1).compareTo((Object)v2, this.collator) : v1.compareTo(v2)) : v1.compareTo(v2);
            }
            if (orderBy.isAscending()) continue;
            result *= -1;
        }
        return result;
    }

    public OrderBy[] getSorts() {
        return this.sorts;
    }

    public Collator getCollator() {
        return this.collator;
    }
}

