/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.resultsets.tabular;

import com.cognos.xqe.ast.XQEPersistContext;
import com.cognos.xqe.ast.XQERestoreContext;
import com.cognos.xqe.data.DataType;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.types.RowType;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.resultset.interfaces.IColumnInfo;
import com.cognos.xqe.resultset.interfaces.IRowsetInfo;
import com.cognos.xqe.resultsets.tabular.ColumnInfo;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.util.xml.XMLWriter;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.dom4j.Element;

public class RowsetInfo
implements IRowsetInfo,
Serializable {
    private static final int ONE_HUNDRED = 100;
    private static final long serialVersionUID = 1L;
    private static final String ELEMENT_ROWSETINFO = "RowsetInfo";
    private static final String ELEMENT_COLUMNINFO = "ColumnInfo";
    private static final String ATTRIBUTE_DATATYPE = "dataType";
    private static final String ATTRIBUTE_NAME = "name";
    private static final String STRING_COLUMN_DESCRIPTORS = "columnDescriptors";
    private ArrayList<IColumnInfo> columnDescriptors = new ArrayList();

    @Override
    public void add(IRowsetInfo rowsetInfo) {
        for (int i = 0; i < rowsetInfo.getNumColumns(); ++i) {
            this.columnDescriptors.add(rowsetInfo.getColumnInfo(i));
        }
    }

    @Override
    public void addColumnInfo(IColumnInfo columnInfo) {
        this.columnDescriptors.add(columnInfo);
    }

    @Override
    public IRowsetInfo copy() {
        RowsetInfo rowsetInfo = new RowsetInfo();
        for (int i = 0; i < this.getNumColumns(); ++i) {
            rowsetInfo.addColumnInfo(this.getColumnInfo(i).copy());
        }
        return rowsetInfo;
    }

    @Override
    public void copyFrom(IRowsetInfo rowsetInfo) {
        for (int i = 0; i < rowsetInfo.getNumColumns(); ++i) {
            this.columnDescriptors.add(rowsetInfo.getColumnInfo(i).copy());
        }
    }

    public int indexOf(IColumnInfo columnInfo) {
        return this.columnDescriptors.indexOf(columnInfo);
    }

    public Iterator<IColumnInfo> iterator() {
        return this.columnDescriptors.iterator();
    }

    @Override
    public IColumnInfo getColumnInfo(int index) {
        return this.columnDescriptors.get(index);
    }

    @Override
    public IColumnInfo[] getColumnInfos() {
        return this.columnDescriptors.toArray(new IColumnInfo[this.columnDescriptors.size()]);
    }

    @Override
    public int getNumColumns() {
        return this.columnDescriptors.size();
    }

    public void dumpExtraInfo(XQETrace trace) {
        this.dumpFormattedXMLResult(trace);
    }

    @Override
    public void dumpFormattedXMLResult(XMLWriter xmlWriter) {
        xmlWriter.beginElement(ELEMENT_ROWSETINFO, -1);
        for (int i = 0; i < this.getNumColumns(); ++i) {
            IColumnInfo columnInfo = this.getColumnInfo(i);
            xmlWriter.beginElement(ELEMENT_COLUMNINFO, -1);
            xmlWriter.attribute(ATTRIBUTE_DATATYPE, columnInfo.getDataType());
            xmlWriter.attribute(ATTRIBUTE_NAME, columnInfo.getName());
            xmlWriter.endElement();
        }
        xmlWriter.endElement();
    }

    public void capture(PlanningEnvironment env, Element inputNode) {
        List columnInfoList = inputNode.elements();
        for (int i = 0; i < columnInfoList.size(); ++i) {
            Element child = (Element)columnInfoList.get(i);
            IDataType dataType = DataTypeFactory.getType(child.attributeValue(ATTRIBUTE_DATATYPE));
            String name = child.attributeValue(ATTRIBUTE_NAME);
            this.addColumnInfo(new ColumnInfo(name, dataType));
        }
    }

    @Override
    public DataType getDataType() {
        RowType dType = DataTypeFactory.getRowType();
        for (IColumnInfo columnInfo : this.getColumnInfos()) {
            dType.addField(columnInfo.getName(), columnInfo.getDataType());
        }
        return dType;
    }

    public int getRowLength() {
        int length = 0;
        for (IColumnInfo columnInfo : this.getColumnInfos()) {
            length += columnInfo.getDataType().getLength();
        }
        return length;
    }

    public int getRowLengthNoDefault() {
        int length = 0;
        for (IColumnInfo columnInfo : this.getColumnInfos()) {
            int colLength = columnInfo.getDataType().getLength();
            if (colLength == -1) {
                colLength = 100;
            }
            length += colLength;
        }
        return length;
    }

    @Override
    public void setNormalizationForm(Normalizer.Form nf) {
        if (nf == null) {
            return;
        }
        for (IColumnInfo columnInfo : this.columnDescriptors) {
            if (!columnInfo.getDataType().isTextType()) continue;
            columnInfo.setNormalizationForm(nf);
        }
    }

    public String toString() {
        StringBuilder sBuilder = new StringBuilder();
        sBuilder.append("ROW(");
        int i = 0;
        for (IColumnInfo columnInfo : this.columnDescriptors) {
            if (i++ > 0) {
                sBuilder.append(", ");
            }
            sBuilder.append(columnInfo.getName());
            sBuilder.append(" ");
            sBuilder.append(columnInfo.getDataType());
        }
        sBuilder.append(")");
        return sBuilder.toString();
    }

    @Override
    public void encode(XDataContext context, DataOutput oStream) throws IOException {
        oStream.writeInt(this.columnDescriptors.size());
        for (IColumnInfo columnInfo : this.columnDescriptors) {
            columnInfo.encode(context, oStream);
        }
    }

    @Override
    public void decode(XDataContext context, DataInput iStream) throws IOException {
        int nColumnDescriptors = iStream.readInt();
        this.columnDescriptors = new ArrayList(nColumnDescriptors);
        for (int i = 0; i < nColumnDescriptors; ++i) {
            ColumnInfo columnInfo = new ColumnInfo();
            columnInfo.decode(context, iStream);
            this.columnDescriptors.add(columnInfo);
        }
    }

    @Override
    public int sizeOf() {
        return 0;
    }

    @Override
    public void persist(XQEPersistContext ctx, String optionalName) {
        if (ctx.beginElement(this, optionalName, -1)) {
            ctx.elementProperty(STRING_COLUMN_DESCRIPTORS, this.columnDescriptors);
            ctx.endElement();
        }
    }

    @Override
    public void restore(XQERestoreContext ctx, Element node) {
        List childList = node.elements();
        int nChildren = childList.size();
        for (int i = 0; i < nChildren; ++i) {
            Element child = (Element)childList.get(i);
            if (child.getNamespace().getURI().isEmpty()) continue;
            this.restoreElementProperty(ctx, child, node);
        }
    }

    protected void restoreElementProperty(XQERestoreContext ctx, Element node, Element inputNode) {
        String pname = node.attributeValue("pname");
        if (pname != null && pname.equals(STRING_COLUMN_DESCRIPTORS)) {
            Object val = ctx.elementValue(node);
            this.columnDescriptors = (ArrayList)val;
        }
    }
}

