/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.resultsets.tabular;

import com.cognos.xqe.data.values.IRow;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.resultset.interfaces.IHybridResultSet;
import com.cognos.xqe.resultset.interfaces.IIterator;
import com.cognos.xqe.resultset.interfaces.IScrollableIterator;
import com.cognos.xqe.resultset.interfaces.ISet;
import com.cognos.xqe.resultset.interfaces.ITabularIterator;
import com.cognos.xqe.resultset.interfaces.ITabularResultSet;
import com.cognos.xqe.resultset.interfaces.ITuple;
import com.cognos.xqe.resultsets.md.CacheHints;
import com.cognos.xqe.resultsets.md.SetBase;
import com.cognos.xqe.resultsets.md.XCellIterator;
import com.cognos.xqe.rsapi.RSAPIEdge;
import com.cognos.xqe.runtree.ScrollableIterator;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.XIterator;
import com.cognos.xqe.runtree.XIteratorAdaptor;
import com.cognos.xqe.runtree.XResultSetBase;
import com.cognos.xqe.runtree.XScrollableCellIterator;
import com.cognos.xqe.runtree.XScrollableIterator;
import com.cognos.xqe.runtree.XScrollableIteratorAdaptor;
import com.cognos.xqe.runtree.relational.vectorization.XVectorContext;
import com.cognos.xqe.runtree.v5.V5OnHybridEdgeIterator;
import com.cognos.xqe.util.LinkedStack;
import com.cognos.xqe.util.xml.XMLWriter;

public class TabularHybridResultSet
extends XResultSetBase
implements IHybridResultSet {
    static final long serialVersionUID = 1L;
    private ITabularResultSet table;
    private ISet axis;
    private XVectorContext vContext;

    public TabularHybridResultSet(XDataContext context, ITabularResultSet theTable) {
        this(context, theTable, context.getNodeId());
    }

    public TabularHybridResultSet(XDataContext context, ITabularResultSet theTable, Integer theNodeId) {
        this(context, null, theTable, theNodeId);
    }

    public TabularHybridResultSet(XDataContext context, XVectorContext vectorContext, ITabularResultSet theTable, Integer theNodeId) {
        super(context, theNodeId);
        this.table = theTable;
        this.vContext = vectorContext;
        try {
            this.rowsetInfo = this.table.getTabularRowsetInfo();
        }
        catch (RuntimeException ex) {
            this.release();
            throw ex;
        }
        catch (Throwable ex) {
            this.release();
            throw XQERuntimeException.wrap(XQEMessageKeys.GEN_UnexpectedException, ex);
        }
    }

    @Override
    public XCellIterator getCellIterator() {
        return null;
    }

    @Override
    public XScrollableCellIterator getScrollableCellIterator() {
        return null;
    }

    public IIterator getValueIterator() {
        return null;
    }

    @Override
    public ITabularIterator getTabularIterator() {
        if (this.vContext != null) {
            return ((XResultSetBase)((Object)this.table)).getTabularIterator(this.vContext);
        }
        return this.table.getTabularIterator();
    }

    @Override
    public IScrollableIterator getScrollableV5EdgeIterator(RSAPIEdge edge) {
        return new ScrollableIterator(this.getDataContext(), this.getV5EdgeIterator(edge), this.nodeId, edge);
    }

    @Override
    public XIterator getV5EdgeIterator(RSAPIEdge edge) {
        return new V5OnHybridEdgeIterator(this.getDataContext(), this.nodeId, edge, this.getTabularIterator());
    }

    @Override
    public XCellIterator getV5CellIterator() {
        return this.getCellIterator();
    }

    @Override
    public XScrollableCellIterator getScrollableV5CellIterator() {
        return this.getScrollableCellIterator();
    }

    @Override
    public ITuple getSlicer() {
        return null;
    }

    public int getCellCount() {
        return -1;
    }

    @Override
    public long getRowCount() {
        return this.table.getRowCount();
    }

    @Override
    public boolean isTabular() {
        return true;
    }

    @Override
    public boolean isVectorized() {
        return this.table.isVectorized();
    }

    @Override
    public XIterator getAxisIterator(int axisNumber) {
        if (axisNumber < 0 || axisNumber >= 1) {
            return null;
        }
        return new XIteratorAdaptor(this.getDataContext(), this.axis.iterator(), this.nodeId);
    }

    @Override
    public XScrollableIterator getScrollableAxisIterator(int axisNumber) {
        if (axisNumber < 0 || axisNumber >= 1) {
            return null;
        }
        return new XScrollableIteratorAdaptor(this.getDataContext(), ((SetBase)this.axis).getScrollableIterator(), this.nodeId);
    }

    @Override
    public int getNumAxes() {
        return 1;
    }

    @Override
    public IDimension[] getDimensions(int axisNumber) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getAxisSize(int axisNumber) {
        if (axisNumber < 0 || axisNumber >= 1) {
            return 0L;
        }
        long size = 0L;
        ITabularIterator iterator = this.getTabularIterator();
        try {
            Object o = iterator.next();
            while (o != null) {
                ++size;
                o = iterator.next();
            }
        }
        finally {
            iterator.release();
        }
        return size;
    }

    @Override
    public long getV5EdgeSize(RSAPIEdge edge) {
        int axisNumber = edge.getHybridResultSetEdgePosition();
        if (axisNumber >= 0) {
            return this.getAxisSize(axisNumber);
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void toXML(XMLWriter xmlWriter) {
        ITabularIterator tabIt = this.getTabularIterator();
        try {
            IRow row;
            if (xmlWriter.isEmpty()) {
                xmlWriter.writeProcessingInstruction("<?xml-stylesheet type=\"text/xsl\" href=\"http://wottcub1:4444/stylesheets/TabularHybridResultSet.xsl\"?>\n");
            }
            xmlWriter.beginElement("TabularHybridResultSet", -1);
            this.rowsetInfo.dumpFormattedXMLResult(xmlWriter);
            xmlWriter.beginElement("RowList", -1);
            while ((row = (IRow)tabIt.next()) != null) {
                xmlWriter.beginElement("Row", -1);
                for (int i = 0; i < row.getNumColumns(); ++i) {
                    IValue value = row.getColumn(i);
                    if (value == null) continue;
                    try {
                        value.toXML(xmlWriter);
                        continue;
                    }
                    finally {
                        value.release();
                    }
                }
                xmlWriter.endElement();
            }
        }
        finally {
            tabIt.release();
        }
        xmlWriter.endElement();
        xmlWriter.endElement();
    }

    @Override
    public int getNumTabularMeasures() {
        return 0;
    }

    @Override
    public int getNumDataItemForSummary(int rowsetId) {
        return 0;
    }

    public ITabularResultSet getBaseTabularResultSet() {
        return this.table;
    }

    @Override
    public void releaseImpl() {
        this.axis = null;
        if (this.table != null) {
            this.table.release();
            this.table = null;
        }
    }

    public Integer getNodeId() {
        return this.nodeId;
    }

    @Override
    public boolean isCaching() {
        return false;
    }

    @Override
    public void optimizeCache(LinkedStack<CacheHints> hints) {
    }
}

