/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.resultsets.tabular;

import com.cognos.xqe.data.values.RowValue;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.resultset.interfaces.IRowsetInfo;
import com.cognos.xqe.resultset.interfaces.ITabularIterator;
import com.cognos.xqe.resultsets.tabular.TabularHybridResultSet;
import java.io.IOException;
import org.apache.xml.utils.DefaultErrorHandler;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;

public final class TabularResultSet2Sax
implements XMLReader {
    private static final String DEFAULT_NAMESPACE_URI = "";
    public static final String E_RESULTS = "results";
    public static final String E_ROW = "Row";
    private static ContentHandler contentHandler = new DefaultHandler();
    private ErrorHandler errorHandler = new DefaultErrorHandler();
    private TabularHybridResultSet result;
    public static final Attributes EMPTY_ATTRIBUTES = new AttributesImpl();

    public TabularResultSet2Sax(TabularHybridResultSet aResult) {
        this.result = aResult;
    }

    @Override
    public void parse(InputSource input) throws IOException, SAXException {
        this.parse();
    }

    @Override
    public void parse(String systemId) throws IOException, SAXException {
        this.parse();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse() throws IOException, SAXException {
        ITabularIterator tabIt = this.result.getTabularIterator();
        try {
            IRowsetInfo rowsetInfo = this.result.getTabularRowsetInfo();
            try {
                RowValue row;
                contentHandler.startDocument();
                while ((row = (RowValue)tabIt.next()) != null) {
                    contentHandler.startElement(DEFAULT_NAMESPACE_URI, E_ROW, E_ROW, EMPTY_ATTRIBUTES);
                    for (int i = 0; i < rowsetInfo.getNumColumns(); ++i) {
                        String elementName = rowsetInfo.getColumnInfo(i).getName();
                        contentHandler.startElement(DEFAULT_NAMESPACE_URI, elementName, elementName, EMPTY_ATTRIBUTES);
                        String value = row.getColumn(i).toString();
                        if (value != null) {
                            char[] chars = value.toCharArray();
                            contentHandler.characters(chars, 0, chars.length);
                        }
                        contentHandler.endElement(DEFAULT_NAMESPACE_URI, elementName, elementName);
                    }
                    contentHandler.endElement(DEFAULT_NAMESPACE_URI, E_ROW, E_ROW);
                }
                contentHandler.endDocument();
            }
            catch (RuntimeException e) {
                throw XQERuntimeException.wrap(e);
            }
        }
        finally {
            tabIt.release();
        }
    }

    @Override
    public ContentHandler getContentHandler() {
        return contentHandler;
    }

    @Override
    public void setContentHandler(ContentHandler handler) throws NullPointerException {
        contentHandler = handler;
    }

    @Override
    public boolean getFeature(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        return false;
    }

    @Override
    public void setFeature(String name, boolean value) throws SAXNotRecognizedException, SAXNotSupportedException {
    }

    @Override
    public DTDHandler getDTDHandler() {
        return null;
    }

    @Override
    public void setDTDHandler(DTDHandler handler) {
    }

    @Override
    public EntityResolver getEntityResolver() {
        return null;
    }

    @Override
    public void setEntityResolver(EntityResolver resolver) {
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    @Override
    public void setErrorHandler(ErrorHandler handler) {
        this.errorHandler = handler;
    }

    @Override
    public Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        return null;
    }

    @Override
    public void setProperty(String name, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
    }
}

