/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.rsapi;

import com.cognos.xqe.data.DataSubType;
import com.cognos.xqe.data.types.DoubleType;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.resultsets.ContextValue;
import com.cognos.xqe.rsapi.RSAPICellRowset;
import com.cognos.xqe.rsapi.RSAPIValue;
import com.cognos.xqe.util.xml.XMLWriter;
import com.cognos.xqe.xqejapi.IRSAPICell;
import java.util.ArrayList;
import java.util.Iterator;

public class RSAPICell
extends RSAPIValue
implements IRSAPICell {
    private static final long serialVersionUID = 1L;
    private int[] mCoordinates;
    private int mOrdinal;
    private ArrayList<IValue> mValues;

    protected RSAPICell(RSAPICellRowset rowset, int nEdges) {
        super(rowset);
        this.mCoordinates = new int[nEdges];
        this.mValues = new ArrayList();
    }

    protected void setCoordinate(int edgeOrdinal, int coordinate) {
        if (edgeOrdinal >= 0 && edgeOrdinal < this.mCoordinates.length) {
            this.mCoordinates[edgeOrdinal] = coordinate;
        }
    }

    protected void setCellOrdinal(int ordinal) {
        this.mOrdinal = ordinal;
    }

    @Override
    public int[] getEdgeCoordinates() {
        return this.mCoordinates;
    }

    @Override
    public int getCellOrdinal() {
        return this.mOrdinal;
    }

    @Override
    public void toXMLString(XMLWriter writer) {
        writer.beginElement("row", -1);
        writer.attribute("rowNumber", this.getRowNumber());
        writer.attribute("ordinal", this.getCellOrdinal());
        for (int i = 0; i < this.getEdgeCoordinates().length; ++i) {
            writer.beginElement("member", -1);
            writer.attribute("edge", i);
            writer.attribute("n", this.getEdgeCoordinates()[i]);
            writer.endElement();
        }
        this.valueToXMLString((Value)this.rowData[0], null, writer);
        writer.endElement();
    }

    protected void setCellValue(IValue value, boolean allowNonNumericCellValues) {
        if (value == null) {
            if (this.rowData[0] == null) {
                this.rowData[0] = this.createNewValue(DoubleType.DOUBLETYPE);
            }
            this.setColumnValueToNull(0);
            return;
        }
        IDataType cellDataType = value.getDataType();
        if (cellDataType.getSubType() != DataSubType.NUMERICTYPE && !allowNonNumericCellValues) {
            if (this.rowData[0] == null) {
                this.rowData[0] = this.createNewValue(DoubleType.DOUBLETYPE);
            }
            this.setColumnValueToError(0);
            return;
        }
        if (this.rowData[0] == null || ((Value)this.rowData[0]).getDataType() != cellDataType) {
            this.rowData[0] = this.createNewValue(cellDataType);
        }
        if (value instanceof ContextValue) {
            this.assignColumnValue(this.rowData[0], ((ContextValue)value).getValue());
        } else {
            this.assignColumnValue(this.rowData[0], value);
        }
    }

    @Override
    public IValue getValue() {
        return this.rowData[0];
    }

    @Override
    public boolean isListReport() {
        return false;
    }

    @Override
    protected boolean isDetailRow() {
        return false;
    }

    @Override
    protected boolean isRow() {
        return false;
    }

    @Override
    protected boolean isCell() {
        return true;
    }

    private IValue createNewValue(IDataType dataType) {
        Value value = null;
        Iterator<IValue> it = this.mValues.iterator();
        boolean found = false;
        while (it.hasNext() && !found) {
            value = (Value)it.next();
            if (value.getDataType() != dataType) continue;
            found = true;
        }
        if (!found) {
            value = (Value)dataType.createValue();
            this.mValues.add(value);
        }
        return value;
    }
}

