/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.rsapi;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.resultset.interfaces.IHybridResultSet;
import com.cognos.xqe.rsapi.RSAPIContextInformation;
import com.cognos.xqe.rsapi.RSAPIDataset;
import com.cognos.xqe.rsapi.RSAPIEdge;
import com.cognos.xqe.rsapi.RSAPIEdgeInformation;
import com.cognos.xqe.rsapi.RSAPIEdgeIterator;
import com.cognos.xqe.rsapi.RSAPIEdgeIteratorCache;
import com.cognos.xqe.rsapi.RSAPIFwdEdgeIterator;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.XScrollableCellIterator;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.util.IReleasable;
import com.cognos.xqe.util.pool.XQEIntegerPool;
import java.util.HashMap;
import java.util.Map;

public class RSAPIResultSet
implements IReleasable {
    private IHybridResultSet hResultSet;
    private XDataContext mDataContext;
    private Map<Integer, RSAPIEdgeInformation> mEdgeInformation;
    private RSAPIEdgeIteratorCache mIteratorCache;
    private static XQELogger mErrorLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Exception", LogLevel.ERROR);

    public RSAPIResultSet(RSAPIDataset dSet, XDataContext dataContext, IHybridResultSet resultSet) {
        try {
            this.mDataContext = dataContext;
            this.mDataContext.incrementRefCount();
            this.hResultSet = resultSet;
            this.mIteratorCache = new RSAPIEdgeIteratorCache();
            RSAPIEdge[] edges = dSet.getEdges();
            this.mEdgeInformation = new HashMap<Integer, RSAPIEdgeInformation>();
            for (int i = 0; i < edges.length; ++i) {
                RSAPIEdgeInformation edgeInfo = new RSAPIEdgeInformation(edges[i].getNumRowsets());
                Integer ordinal = XQEIntegerPool.getInteger(edges[i].getOrdinal());
                this.mEdgeInformation.put(ordinal, edgeInfo);
            }
        }
        catch (RuntimeException e) {
            this.release();
            throw e;
        }
    }

    protected XScrollableCellIterator getCellIterator() {
        return this.hResultSet.getScrollableCellIterator();
    }

    public IHybridResultSet getResultSet() {
        return this.hResultSet;
    }

    protected RSAPIContextInformation getContextInformation(int edgeOrdinal, int rowsetId, int detailRowNumber, RSAPIContextInformation contextInfo) {
        Integer ordinal = XQEIntegerPool.getInteger(edgeOrdinal);
        RSAPIEdgeInformation edgeInfo = this.mEdgeInformation.get(ordinal);
        return edgeInfo.getContextInformation(rowsetId, detailRowNumber, contextInfo);
    }

    protected void setContextInformation(int edgeOrdinal, int rowsetId, RSAPIContextInformation contextInfo) {
        Integer ordinal = XQEIntegerPool.getInteger(edgeOrdinal);
        RSAPIEdgeInformation edgeInfo = this.mEdgeInformation.get(ordinal);
        edgeInfo.setContextInformation(rowsetId, contextInfo);
    }

    protected void setNumDetailRows(int edgeOrdinal, int numDetailRows, boolean allRowsRead) {
        Integer ordinal = XQEIntegerPool.getInteger(edgeOrdinal);
        RSAPIEdgeInformation edgeInfo = this.mEdgeInformation.get(ordinal);
        edgeInfo.setNumDetailRows(numDetailRows, allRowsRead);
    }

    protected int getNumDetailRows(int edgeOrdinal) {
        Integer ordinal = XQEIntegerPool.getInteger(edgeOrdinal);
        RSAPIEdgeInformation edgeInfo = this.mEdgeInformation.get(ordinal);
        return edgeInfo.getNumDetailRows();
    }

    protected void setTabularRowNumbers(int edgeOrdinal, Map<Integer, Integer> detailRowToTabularRowMap) {
        Integer ordinal = XQEIntegerPool.getInteger(edgeOrdinal);
        RSAPIEdgeInformation edgeInfo = this.mEdgeInformation.get(ordinal);
        edgeInfo.setTabularRowNumbers(detailRowToTabularRowMap);
    }

    protected int getTabularRowNumber(int edgeOrdinal, int detailRowNumber) {
        Integer ordinal = XQEIntegerPool.getInteger(edgeOrdinal);
        RSAPIEdgeInformation edgeInfo = this.mEdgeInformation.get(ordinal);
        return edgeInfo.getTabularRowNumber(detailRowNumber);
    }

    protected void addIteratorToCache(int edgeOrdinal, RSAPIFwdEdgeIterator iterator) {
        if (this.mIteratorCache != null) {
            this.mIteratorCache.putIterator(edgeOrdinal, iterator);
        }
    }

    protected RSAPIEdgeIterator getIteratorFromCache(int edgeOrdinal, int startDetailRowNumber, int numRows) {
        return this.mIteratorCache.getIterator(edgeOrdinal, startDetailRowNumber, numRows);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release() {
        this.mEdgeInformation.clear();
        if (this.mIteratorCache != null) {
            try {
                this.mIteratorCache.release();
            }
            catch (Exception ex) {
                mErrorLogger.log(ex);
            }
            finally {
                this.mIteratorCache = null;
            }
        }
        if (this.hResultSet != null) {
            try {
                this.hResultSet.release();
            }
            catch (Exception ex) {
                mErrorLogger.log(ex);
            }
            finally {
                this.hResultSet = null;
            }
        }
        if (this.mDataContext != null) {
            try {
                if (this.mDataContext.decrementRefCount() != 0) {
                    while (this.mDataContext.decrementRefCount() > 0) {
                    }
                    throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "XDataContext was leaked from RSAPIResultSet.");
                }
            }
            finally {
                this.mDataContext = null;
            }
        }
    }

    public IHybridResultSet unwrapResultSet() {
        IHybridResultSet resultset = this.hResultSet;
        this.hResultSet = null;
        this.mDataContext.decrementRefCount();
        return resultset;
    }
}

