/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.rsapi;

import com.cognos.xqe.ast.v5.utils.V5NodeFormatResolver;
import com.cognos.xqe.data.DataSubType;
import com.cognos.xqe.data.DataTypeComparator;
import com.cognos.xqe.data.types.BusinessKeyType;
import com.cognos.xqe.data.types.CurrencyCodeType;
import com.cognos.xqe.data.types.DecimalType;
import com.cognos.xqe.data.types.DimensionUniqueNameType;
import com.cognos.xqe.data.types.DoubleType;
import com.cognos.xqe.data.types.ExactNumericType;
import com.cognos.xqe.data.types.FloatType;
import com.cognos.xqe.data.types.HierarchyUniqueNameType;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.types.LevelLabelType;
import com.cognos.xqe.data.types.LevelNumberType;
import com.cognos.xqe.data.types.LevelUniqueNameType;
import com.cognos.xqe.data.types.MemberCaptionType;
import com.cognos.xqe.data.types.MemberDescriptionType;
import com.cognos.xqe.data.types.MemberRollupType;
import com.cognos.xqe.data.types.MemberType;
import com.cognos.xqe.data.types.MemberUniqueNameType;
import com.cognos.xqe.data.types.ParentLevelNumberType;
import com.cognos.xqe.data.types.ParentUniqueNameType;
import com.cognos.xqe.data.types.QueryItemModelIDType;
import com.cognos.xqe.data.types.RowType;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.ExactNumericValue;
import com.cognos.xqe.data.values.IMemberPropertyValue;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.MemberRSAPIValue;
import com.cognos.xqe.data.values.MemberStringPropertyValue;
import com.cognos.xqe.data.values.RowValue;
import com.cognos.xqe.data.values.StringValue;
import com.cognos.xqe.data.values.TextValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.data.values.ValueConversionException;
import com.cognos.xqe.data.values.ValueMethodNotImplementedException;
import com.cognos.xqe.data.values.ValueState;
import com.cognos.xqe.data.values.VariantValueMethodNotImplementedException;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.format.FormatId;
import com.cognos.xqe.format.FormatService;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.wrapper.CubeWrapper;
import com.cognos.xqe.resultsets.ContextBase;
import com.cognos.xqe.resultsets.ContextMember;
import com.cognos.xqe.resultsets.ContextMemberWrapper;
import com.cognos.xqe.resultsets.ContextValue;
import com.cognos.xqe.rsapi.RSAPIColumn;
import com.cognos.xqe.rsapi.RSAPIDataItem;
import com.cognos.xqe.rsapi.RSAPIDataset;
import com.cognos.xqe.rsapi.RSAPIRow;
import com.cognos.xqe.rsapi.RSAPIRowset;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRLevel;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRMeasure;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRMember;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.IDMRMember;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.IDMRMemberForOLAP;
import com.cognos.xqe.runtree.olap.mdx.metadata.CalculatedMember;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.IROLAPHierarchy;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.IROLAPLevel;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPContext;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ShareableROLAPDimension;
import com.cognos.xqe.util.UniqueNameGenerator;
import com.cognos.xqe.util.xml.XMLWriter;
import com.cognos.xqe.xqejapi.IRSAPIValue;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;

public abstract class RSAPIValue
extends RowValue
implements IRSAPIValue {
    static final int NO_COMPARISON_COLUMN_OFFSET = -1;
    public static final int NO_ANCESTOR_ROWSET_ID = -1;
    private int mRowNumber;
    private int mDetailRowNumber = 0;
    private int mAncestorRowsetId = -1;
    private int mAncestorRowNumber;
    RSAPIColumn[] mColumns;
    private RSAPIRowset mRowset;
    public static final int NON_DETAIL_ROW_NUMBER = 0;
    public static final int NON_DETAIL_COORDINATE = -1;
    public static final String FORMATID = "formatId";
    public static final String FORMAT = "format";
    IValue[] mCoercedColumnValues;

    protected RSAPIValue(RSAPIRowset rowset) {
        super(new IValue[rowset.getNumColumns()]);
        this.mCoercedColumnValues = new IValue[rowset.getNumColumns()];
        this.mColumns = rowset.getColumns();
        this.mRowset = rowset;
    }

    public int getDetailRowNumber() {
        return this.mDetailRowNumber;
    }

    @Override
    public int getRowNumber() {
        return this.mRowNumber;
    }

    public int getRowsetId() {
        return this.getRowset().getRowsetId();
    }

    protected void setDetailRowNumber(int detailRowNumber) {
        this.mDetailRowNumber = detailRowNumber;
    }

    protected void setRowNumber(int rowNumber) {
        this.mRowNumber = rowNumber;
    }

    protected void setAncestorRowNumber(int rowNumber) {
        this.mAncestorRowNumber = rowNumber;
    }

    protected void setAncestorRowsetId(int id) {
        this.mAncestorRowsetId = id;
    }

    public int getAncestorRowNumber() {
        return this.mAncestorRowNumber;
    }

    public int getAncestorRowsetId() {
        return this.mAncestorRowsetId;
    }

    @Override
    public boolean isPrimitive() {
        return false;
    }

    @Override
    public boolean isMetadata() {
        return false;
    }

    @Override
    public boolean isResultSet() {
        return false;
    }

    public RSAPIRowset getRowset() {
        return this.mRowset;
    }

    protected void assignColumnValue(IValue tValue, Object object) {
        if (object instanceof IValue) {
            this.assignColumnValue(tValue, (IValue)object);
            return;
        }
        Value target = (Value)tValue;
        if (object == null) {
            target.setState(ValueState.NULL);
            return;
        }
        target.set(object);
    }

    protected void assignColumnValue(IValue tValue, IValue sValue) {
        Value target = (Value)tValue;
        if (sValue == null) {
            target.setState(ValueState.NULL);
            return;
        }
        if (sValue instanceof Value) {
            target.copyFrom(sValue);
        } else {
            target.set(sValue);
        }
    }

    @Override
    public IDataType getDataType() {
        return RowType.ROWTYPE;
    }

    @Override
    public FormatId getFormatId() {
        throw new XQERuntimeException(XQEMessageKeys.GEN_MethodNotImplemented_INTERNAL, this.getClass().getName() + ".getFormatId()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void transferValues(RSAPIDataset dataset, RSAPIDataItem dataItem, ArrayList<Integer> ordinals, ContextBase value) {
        ContextMember contextMember;
        ValueState valueState = ValueState.OK;
        if (value.contextIsAValue()) {
            contextMember = value.getContextMember();
            Value v = (Value)((ContextValue)value).getValue();
            if (contextMember == null && v instanceof IMemberPropertyValue) {
                contextMember = new ContextMember();
                contextMember.setMember(((IMemberPropertyValue)((Object)v)).getMember());
            }
            valueState = v.getState();
        } else {
            contextMember = (ContextMember)value;
            if (contextMember.isNull()) {
                contextMember = null;
            }
        }
        String cubeName = null;
        boolean needToRemoveCubeName = false;
        if (contextMember != null && contextMember.getDimension() != null && contextMember.getDimension().isShareable()) {
            cubeName = contextMember.getCubeNameFromDataSourceProperties();
            needToRemoveCubeName = ROLAPContext.setCurrentCubeName(cubeName);
        }
        RSAPIColumn[] columnInfo = this.getColumnInfo();
        try {
            for (int i = 0; i < ordinals.size(); ++i) {
                int ordinal = ordinals.get(i);
                if (valueState == ValueState.ERROR) {
                    this.setColumnValueToError(ordinal);
                    continue;
                }
                if (dataItem.isNotApplicableGroupbody() || valueState == ValueState.NOT_APPLICABLE) {
                    this.setColumnValueToNA(ordinal);
                    continue;
                }
                IDataType dType = columnInfo[ordinal].getUnadjustedDataType();
                RSAPIColumn.ValueTypeEnum valueType = columnInfo[ordinal].getValueType();
                if (valueType == RSAPIColumn.ValueTypeEnum.MEMBER && this.rowData[ordinal] instanceof MemberRSAPIValue) {
                    this.rowData[ordinal].copyFrom(contextMember);
                    continue;
                }
                if (valueType == RSAPIColumn.ValueTypeEnum.RETURN_NULL_STRING) {
                    this.setColumnValueToNull(ordinal);
                    continue;
                }
                if (valueType == RSAPIColumn.ValueTypeEnum.INTRINSIC_PROPERTY || valueType == RSAPIColumn.ValueTypeEnum.MEMBER) {
                    this.transferIntrinsicProperty(dataset, dataItem, value, columnInfo[ordinal], contextMember, ordinal, dType);
                    continue;
                }
                if (contextMember != null && valueType == RSAPIColumn.ValueTypeEnum.CUSTOM_PROPERTY) {
                    String propertyName = columnInfo[ordinal].getBaseRefDataItem().getPropertyName();
                    Object propertyValue = contextMember.getProperty(propertyName);
                    if (propertyValue == null) {
                        this.setColumnValueToNull(ordinal);
                        continue;
                    }
                    try {
                        this.setColumnValue(ordinal, this.getPropertyValue(ordinal, dataset, propertyName, propertyValue));
                        continue;
                    }
                    catch (VariantValueMethodNotImplementedException e) {
                        throw new XQERuntimeException(XQEMessageKeys.RSA_InvalidDataTypeVariant, (Throwable)e, dataItem.getName());
                    }
                }
                IValue sourceValue = this.obtainSourceValue(dataset, dataItem, ordinal, value);
                this.setColumn(ordinal, sourceValue);
            }
        }
        finally {
            ROLAPContext.removeCurrentCubeName(needToRemoveCubeName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void transferIntrinsicProperty(RSAPIDataset dataset, RSAPIDataItem dataItem, ContextBase value, RSAPIColumn column, ContextMember contextMember, int ordinal, IDataType dType) {
        String cubeName = null;
        boolean needToRemoveCubeName = false;
        if (contextMember != null && contextMember.getDimension() != null && contextMember.getDimension().isShareable()) {
            cubeName = contextMember.getCubeNameFromDataSourceProperties();
            needToRemoveCubeName = ROLAPContext.setCurrentCubeName(cubeName);
        }
        try {
            if (dType == MemberCaptionType.DEFAULTMEMBERCAPTIONTYPE || dType == MemberType.MEMBERTYPE) {
                if (value.isQueryCalculation()) {
                    this.setColumnValue(ordinal, dataItem.getName());
                } else if (contextMember == null && dataItem.isGroupbodyMeasure()) {
                    this.setColumnValue(ordinal, value);
                } else if (contextMember == null) {
                    this.setColumnValueToNull(ordinal);
                } else if (contextMember.isExtendedCalculatedMember()) {
                    this.setColumnValue(ordinal, contextMember.getExtendedCalculatedMemberCaption());
                } else if (contextMember.isCalculatedMember()) {
                    if (contextMember.isROLAP()) {
                        this.setColumnValue(ordinal, contextMember.getOriginalMemberCaption());
                    } else {
                        this.setColumnValue(ordinal, contextMember.getCaption());
                    }
                } else {
                    this.setColumnValue(ordinal, contextMember.getCaption());
                }
            } else if (dType == CurrencyCodeType.DEFAULTCURRENCYCODETYPE) {
                this.setColumnValueToNull(ordinal);
            } else if (dType == DimensionUniqueNameType.DEFAULTDIMENSIONUNIQUENAMETYPE) {
                if (value.isQueryCalculation() || contextMember == null || dataset.forXtabRelational()) {
                    this.setColumnValueToNull(ordinal);
                } else if (this.useResolveDMRMember(contextMember)) {
                    IMember origMember = this.getResolvedDMRMember(contextMember);
                    if (origMember != null) {
                        String v5DimensionUniqueName = origMember.getLevel().getHierarchy().getDimension().getV5UniqueName();
                        this.setColumnValue(ordinal, v5DimensionUniqueName);
                    } else {
                        this.setColumnValueToNull(ordinal);
                    }
                } else if (contextMember.isRelational() && contextMember.isMeasure() && contextMember.getV5UniqueName() != null) {
                    String memberDimensionV5UN = contextMember.getV5UniqueName();
                    String measureDimensionV5UN = null;
                    if (memberDimensionV5UN != null) {
                        measureDimensionV5UN = CubeWrapper.getMeasureDimensionV5UniqueName(memberDimensionV5UN);
                    }
                    this.setColumnValue(ordinal, measureDimensionV5UN);
                } else {
                    this.setDimensionV5UniqueName(contextMember, ordinal, cubeName);
                }
            } else if (dType == HierarchyUniqueNameType.DEFAULTHIERARCHYUNIQUENAMETYPE) {
                if (value.isQueryCalculation() || contextMember == null || dataset.forXtabRelational()) {
                    this.setColumnValueToNull(ordinal);
                } else if (this.useResolveDMRMember(contextMember)) {
                    IMember origMember = this.getResolvedDMRMember(contextMember);
                    if (origMember != null) {
                        String v5HierarchyUniqueName = origMember.getLevel().getHierarchy().getV5UniqueName();
                        this.setColumnValue(ordinal, v5HierarchyUniqueName);
                    } else {
                        this.setColumnValueToNull(ordinal);
                    }
                } else if (contextMember.isRelational() && contextMember.isMeasure() && contextMember.getV5UniqueName() != null || cubeName == null && contextMember.getLevel() != null && contextMember.getLevel().getHierarchy().getV5UniqueName() == null) {
                    if (contextMember.getV5UniqueName() == null && contextMember.getLevel().getHierarchy().getV5UniqueName() == null) {
                        this.setDimensionV5UniqueName(contextMember, ordinal, cubeName);
                    } else {
                        String memberDimensionV5UN = contextMember.getV5UniqueName();
                        String measureDimensionV5UN = null;
                        if (memberDimensionV5UN != null) {
                            measureDimensionV5UN = CubeWrapper.getMeasureDimensionV5UniqueName(memberDimensionV5UN);
                        }
                        this.setColumnValue(ordinal, measureDimensionV5UN);
                    }
                } else {
                    this.setHierarchyV5UniqueName(contextMember, ordinal, cubeName);
                }
            } else if (dType == LevelUniqueNameType.DEFAULTLEVELUNIQUENAMETYPE) {
                if (value.isQueryCalculation() || contextMember == null) {
                    this.setColumnValueToNull(ordinal);
                } else if (this.useResolveDMRMember(contextMember)) {
                    IMember origMember = this.getResolvedDMRMember(contextMember);
                    if (origMember != null) {
                        this.setLevelV5UniqueName(origMember, ordinal, null);
                    } else {
                        this.setColumnValueToNull(ordinal);
                    }
                } else if (contextMember.getHierarchy() != null && contextMember.getHierarchy().isParentChild() || contextMember.isCalculatedMember() && (!CalculatedMember.getQSReturnCalculatedMemberLUN() || !contextMember.isROLAPCalculatedMember()) || contextMember.isRelational() && contextMember.isMeasure()) {
                    this.setColumnValueToNull(ordinal);
                } else {
                    this.setLevelV5UniqueName(contextMember, ordinal, cubeName);
                }
            } else if (dType == MemberUniqueNameType.DEFAULTMEMBERUNIQUENAMETYPE) {
                if (value.isQueryCalculation() || contextMember == null) {
                    this.setColumnValueToNull(ordinal);
                } else if (this.useResolveDMRMember(contextMember)) {
                    IMember origMember = this.getResolvedDMRMember(contextMember);
                    if (origMember != null) {
                        this.setColumnValue(ordinal, origMember);
                    } else {
                        this.setColumnValueToNull(ordinal);
                    }
                } else {
                    this.setColumnValue(ordinal, (Object)contextMember);
                }
            } else if (dType == LevelLabelType.DEFAULTLEVELLABELTYPE) {
                if (value.isQueryCalculation() || contextMember == null || contextMember.getHierarchy().isParentChild()) {
                    this.setColumnValueToNull(ordinal);
                } else {
                    IMember refMember = contextMember.getMember();
                    if (refMember != null && refMember instanceof IDMRMember) {
                        this.setColumnValue(ordinal, ((DMRLevel)contextMember.getLevel()).getV5Name());
                    } else {
                        this.setColumnValue(ordinal, contextMember.getLevel().getCaption());
                    }
                }
            } else if (dType == LevelNumberType.LEVELNUMBERTYPE) {
                if (value.isQueryCalculation() || contextMember == null) {
                    this.setColumnValueToNull(ordinal);
                } else if (contextMember.isCalculatedMember()) {
                    boolean bQSReturnCalculatedMemberLUN = CalculatedMember.getQSReturnCalculatedMemberLUN();
                    if (bQSReturnCalculatedMemberLUN && contextMember.getHierarchy() != null && contextMember.getHierarchy().isParentChild()) {
                        this.setColumnValueToNull(ordinal);
                    } else if (contextMember.isExtendedCalculatedMember() || bQSReturnCalculatedMemberLUN && contextMember.isROLAPCalculatedMember() || dataset.forXtabRelational()) {
                        this.setColumnValue(ordinal, contextMember.getLevel().getIndex());
                    } else {
                        this.setColumnValueToNull(ordinal);
                    }
                } else if (contextMember.getLevel() != null) {
                    this.setColumnValue(ordinal, contextMember.getLevel().getIndex());
                }
            } else if (dType == ParentLevelNumberType.DEFAULTPARENTLEVELNUMBERTYPE) {
                if (value.isQueryCalculation() || contextMember == null) {
                    this.setColumnValueToNull(ordinal);
                } else {
                    IMember columnValue = null;
                    if (this.useResolveDMRMember(contextMember)) {
                        columnValue = this.getResolvedDMRMember(contextMember);
                    } else if (!contextMember.isRelational() || !contextMember.isMeasure()) {
                        columnValue = contextMember;
                    }
                    if (columnValue == null) {
                        this.setColumnValueToNull(ordinal);
                    } else {
                        this.setColumnValue(ordinal, (Object)columnValue);
                    }
                }
            } else if (dType == MemberDescriptionType.DEFAULTMEMBERDESCRIPTIONTYPE) {
                if (value.isQueryCalculation() || contextMember == null) {
                    this.setColumnValueToNull(ordinal);
                } else {
                    this.setColumnValue(ordinal, (Object)contextMember);
                }
            } else if (dType == ParentUniqueNameType.DEFAULTPARENTUNIQUENAMETYPE) {
                if (value.isQueryCalculation() || contextMember == null) {
                    this.setColumnValueToNull(ordinal);
                } else {
                    IMember columnValue = null;
                    if (this.useResolveDMRMember(contextMember)) {
                        columnValue = this.getResolvedDMRMember(contextMember);
                    } else if (!contextMember.isRelational() || !contextMember.isMeasure()) {
                        columnValue = contextMember;
                    }
                    if (columnValue == null) {
                        this.setColumnValueToNull(ordinal);
                    } else {
                        this.setColumnValue(ordinal, (Object)columnValue);
                    }
                }
            } else if (dType == QueryItemModelIDType.DEFAULTQUERYITEMMODELIDTYPE) {
                IMetadata metadataRef = column.getMetadataReference();
                if (metadataRef != null) {
                    this.setColumnValue(ordinal, metadataRef.toString());
                }
            } else if (dType == BusinessKeyType.DEFAULTBUSINESSKEYTYPE) {
                if (value.isQueryCalculation() || contextMember == null) {
                    this.setColumnValueToNull(ordinal);
                } else {
                    this.setColumnValue(ordinal, contextMember.getBusinessKeyValue());
                }
            } else if (dType == MemberRollupType.DEFAULTMEMBERROLLUPTYPE) {
                if (contextMember == null || contextMember.isMeasure()) {
                    this.setColumnValueToNull(ordinal);
                } else {
                    boolean isCalculated = false;
                    if (value.isQueryCalculation()) {
                        isCalculated = true;
                    } else if (value.contextIsAMember() && ((ContextMember)value).isCalculatedMember()) {
                        isCalculated = true;
                    }
                    if (isCalculated) {
                        this.setColumnValue(ordinal, "Computed");
                    } else {
                        this.setColumnValue(ordinal, "Rollup");
                    }
                }
            }
        }
        finally {
            ROLAPContext.removeCurrentCubeName(needToRemoveCubeName);
        }
    }

    private void setLevelV5UniqueName(IMember member, int ordinal, String cubeName) {
        String levelV5UniqueName = null;
        if (cubeName != null) {
            levelV5UniqueName = ((IROLAPLevel)member.getLevel()).getV5UniqueName(cubeName);
        } else if (member != null && member.getLevel() != null) {
            levelV5UniqueName = member.getLevel().getV5UniqueName();
        }
        this.setColumnValue(ordinal, levelV5UniqueName);
    }

    private void setHierarchyV5UniqueName(IMember member, int ordinal, String cubeName) {
        String v5HierarchyName = "";
        if (cubeName != null) {
            v5HierarchyName = ((IROLAPHierarchy)member.getLevel().getHierarchy()).getV5UniqueName(cubeName);
        } else if (member.getLevel() != null) {
            v5HierarchyName = member.getLevel().getHierarchy().getV5UniqueName();
        }
        this.setColumnValue(ordinal, v5HierarchyName);
    }

    private void setDimensionV5UniqueName(IMember member, int ordinal, String cubeName) {
        String dimV5UniqueName = "";
        if (cubeName != null) {
            dimV5UniqueName = ((ShareableROLAPDimension)member.getLevel().getHierarchy().getDimension()).getV5UniqueName(cubeName);
        } else if (member.getLevel() != null) {
            dimV5UniqueName = member.getLevel().getHierarchy().getDimension().getV5UniqueName();
        }
        this.setColumnValue(ordinal, dimV5UniqueName);
    }

    private Object getPropertyValue(int ordinal, RSAPIDataset dataset, String propertyName, Object propertyValue) {
        IDataType columnDataType = this.getColumn(ordinal).getDataType();
        if ("SAP_BUSINESS_KEY".equals(propertyName) && columnDataType.isDate()) {
            propertyValue = UniqueNameGenerator.getSAPBusinessKeyFromMUN((String)propertyValue);
        } else if ("SAP_BUSINESS_KEY".equals(propertyName) && !dataset.isUseSAPMUNAsBusinessKey()) {
            propertyValue = UniqueNameGenerator.getSAPBusinessKeyFromMUN((String)propertyValue);
        }
        return propertyValue;
    }

    private IValue obtainSourceValue(RSAPIDataset dataset, RSAPIDataItem dataItem, int ordinal, ContextBase contextBase) {
        IValue value = null;
        if (contextBase instanceof ContextMember) {
            ContextMemberWrapper wrapper;
            value = DataValueFactory.createStringValue();
            if (contextBase instanceof ContextMemberWrapper && (wrapper = (ContextMemberWrapper)contextBase).getChangedMemberCaption() != null) {
                ((StringValue)value).set(wrapper.getCaption());
                return value;
            }
            if (contextBase.isQueryCalculation() || RSAPIValue.getReturnDataItemNameInPartialDataset(dataset, contextBase)) {
                ((TextValue)value).set(dataItem.getName());
            } else {
                IMember baseMember = ((ContextMember)contextBase).getBaseMember();
                if (baseMember != null && baseMember instanceof DMRMember && ((DMRLevel)((DMRMember)baseMember).getLevel()).needReturnRawData()) {
                    Value capVal = ((DMRMember)baseMember).getCaptionValue();
                    return (IValue)capVal.copy();
                }
                ContextMember member = (ContextMember)contextBase;
                if (member.isROLAP()) {
                    ((StringValue)value).set(member.getBaseMember().getCaption());
                } else {
                    ((StringValue)value).set(((ContextMember)contextBase).getCaption());
                }
            }
            return value;
        }
        ContextValue contextValue = (ContextValue)contextBase;
        if (contextValue == null) {
            value = this.getValueObjectForColumn(ordinal);
            value.setNull();
        } else {
            boolean isOk;
            boolean bl = isOk = !contextValue.isNull();
            if (isOk && contextValue.getValue() instanceof Value) {
                isOk = ((Value)contextValue.getValue()).isOK();
            }
            if (!isOk || dataItem.getDataType() == contextValue.getValue().getDataType()) {
                value = contextValue.getValue();
            } else if (this.getColumnRefDIDataType(ordinal) != null && DataTypeComparator.areCompatibleDataTypes(contextValue.getValue().getDataType(), dataItem.getDataType())) {
                value = this.getValueObjectForColumn(ordinal);
                IValue contextActualValue = contextValue.getValue();
                if (value instanceof MemberStringPropertyValue && !(contextActualValue instanceof MemberStringPropertyValue)) {
                    value = contextActualValue;
                } else {
                    try {
                        value.copyFrom(contextActualValue);
                    }
                    catch (ValueConversionException e) {
                        value = contextActualValue;
                    }
                }
            } else {
                value = contextValue.getValue();
            }
        }
        return value;
    }

    @Override
    public boolean isNumeric() {
        return false;
    }

    @Override
    public void toXML(XMLWriter xmlWriter) {
        this.toXMLString(xmlWriter);
    }

    public abstract void toXMLString(XMLWriter var1);

    @Override
    public void copyFrom(IValue dValue) throws ValueMethodNotImplementedException {
        throw new ValueMethodNotImplementedException(this.getClass().getName() + ".copyFrom(Value dValue)");
    }

    @Override
    public void decode(XDataContext context, DataInput iStream) throws IOException {
        throw new IOException("Reading unknown type:" + this.getClass().getName());
    }

    @Override
    public void encode(XDataContext context, DataOutput oStream) throws IOException {
        throw new IOException("Writing unknown type:" + this.getClass().getName());
    }

    public abstract boolean isListReport();

    protected void setColumnsNull() {
        for (int i = this.getNumColumns() - 1; i >= 0; --i) {
            this.setColumnValueToNull(i);
        }
    }

    protected void setColumnType(int ordinal, IValue value) {
        this.rowData[ordinal] = value;
    }

    protected void setColumnValue(int ordinal, int object) {
        ((Value)this.rowData[ordinal]).set(object);
    }

    protected void setColumnValue(int ordinal, IValue value) {
        this.assignColumnValue(this.rowData[ordinal], value);
    }

    protected void setColumnValue(int ordinal, Object object) {
        this.assignColumnValue(this.rowData[ordinal], object);
    }

    protected void copyColumnValues(RSAPIRow row) {
        for (int i = 0; i < this.getNumColumns(); ++i) {
            this.assignColumnValue(this.rowData[i], row.getColumn(i));
        }
    }

    protected void setColumnValueToNull(int ordinal) {
        ((Value)this.rowData[ordinal]).setNull();
    }

    protected void setColumnValueToNA(int ordinal) {
        ((Value)this.rowData[ordinal]).setState(ValueState.NOT_APPLICABLE);
    }

    protected void setColumnValueToError(int ordinal) {
        ((Value)this.rowData[ordinal]).setState(ValueState.ERROR);
    }

    @Override
    public int getNumColumns() {
        if (this.rowData == null) {
            return 0;
        }
        return this.rowData.length;
    }

    @Override
    public int compareTo(Object object) throws XQERuntimeException {
        int result = 0;
        IValue[] iValues = ((RowValue)object).getColumns();
        if (this.rowData.length != iValues.length) {
            return -1;
        }
        for (int i = 0; i < this.rowData.length && (result = this.rowData[i].compareTo(iValues[i])) == 0; ++i) {
        }
        return result;
    }

    @Override
    public IValue getColumn(int i) {
        return this.rowData[i];
    }

    @Override
    public IValue[] getColumns() {
        return this.rowData;
    }

    protected void setColumnValue(int ordinal, String object) {
        ((Value)this.rowData[ordinal]).set(object);
    }

    protected abstract boolean isDetailRow();

    protected abstract boolean isRow();

    protected abstract boolean isCell();

    public int getCellCoordinate() {
        return -1;
    }

    protected void valueToXMLString(Value value, RSAPIColumn columnInfo, XMLWriter writer) {
        this.valueToXMLString(value, columnInfo, writer, false);
    }

    protected void valueToXMLString(Value value, RSAPIColumn columnInfo, XMLWriter writer, boolean valueInfo) {
        writer.beginElement("value", -1);
        String formatString = null;
        String formatStringId = null;
        FormatService formatService = FormatService.getInstance();
        if (null != formatService) {
            FormatId id = value.getFormatId();
            formatString = formatService.retrieveFormatString(id);
            formatStringId = formatService.getFormatStringId(id);
            if ((id == null || id.equals(FormatId.INVALID_FORMAT_FID) || id.equals(FormatId.EMPTY_FORMAT_FID)) && columnInfo != null) {
                formatString = columnInfo.getFormat();
                formatStringId = columnInfo.getFormatIDString();
            }
        }
        if (!value.isOK()) {
            value.getState().writeRSAPIValueState(writer);
            if ((!value.isNull() || formatString != null && formatString.contains("whenMissing")) && formatStringId != null && !formatStringId.equals("0")) {
                writer.attribute(FORMATID, formatStringId);
                writer.attribute(FORMAT, formatString);
            }
            writer.endElement();
            return;
        }
        IDataType dataType = value.getDataType();
        String valueString = dataType instanceof ExactNumericType && !dataType.isFloatingPointDecimal() ? ((ExactNumericValue)value).getUnscaledString() : value.toString(writer);
        writer.attribute("v", valueString);
        if (columnInfo != null && columnInfo.getQueryItemModelId() != null) {
            writer.attribute("qItemModelRef", columnInfo.getQueryItemModelId());
        }
        if (formatString != null) {
            if (formatStringId != null) {
                writer.attribute(FORMATID, formatStringId);
            }
            writer.attribute(FORMAT, formatString);
        }
        if (valueInfo) {
            writer.attribute("datatype", dataType.getTypeName());
        }
        if (null != formatService && dataType.getSubType() == DataSubType.NUMERICTYPE) {
            FormatId id = value.getFormatId();
            String currencyCode = formatService.getCurrencyCode(id);
            String unitOfMeasure = formatService.getUnitOfMeasure(id);
            if (currencyCode != null && (formatString == null || formatString.length() == 0 || formatString != null && V5NodeFormatResolver.isCurrencyFormat(formatString))) {
                writer.attribute("currency", currencyCode);
            }
            if (unitOfMeasure != null) {
                writer.attribute("unitOfMeasure", unitOfMeasure);
            }
        }
        if (dataType.hasPrecision()) {
            boolean tracePrecision = false;
            if (dataType == DoubleType.DOUBLETYPE) {
                if (dataType.getPrecision() != 15) {
                    tracePrecision = true;
                }
            } else if (dataType == FloatType.FLOATTYPE) {
                if (dataType.getPrecision() != 7) {
                    tracePrecision = true;
                }
            } else if (dataType == DecimalType.DEFAULT_DECIMALTYPE) {
                tracePrecision = true;
            }
            if (tracePrecision) {
                writer.attribute("p", dataType.getPrecision());
            }
        }
        if (dataType.hasScale() && dataType.getScale() != 0) {
            writer.attribute("s", dataType.getScale());
        }
        writer.endElement();
    }

    private IValue getValueObjectForColumn(int ordinal) {
        if (this.mCoercedColumnValues[ordinal] != null) {
            return this.mCoercedColumnValues[ordinal];
        }
        this.mCoercedColumnValues[ordinal] = this.mColumns[ordinal].getBaseRefDataItem().getDataType().createValue();
        return this.mCoercedColumnValues[ordinal];
    }

    private RSAPIColumn[] getColumnInfo() {
        return this.mColumns;
    }

    private IMember getResolvedDMRMember(ContextMember contextMember) {
        IMember member = contextMember.getMember();
        if (member != null && !contextMember.isCalculatedMember() && !contextMember.isQueryCalculation() && member instanceof IDMRMemberForOLAP) {
            return ((IDMRMemberForOLAP)((Object)member)).getOriginalMember();
        }
        return null;
    }

    private boolean useResolveDMRMember(ContextMember contextMember) {
        IMember member = contextMember.getMember();
        if (member != null && member.isDMR() && !contextMember.isCalculatedMember() && !contextMember.isQueryCalculation()) {
            if (member instanceof DMRMeasure) {
                DMRMeasure dmrMeasure = (DMRMeasure)member;
                if (dmrMeasure.useNativeV5Name()) {
                    return true;
                }
            } else {
                DMRLevel dmrLevel;
                if (member instanceof IDMRMemberForOLAP) {
                    return true;
                }
                ILevel level = member.getLevel();
                if (level instanceof DMRLevel && (dmrLevel = (DMRLevel)level).isV5LevelWrapper()) {
                    return true;
                }
            }
        }
        return false;
    }

    private IDataType getColumnRefDIDataType(int ordinal) {
        RSAPIDataItem refDataItem = this.mColumns[ordinal].getBaseRefDataItem();
        if (null == refDataItem) {
            return null;
        }
        return refDataItem.getDataType();
    }

    private static boolean getReturnDataItemNameInPartialDataset(RSAPIDataset dataset, ContextBase contextBase) {
        return dataset.isForOLAPQuery() && dataset.forDMRReport() && dataset.hasEmptyEdge() && dataset.getNumEdges() < 3 && ((ContextMember)contextBase).getMember() instanceof DMRMeasure && dataset.getReturnDataItemNameInPartialDataset();
    }
}

