/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.data.values.IRow;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.query.engine.TransformationEngine;
import com.cognos.xqe.resultset.interfaces.ITuple;
import com.cognos.xqe.resultsets.BaseIterator;
import com.cognos.xqe.resultsets.ContextBase;
import com.cognos.xqe.resultsets.ContextMember;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.XNode;
import com.cognos.xqe.runtree.olap.XMdx;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.util.pool.XQEIntegerPool;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.Date;

public abstract class XIterator
extends BaseIterator {
    protected static final String QUERY_NODES = "queryNodes";
    protected static final String NEXT_IMPL = "nextImpl";
    public static final int UNKNOWN_INT_VALUE = -1;
    protected int callId = -1;
    protected static final String TUPLE_IN = "tupleIn";
    protected static final String MAPPING_TREE_STATE = "mappingTreeState";
    protected static final String TUPLE_OUT = "tupleOut";
    protected static final String OLD_COORD = "oldCoordinate";
    protected static final String NEW_COORD = "newCoordinate";
    protected static final String APPLIED_COLUMNS = "appliedColumns";
    protected static final String IN_ROW = "inRow";
    protected static final String OUT_ROW = "outRow";
    protected long currentIndex = -1L;
    protected XQETrace iteratorTrace = null;
    protected boolean traceEnabled = false;
    protected boolean traceOpen = false;
    protected static XQELogger mErrorLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Exception", LogLevel.ERROR);

    public XIterator(XDataContext theContext, Integer id) {
        super(theContext, id);
        if (theContext.profileIterators()) {
            this.enableProfiling();
        }
    }

    public XIterator(XDataContext theContext) {
        super(theContext, TransformationEngine.DUMMY_NODEID);
    }

    @Override
    public final boolean hasNext() {
        return false;
    }

    @Override
    public long getIndex() {
        return this.currentIndex;
    }

    protected boolean openIteratorTrace(XNode aParentXNode, int edgeOrdinal, String edgeName, boolean addQueryNodes) {
        if (this.traceEnabled) {
            return this.isTraceOpen();
        }
        this.setTraceOpen(false);
        this.traceEnabled = this.context.getEnvironment().getXIteratorLogging(this.getClass().getSimpleName());
        if (!this.traceEnabled) {
            return this.isTraceOpen();
        }
        this.setTraceOpen(true);
        XQEConfiguration configuration = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        String iteratorName = this.getClass().getSimpleName();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyMMdd-HHmmssSSS");
        this.iteratorTrace = new XQETrace();
        BufferedOutputStream outputStream = null;
        String xqeLogsFolder = configuration.getXqeLogsDirectory();
        File logFile = null;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(xqeLogsFolder).append(File.separator).append(iteratorName);
        stringBuilder.append(aParentXNode.getId());
        String dash = "-";
        stringBuilder.append("-");
        long currentTime = System.currentTimeMillis();
        stringBuilder.append(dateFormat.format(new Date(currentTime)));
        if (this.context.getEnvironment().getRequestEnvironment().getReportName() != null) {
            stringBuilder.append("-");
            stringBuilder.append(this.context.getEnvironment().getRequestEnvironment().getReportName());
        }
        stringBuilder.append(".xml");
        String fileName = stringBuilder.toString();
        logFile = new File(fileName);
        try {
            outputStream = new BufferedOutputStream(new FileOutputStream(logFile));
        }
        catch (FileNotFoundException e) {
            mErrorLogger.log(e);
            this.setTraceOpen(false);
            this.traceEnabled = false;
            return this.isTraceOpen();
        }
        BufferedWriter logWriter = null;
        try {
            logWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)outputStream, "UTF-8"));
            this.iteratorTrace.addStream(logWriter);
        }
        catch (UnsupportedEncodingException uee) {
            this.traceEnabled = false;
            this.setTraceOpen(false);
            try {
                ((OutputStream)outputStream).close();
            }
            catch (IOException e) {
                mErrorLogger.log(e);
            }
            throw new XQERuntimeException(XQEMessageKeys.GEN_UnexpectedException, (Throwable)uee);
        }
        this.iteratorTrace.beginElement(iteratorName, aParentXNode.getId());
        this.iteratorTrace.attribute("edgeOrdinal", edgeOrdinal);
        this.iteratorTrace.attribute("edgeName", edgeName);
        if (addQueryNodes) {
            try {
                IXQEQueryNode[] xMdxNodes;
                this.iteratorTrace.beginElement(QUERY_NODES, -1);
                int[] mdxQuerytypes = new int[]{501017, 501053};
                for (IXQEQueryNode xMdxNode : xMdxNodes = aParentXNode.getDescendantsOfTypes(mdxQuerytypes, true)) {
                    XMdx tmpXMdx = (XMdx)xMdxNode;
                    tmpXMdx.dump(this.iteratorTrace);
                }
                this.iteratorTrace.endElement();
                this.iteratorTrace.flush();
            }
            catch (Throwable t) {
                mErrorLogger.log(t);
                this.setTraceOpen(false);
            }
        }
        return this.isTraceOpen();
    }

    protected boolean closeIteratorTrace() {
        if (this.isTraceOpen()) {
            try {
                this.iteratorTrace.endElement();
                this.iteratorTrace.flush();
                this.setTraceOpen(false);
            }
            catch (Throwable t) {
                mErrorLogger.log(t);
                this.setTraceOpen(false);
            }
        }
        return this.isTraceOpen();
    }

    public boolean isTraceOpen() {
        return this.traceOpen;
    }

    public void setTraceOpen(boolean value) {
        this.traceOpen = value;
    }

    protected boolean openNextImplTrace(int aCallId) {
        if (this.isTraceOpen()) {
            try {
                this.iteratorTrace.beginElement(NEXT_IMPL, XQEIntegerPool.getInteger(aCallId));
                this.iteratorTrace.flush();
            }
            catch (Throwable t) {
                mErrorLogger.log(t);
                this.setTraceOpen(false);
            }
        }
        return this.isTraceOpen();
    }

    protected boolean closeNextImplTrace() {
        if (this.isTraceOpen()) {
            try {
                this.iteratorTrace.endElement();
                this.iteratorTrace.flush();
            }
            catch (Throwable t) {
                mErrorLogger.log(t);
                this.setTraceOpen(false);
            }
        }
        return this.isTraceOpen();
    }

    protected void traceRow(String rowName, IRow aRow) {
        if (this.iteratorTrace == null) {
            return;
        }
        try {
            this.iteratorTrace.beginElement(rowName, -1);
            if (aRow != null) {
                for (int j = 0; j < aRow.getNumColumns(); ++j) {
                    if (aRow.getColumn(j) instanceof ContextMember) {
                        ((ContextMember)aRow.getColumn(j)).toXML(this.iteratorTrace);
                        continue;
                    }
                    if (aRow.getColumn(j) instanceof ContextBase) {
                        ((ContextBase)((Object)aRow.getColumn(j))).toXML(this.iteratorTrace);
                        continue;
                    }
                    aRow.getColumn(j).toXML(this.iteratorTrace);
                }
            }
            this.iteratorTrace.endElement();
            this.iteratorTrace.flush();
        }
        catch (Throwable t) {
            mErrorLogger.log(t);
        }
    }

    protected boolean traceInTuple(ITuple inTuple, long oldCoord) {
        if (this.isTraceOpen()) {
            try {
                this.iteratorTrace.beginElement(TUPLE_IN, -1);
                this.iteratorTrace.attribute(OLD_COORD, oldCoord);
                if (inTuple != null) {
                    inTuple.toXML(this.iteratorTrace);
                }
                this.iteratorTrace.endElement();
                this.iteratorTrace.flush();
            }
            catch (Throwable t) {
                mErrorLogger.log(t);
                this.setTraceOpen(false);
            }
        }
        return this.isTraceOpen();
    }

    protected boolean traceOutTuple(ITuple outTuple, long outTupleOldCoord, long newCoord) {
        if (this.isTraceOpen()) {
            try {
                this.iteratorTrace.beginElement(TUPLE_OUT, -1);
                this.iteratorTrace.attribute(OLD_COORD, outTupleOldCoord);
                this.iteratorTrace.attribute(NEW_COORD, newCoord);
                if (outTuple != null) {
                    StringBuilder sRuleIds = new StringBuilder("[");
                    IMember[] members = outTuple.getMembers();
                    for (int i = 0; i < members.length; ++i) {
                        if (!members[i].isContextMember()) continue;
                        sRuleIds.append(((ContextMember)members[i]).getOlapEdgeMappingColumnIdsAsString());
                        if (i == members.length - 1) continue;
                        sRuleIds.append(", ");
                    }
                    sRuleIds.append("]");
                    this.iteratorTrace.attribute(APPLIED_COLUMNS, sRuleIds);
                    outTuple.toXML(this.iteratorTrace);
                }
                this.iteratorTrace.endElement();
                this.iteratorTrace.flush();
            }
            catch (Throwable t) {
                mErrorLogger.log(t);
                this.setTraceOpen(false);
            }
        }
        return this.isTraceOpen();
    }

    protected boolean traceCountOfSourceTuples(long aSourceTupleCount) {
        if (this.isTraceOpen()) {
            try {
                this.iteratorTrace.beginElement("sourceTupleCount", -1);
                this.iteratorTrace.attribute("value", aSourceTupleCount);
                this.iteratorTrace.endElement();
                this.iteratorTrace.flush();
            }
            catch (Throwable t) {
                mErrorLogger.log(t);
                this.setTraceOpen(false);
            }
        }
        return this.isTraceOpen();
    }
}

